/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionIncreasePotency
extends RecipePotionFlaskBase {
    public MobEffect outputEffect;
    public int amplifier;
    public double ampDurationMod;

    public RecipePotionIncreasePotency(ResourceLocation id, List<Ingredient> input, MobEffect outputEffect, int amplifier, double ampDurationMod, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.outputEffect = outputEffect;
        this.amplifier = amplifier;
        this.ampDurationMod = ampDurationMod;
    }

    public RecipeSerializer<? extends RecipePotionIncreasePotency> m_7707_() {
        return BloodMagicRecipeSerializers.POTIONPOTENCY.getRecipeSerializer();
    }

    @Override
    public RecipeType<RecipePotionFlaskBase> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.POTIONFLASK.get();
    }

    @Override
    public boolean canModifyFlask(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        for (EffectHolder holder : flaskEffectList) {
            if (!holder.getPotion().equals(this.outputEffect)) continue;
            return holder.getAmplifier() < this.amplifier || holder.getAmplifier() == this.amplifier && holder.getAmpDurationMod() < this.ampDurationMod;
        }
        return false;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(MobEffect.m_19459_((MobEffect)this.outputEffect));
        buffer.writeInt(this.amplifier);
        buffer.writeDouble(this.ampDurationMod);
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        ItemStack copyStack = flaskStack.m_41777_();
        for (EffectHolder holder : flaskEffectList) {
            if (!holder.getPotion().equals(this.outputEffect)) continue;
            holder.setAmplifier(this.amplifier);
            holder.setAmpDurationMod(this.ampDurationMod);
        }
        ((ItemAlchemyFlask)copyStack.m_41720_()).setEffectHoldersOfFlask(copyStack, flaskEffectList);
        return copyStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        for (int i = 0; i < flaskEffectList.size(); ++i) {
            EffectHolder holder = flaskEffectList.get(i);
            if (!holder.getPotion().equals(this.outputEffect)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        holderList.add(new EffectHolder(this.outputEffect, 3600, 0, 1.0, 1.0));
        return holderList;
    }
}

