/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.routing.IRoutingFilterProvider;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class FilterGhostSlotPacket {
    private int ghostSlot;
    private ItemStack stack;

    public FilterGhostSlotPacket() {
    }

    public FilterGhostSlotPacket(int ghostSlot, ItemStack stack) {
        this.ghostSlot = ghostSlot;
        this.stack = stack;
    }

    public static void encode(FilterGhostSlotPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.ghostSlot);
        buf.m_130055_(pkt.stack);
    }

    public static FilterGhostSlotPacket decode(FriendlyByteBuf buf) {
        FilterGhostSlotPacket pkt = new FilterGhostSlotPacket(buf.readInt(), buf.m_130267_());
        return pkt;
    }

    public static void handle(FilterGhostSlotPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu container = sender.f_36096_;
            if (container == null) {
                return;
            }
            Slot slot = (Slot)container.f_38839_.get(message.ghostSlot);
            if (container instanceof ContainerFilter) {
                ItemStack filterStack = ((ContainerFilter)container).filterStack;
                GhostItemHelper.setItemGhostAmount(message.stack, 0);
                message.stack.m_41764_(1);
                slot.m_5852_(message.stack);
                if (filterStack.m_41720_() instanceof IRoutingFilterProvider) {
                    ItemStack filterCopy = ((IRoutingFilterProvider)filterStack.m_41720_()).getContainedStackForItem(filterStack, message.stack);
                    slot.m_5852_(filterCopy);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

