/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.forge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.util.ChatUtil;

public class TartaricForgeRecipeCategory
implements IRecipeCategory<RecipeTartaricForge> {
    public static final RecipeType<RecipeTartaricForge> RECIPE_TYPE = RecipeType.create((String)"bloodmagic", (String)"soulforge", RecipeTartaricForge.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public TartaricForgeRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BloodMagicBlocks.SOUL_FORGE.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/soulforge.png"), 0, 0, 100, 40);
    }

    public RecipeType<RecipeTartaricForge> getRecipeType() {
        return RECIPE_TYPE;
    }

    public List<Component> getTooltipStrings(RecipeTartaricForge recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 40.0 && mouseX <= 60.0 && mouseY >= 21.0 && mouseY <= 34.0) {
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.minimumsouls", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getMinimumSouls())}));
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.soulsdrained", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getSoulDrain())}));
        }
        return tooltip;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.bloodmagic.recipe.soulforge");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeTartaricForge recipe, IFocusGroup focuses) {
        ArrayList validGems = Lists.newArrayList();
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            validGems.add(will.willStack);
        }
        IRecipeSlotBuilder gems = builder.addSlot(RecipeIngredientRole.CATALYST, 43, 1);
        gems.addItemStacks((List)validGems);
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 14);
        output.addItemStack(recipe.getOutput());
        for (int index = 0; index < recipe.getInput().size(); ++index) {
            int x = index % 2;
            int y = index / 2;
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
            input.addIngredients(recipe.getInput().get(index));
        }
    }

    public static enum DefaultWill {
        SOUL(new ItemStack((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get()), 16.0),
        PETTY(new ItemStack((ItemLike)BloodMagicItems.PETTY_GEM.get()), 64.0),
        LESSER(new ItemStack((ItemLike)BloodMagicItems.LESSER_GEM.get()), 256.0),
        COMMON(new ItemStack((ItemLike)BloodMagicItems.COMMON_GEM.get()), 1024.0),
        GREATER(new ItemStack((ItemLike)BloodMagicItems.GREATER_GEM.get()), 4096.0);

        public final ItemStack willStack;
        public final double minSouls;

        private DefaultWill(ItemStack willStack, double minSouls) {
            this.willStack = willStack;
            this.minSouls = minSouls;
        }
    }
}

