/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import wayoftime.bloodmagic.api.compat.IIncensePath;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.incense.EnumTranquilityType;
import wayoftime.bloodmagic.incense.IncenseAltarHandler;
import wayoftime.bloodmagic.incense.IncenseTranquilityRegistry;
import wayoftime.bloodmagic.incense.TranquilityStack;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.util.helper.PlayerSacrificeHelper;

public class TileIncenseAltar
extends TileInventory {
    public static int maxCheckRange = 5;
    public AreaDescriptor incenseArea = new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11);
    public Map<EnumTranquilityType, Double> tranquilityMap = new HashMap<EnumTranquilityType, Double>();
    public double incenseAddition = 0.0;
    public double tranquility = 0.0;
    public int roadDistance = 0;

    public TileIncenseAltar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 1, "incensealtar", pos, state);
    }

    public TileIncenseAltar(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.INCENSE_ALTAR_TYPE.get(), pos, state);
    }

    public void tick() {
        AABB aabb = this.incenseArea.getAABB(this.m_58899_());
        List playerList = this.m_58904_().m_45976_(Player.class, aabb);
        if (playerList.isEmpty()) {
            return;
        }
        if (this.m_58904_().m_46467_() % 100L == 0L) {
            this.recheckConstruction();
        }
        boolean hasPerformed = false;
        for (Player player : playerList) {
            if (!PlayerSacrificeHelper.incrementIncense(player, 0.0, this.incenseAddition, this.incenseAddition / 100.0)) continue;
            hasPerformed = true;
        }
        if (hasPerformed && this.m_58904_().f_46441_.m_188503_(4) == 0 && this.m_58904_() instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)this.m_58904_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.2, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.02, 0.03, 0.02, 0.0);
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.tranquility = tag.m_128459_("tranquility");
        this.incenseAddition = tag.m_128459_("incenseAddition");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128347_("tranquility", this.tranquility);
        tag.m_128347_("incenseAddition", this.incenseAddition);
        return tag;
    }

    public void recheckConstruction() {
        double bonus;
        int maxLength = 11;
        int yOffset = 0;
        HashMap<EnumTranquilityType, Double> tranquilityMap = new HashMap<EnumTranquilityType, Double>();
        for (int currentDistance = 2; currentDistance < currentDistance + maxLength; ++currentDistance) {
            int i;
            boolean canFormRoad = false;
            for (i = -maxCheckRange + yOffset; i <= maxCheckRange + yOffset; ++i) {
                BlockPos verticalPos = this.f_58858_.m_7918_(0, i, 0);
                canFormRoad = true;
                block2: for (int index = 0; index < 4; ++index) {
                    Direction horizontalFacing = Direction.m_122407_((int)index);
                    BlockPos facingOffsetPos = verticalPos.m_5484_(horizontalFacing, currentDistance);
                    for (int j = -1; j <= 1; ++j) {
                        BlockPos offsetPos = facingOffsetPos.m_5484_(horizontalFacing.m_122427_(), j);
                        BlockState state = this.m_58904_().m_8055_(offsetPos);
                        Block block = state.m_60734_();
                        if (block instanceof IIncensePath && ((IIncensePath)block).getLevelOfPath(this.m_58904_(), offsetPos, state) >= currentDistance - 2) continue;
                        canFormRoad = false;
                        break block2;
                    }
                }
                if (!canFormRoad) continue;
                yOffset = i;
                break;
            }
            if (canFormRoad) {
                for (i = -currentDistance; i <= currentDistance; ++i) {
                    for (int j = -currentDistance; j <= currentDistance; ++j) {
                        if (Math.abs(i) != currentDistance && Math.abs(j) != currentDistance) continue;
                        for (int y = yOffset; y <= 2 + yOffset; ++y) {
                            BlockPos offsetPos = this.f_58858_.m_7918_(i, y, j);
                            BlockState state = this.m_58904_().m_8055_(offsetPos);
                            Block block = state.m_60734_();
                            TranquilityStack stack = IncenseTranquilityRegistry.getTranquilityOfBlock(this.m_58904_(), offsetPos, block, state);
                            if (stack == null) continue;
                            if (!tranquilityMap.containsKey((Object)stack.type)) {
                                tranquilityMap.put(stack.type, stack.value);
                                continue;
                            }
                            tranquilityMap.put(stack.type, (Double)tranquilityMap.get((Object)stack.type) + stack.value);
                        }
                    }
                }
                continue;
            }
            this.roadDistance = currentDistance - 2;
            break;
        }
        this.tranquilityMap = tranquilityMap;
        double totalTranquility = 0.0;
        for (Map.Entry entry : tranquilityMap.entrySet()) {
            totalTranquility += ((Double)entry.getValue()).doubleValue();
        }
        if (totalTranquility < 0.0) {
            return;
        }
        double appliedTranquility = 0.0;
        for (Map.Entry entry : tranquilityMap.entrySet()) {
            appliedTranquility += Math.sqrt((Double)entry.getValue());
        }
        this.incenseAddition = bonus = IncenseAltarHandler.getIncenseBonusFromComponents(this.m_58904_(), this.f_58858_, appliedTranquility, this.roadDistance);
        this.tranquility = appliedTranquility;
    }
}

