/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.Sprite;
import wayoftime.bloodmagic.client.hud.element.ElementTileInformation;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;
import wayoftime.bloodmagic.common.tile.TileIncenseAltar;
import wayoftime.bloodmagic.util.helper.InventoryHelper;

public abstract class ElementDivinedInformation<T extends BlockEntity>
extends ElementTileInformation<T> {
    private final boolean simple;

    public ElementDivinedInformation(int lines, boolean simple, Class<T> tileClass) {
        super(100, lines, tileClass);
        this.simple = simple;
    }

    @Override
    public abstract void gatherInformation(Consumer<Pair<Sprite, Function<T, String>>> var1);

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        HitResult trace = Minecraft.m_91087_().f_91077_;
        if (trace == null || trace.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockEntity tile = Minecraft.m_91087_().f_91073_.m_7702_(((BlockHitResult)trace).m_82425_());
        if (tile == null || !this.tileClass.isAssignableFrom(tile.getClass())) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        NonNullList<ItemStack> inventory = InventoryHelper.getActiveInventories((Player)player);
        boolean hasDivination = false;
        boolean hasSeer = false;
        for (ItemStack sigilStack : inventory) {
            if (sigilStack.m_41720_() instanceof ItemSigilHolding) {
                NonNullList<ItemStack> internalInv = ItemSigilHolding.getInternalInventory(sigilStack);
                int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(sigilStack);
                if (internalInv != null && !((ItemStack)internalInv.get(currentSlot)).m_41619_()) {
                    hasDivination = hasDivination || ((ItemStack)internalInv.get(currentSlot)).m_41720_() == BloodMagicItems.DIVINATION_SIGIL.get();
                    hasSeer = hasSeer || ((ItemStack)internalInv.get(currentSlot)).m_41720_() == BloodMagicItems.SEER_SIGIL.get();
                    continue;
                }
            }
            hasDivination = hasDivination || sigilStack.m_41720_() == BloodMagicItems.DIVINATION_SIGIL.get();
            if (!(hasSeer = hasSeer || sigilStack.m_41720_() == BloodMagicItems.SEER_SIGIL.get())) continue;
            break;
        }
        if (tile instanceof TileIncenseAltar) {
            return hasDivination || hasSeer;
        }
        return this.simple && hasDivination && !hasSeer || hasSeer && !this.simple;
    }
}

