/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_totem_of_undying.utils;

import com.cerbon.better_totem_of_undying.BetterTotemOfUndying;
import com.cerbon.better_totem_of_undying.config.BTUCommonConfigs;
import com.cerbon.better_totem_of_undying.utils.BTUConstants;
import com.cerbon.better_totem_of_undying.utils.ILivingEntityMixin;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class BTUUtils {
    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean canSaveFromDeath(@NotNull LivingEntity livingEntity, DamageSource damageSource) {
        ServerPlayer player;
        boolean isTotemOnCooldown = livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_36335_().m_41519_(Items.f_42747_);
        boolean isTeleportOutOfVoidEnabled = (Boolean)BTUCommonConfigs.TELEPORT_OUT_OF_VOID.get();
        BlockPos entityPos = livingEntity.m_20183_();
        Level level = livingEntity.m_9236_();
        if (BTUUtils.isDimensionBlacklisted(level) || BTUUtils.isStructureBlacklisted(entityPos, (ServerLevel)level) || BTUUtils.damageBypassInvulnerability(damageSource, livingEntity) || !isTeleportOutOfVoidEnabled && BTUUtils.isInVoid(livingEntity, damageSource) || isTotemOnCooldown) {
            return false;
        }
        ItemStack itemStack = BTUUtils.getTotemItemStack(livingEntity);
        if (itemStack != null) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)livingEntity;
                BTUUtils.giveUseStatAndCriterion(itemStack, player2);
                BTUUtils.addCooldown(itemStack, player2, (Integer)BTUCommonConfigs.COOLDOWN.get());
            }
            itemStack.m_41774_(1);
            if (((Boolean)BTUCommonConfigs.REMOVE_ALL_EFFECTS.get()).booleanValue()) {
                livingEntity.m_21219_();
            }
            livingEntity.m_21153_((float)((Integer)BTUCommonConfigs.SET_HEALTH.get()).intValue());
            BTUUtils.applyTotemEffects(livingEntity, damageSource);
            BTUUtils.increaseFoodLevel(livingEntity, (Integer)BTUCommonConfigs.SET_FOOD_LEVEL.get());
            BTUUtils.destroyBlocksWhenSuffocatingOrFullyFrozen(livingEntity, level);
            BTUUtils.knockbackMobsAway(livingEntity, level);
            BTUUtils.teleportOutOfVoid(livingEntity, level, damageSource);
            level.m_7605_((Entity)livingEntity, (byte)35);
        }
        return itemStack != null;
    }

    public static boolean isDimensionBlacklisted(@NotNull Level level) {
        return ((List)BTUCommonConfigs.BLACKLISTED_DIMENSIONS.get()).contains(level.m_46472_().m_135782_().toString());
    }

    public static boolean isStructureBlacklisted(BlockPos pos, @NotNull ServerLevel level) {
        List blackListedStructures = (List)BTUCommonConfigs.BLACKLISTED_STRUCTURES.get();
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        boolean flag = false;
        for (String structureName : blackListedStructures) {
            Structure structure = (Structure)structureRegistry.m_7745_(new ResourceLocation(structureName));
            if (structure == null || !level.m_215010_().m_220494_(pos, structure).m_73603_()) continue;
            flag = true;
        }
        return flag;
    }

    public static boolean damageBypassInvulnerability(@NotNull DamageSource damageSource, LivingEntity livingEntity) {
        return damageSource.m_269533_(DamageTypeTags.f_268738_) && !(livingEntity.m_20186_() < (double)livingEntity.m_9236_().m_141937_());
    }

    public static boolean isInVoid(LivingEntity livingEntity, @NotNull DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268724_) && livingEntity.m_20186_() < (double)livingEntity.m_9236_().m_141937_();
    }

    public static ItemStack getTotemItemStack(LivingEntity livingEntity) {
        List<ItemStack> possibleTotemStacks = BTUUtils.filterPossibleTotemStacks(BTUUtils.getTotemFromCharmSlot(livingEntity), BTUUtils.getTotemFromInventory(livingEntity), BTUUtils.getTotemFromHands(livingEntity));
        return possibleTotemStacks.stream().findFirst().orElse(null);
    }

    public static List<ItemStack> filterPossibleTotemStacks(ItemStack ... stacks) {
        return Arrays.stream(stacks).filter(Objects::nonNull).toList();
    }

    @Nullable
    public static ItemStack getTotemFromCharmSlot(LivingEntity livingEntity) {
        if (BTUUtils.isModLoaded("curios") && ((Boolean)BTUCommonConfigs.USE_TOTEM_FROM_CHARM_SLOT.get()).booleanValue()) {
            return CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, Items.f_42747_).map(SlotResult::stack).orElse(null);
        }
        return null;
    }

    @Nullable
    public static ItemStack getTotemFromInventory(LivingEntity livingEntity) {
        if (((Boolean)BTUCommonConfigs.USE_TOTEM_FROM_INVENTORY.get()).booleanValue() && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!itemStack.m_150930_(Items.f_42747_)) continue;
                return itemStack;
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getTotemFromHands(LivingEntity livingEntity) {
        for (InteractionHand interactionHand : InteractionHand.values()) {
            ItemStack itemStack = livingEntity.m_21120_(interactionHand);
            if (!itemStack.m_150930_(Items.f_42747_)) continue;
            return itemStack;
        }
        return null;
    }

    public static void giveUseStatAndCriterion(@NotNull ItemStack itemStack, ServerPlayer player) {
        if (!itemStack.m_41619_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            CriteriaTriggers.f_10551_.m_74431_(player, itemStack);
        }
    }

    public static void addCooldown(ItemStack itemStack, ServerPlayer player, int cooldown) {
        if (((Boolean)BTUCommonConfigs.ADD_COOLDOWN.get()).booleanValue()) {
            player.m_36335_().m_41524_(itemStack.m_41720_(), cooldown);
        }
    }

    public static void applyTotemEffects(LivingEntity livingEntity, DamageSource damageSource) {
        int fireResistanceEffectDuration = (Integer)BTUCommonConfigs.FIRE_RESISTANCE_DURATION.get();
        int regenerationEffectDuration = (Integer)BTUCommonConfigs.REGENERATION_DURATION.get();
        int regenerationEffectAmplifier = (Integer)BTUCommonConfigs.REGENERATION_AMPLIFIER.get();
        int absorptionEffectDuration = (Integer)BTUCommonConfigs.ABSORPTION_DURATION.get();
        int absorptionEffectAmplifier = (Integer)BTUCommonConfigs.ABSORPTION_AMPLIFIER.get();
        int waterBreathingEffectDuration = (Integer)BTUCommonConfigs.WATER_BREATHING_DURATION.get();
        if (((Boolean)BTUCommonConfigs.APPLY_EFFECTS_ONLY_WHEN_NEEDED.get()).booleanValue()) {
            if (livingEntity.m_6060_() && ((Boolean)BTUCommonConfigs.ENABLE_FIRE_RESISTANCE.get()).booleanValue()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceEffectDuration, 0));
            }
            if (livingEntity.m_20072_() && ((Boolean)BTUCommonConfigs.ENABLE_WATER_BREATHING.get()).booleanValue()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, waterBreathingEffectDuration, 0));
            }
        } else {
            if (((Boolean)BTUCommonConfigs.ENABLE_FIRE_RESISTANCE.get()).booleanValue()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceEffectDuration, 0));
            }
            if (((Boolean)BTUCommonConfigs.ENABLE_WATER_BREATHING.get()).booleanValue()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, waterBreathingEffectDuration, 0));
            }
        }
        if (((Boolean)BTUCommonConfigs.ENABLE_REGENERATION.get()).booleanValue()) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, regenerationEffectDuration, regenerationEffectAmplifier));
        }
        if (((Boolean)BTUCommonConfigs.ENABLE_ABSORPTION.get()).booleanValue()) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, absorptionEffectDuration, absorptionEffectAmplifier));
        }
        ((List)BTUCommonConfigs.CUSTOM_EFFECTS.get()).forEach(customEffectProperties -> {
            if (!customEffectProperties.isEmpty()) {
                try {
                    String damageTypeKey = (String)customEffectProperties.get(0);
                    String mobEffectKey = (String)customEffectProperties.get(1);
                    int effectDuration = (Integer)customEffectProperties.get(2);
                    int effectAmplifier = (Integer)customEffectProperties.get(3);
                    ResourceKey<DamageType> damageType = BTUUtils.getDamageTypeByKey(damageTypeKey, (ServerLevel)livingEntity.m_9236_());
                    MobEffect mobEffect = BTUUtils.getMobEffectByKey(mobEffectKey);
                    if (damageType != null && damageSource.m_276093_(damageType) || damageTypeKey.equals("any")) {
                        livingEntity.m_7292_(new MobEffectInstance(mobEffect, effectDuration, effectAmplifier));
                    }
                }
                catch (Exception e) {
                    BetterTotemOfUndying.LOGGER.error("Better Totem of Undying error: Couldn't apply custom effect. Wrong/Missing parameter: {}", customEffectProperties, (Object)e);
                }
            }
        });
    }

    public static ResourceKey<DamageType> getDamageTypeByKey(String key, ServerLevel level) {
        if (!key.equals("any")) {
            Registry damageTypeRegistry = level.m_9598_().m_175515_(Registries.f_268580_);
            return damageTypeRegistry.m_7854_((Object)Objects.requireNonNull((DamageType)damageTypeRegistry.m_7745_(new ResourceLocation(key)))).orElse(null);
        }
        return null;
    }

    public static MobEffect getMobEffectByKey(String key) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(key));
    }

    public static void increaseFoodLevel(LivingEntity livingEntity, int foodLevel) {
        int minimumFoodLevel;
        ServerPlayer player;
        int currentFoodLevel;
        if (((Boolean)BTUCommonConfigs.ENABLE_INCREASE_FOOD_LEVEL.get()).booleanValue() && livingEntity instanceof ServerPlayer && (currentFoodLevel = (player = (ServerPlayer)livingEntity).m_36324_().m_38702_()) <= (minimumFoodLevel = ((Integer)BTUCommonConfigs.MINIMUM_FOOD_LEVEL.get()).intValue())) {
            player.m_36324_().m_38705_(foodLevel);
        }
    }

    public static void destroyBlocksWhenSuffocatingOrFullyFrozen(@NotNull LivingEntity livingEntity, Level level) {
        if (BTUUtils.isInWallOrFullyFrozen(livingEntity)) {
            BlockPos blockPos = livingEntity.m_20183_();
            BlockState blockAtEntityPos = level.m_8055_(blockPos);
            BlockState blockAboveEntityPos = level.m_8055_(blockPos.m_7494_());
            if (BTUUtils.canDestroy(blockAtEntityPos)) {
                level.m_46961_(blockPos, true);
            }
            if (BTUUtils.canDestroy(blockAboveEntityPos)) {
                level.m_46961_(blockPos.m_7494_(), true);
            }
            int distance = 2;
            while (BTUUtils.isInstanceOfFallingBlock(blockPos, level, distance) && BTUUtils.canDestroy(level.m_8055_(blockPos.m_6630_(distance)))) {
                level.m_46961_(blockPos.m_6630_(distance), true);
                ++distance;
            }
        }
    }

    public static boolean isInWallOrFullyFrozen(@NotNull LivingEntity livingEntity) {
        return livingEntity.m_5830_() && (Boolean)BTUCommonConfigs.DESTROY_BLOCKS_WHEN_SUFFOCATING.get() != false || livingEntity.m_146890_() && (Boolean)BTUCommonConfigs.DESTROY_POWDER_SNOW_WHEN_FULLY_FROZEN.get() != false;
    }

    public static boolean canDestroy(@NotNull BlockState block) {
        return !block.m_204336_(BTUConstants.TOTEM_CANT_DESTROY_TAG) && !block.m_60713_(Blocks.f_50752_) && !block.m_60713_(Blocks.f_50258_);
    }

    public static boolean isInstanceOfFallingBlock(@NotNull BlockPos pos, @NotNull Level level, int distance) {
        return level.m_8055_(pos.m_6630_(distance)).m_60734_() instanceof FallingBlock;
    }

    public static void knockbackMobsAway(LivingEntity livingEntity, Level level) {
        if (((Boolean)BTUCommonConfigs.KNOCKBACK_MOBS_AWAY.get()).booleanValue()) {
            List<LivingEntity> nearbyEntities = BTUUtils.getNearbyEntities(livingEntity, level, (Double)BTUCommonConfigs.KNOCKBACK_RADIUS.get());
            double strength = (Double)BTUCommonConfigs.KNOCKBACK_STRENGTH.get();
            for (LivingEntity entity : nearbyEntities) {
                if (entity.m_7306_((Entity)livingEntity)) continue;
                entity.m_147240_(strength, livingEntity.m_20185_() - entity.m_20185_(), livingEntity.m_20189_() - entity.m_20189_());
            }
        }
    }

    @NotNull
    public static List<LivingEntity> getNearbyEntities(@NotNull LivingEntity livingEntity, @NotNull Level level, double radius) {
        return level.m_45976_(LivingEntity.class, livingEntity.m_20191_().m_82400_(radius));
    }

    public static void teleportOutOfVoid(LivingEntity livingEntity, Level level, DamageSource damageSource) {
        BlockPos lastBlockPos;
        BlockPos positionNearby;
        if (BTUUtils.isInVoid(livingEntity, damageSource) && (positionNearby = BTUUtils.randomTeleportNearby(livingEntity, level, lastBlockPos = BlockPos.m_122022_((long)((ILivingEntityMixin)livingEntity).better_totem_of_undying_getLastBlockPos()))) == null) {
            livingEntity.m_6021_((double)lastBlockPos.m_123341_(), (double)(level.m_151558_() + (Integer)BTUCommonConfigs.TELEPORT_HEIGHT_OFFSET.get()), (double)lastBlockPos.m_123343_());
            BTUUtils.applySlowFallingEffect(livingEntity);
        }
    }

    public static BlockPos randomTeleportNearby(LivingEntity livingEntity, Level level, BlockPos blockPos) {
        BlockPos teleportPos = null;
        for (int i = 0; i < 16; ++i) {
            double x = (double)blockPos.m_123341_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
            double y = Mth.m_14008_((double)((double)blockPos.m_123342_() + (double)(livingEntity.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_151558_() - 1));
            double z = (double)blockPos.m_123343_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
            BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
            if (!livingEntity.m_20984_(x, y, z, true)) continue;
            teleportPos = pos;
            livingEntity.m_183634_();
            break;
        }
        return teleportPos;
    }

    public static void applySlowFallingEffect(LivingEntity livingEntity) {
        int duration = (Integer)BTUCommonConfigs.SLOW_FALLING_DURATION.get();
        if (((Boolean)BTUCommonConfigs.ENABLE_SLOW_FALLING.get()).booleanValue()) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, duration, 0));
        }
    }
}

