/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_totem_of_undying.util;

import com.cerbon.better_totem_of_undying.BetterTotemOfUndying;
import com.cerbon.better_totem_of_undying.util.BTUConstants;
import com.cerbon.better_totem_of_undying.util.ILivingEntityMixin;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BTUUtils {
    public static boolean isModLoaded(String mod_id) {
        return FabricLoader.getInstance().isModLoaded(mod_id);
    }

    public static boolean canSaveFromDeath(@NotNull class_1309 livingEntity, class_1282 damageSource) {
        class_3222 player;
        boolean isTotemOnCooldown = livingEntity instanceof class_3222 && (player = (class_3222)livingEntity).method_7357().method_7904(class_1802.field_8288);
        boolean isTeleportOutOfVoidEnabled = BetterTotemOfUndying.CONFIG.TELEPORT_OUT_OF_VOID;
        class_2338 entityPos = livingEntity.method_24515();
        class_1937 world = livingEntity.method_37908();
        if (BTUUtils.isDimensionBlacklisted(world) || BTUUtils.isStructureBlacklisted(entityPos, (class_3218)world) || BTUUtils.damageBypassInvulnerability(damageSource, livingEntity) || !isTeleportOutOfVoidEnabled && BTUUtils.isInVoid(livingEntity, damageSource) || isTotemOnCooldown) {
            return false;
        }
        class_1799 itemStack = BTUUtils.getTotemItemStack(livingEntity);
        if (itemStack != null) {
            if (livingEntity instanceof class_3222) {
                class_3222 player2 = (class_3222)livingEntity;
                BTUUtils.giveUseStatAndCriterion(itemStack, player2);
                BTUUtils.addCooldown(itemStack, player2, BetterTotemOfUndying.CONFIG.COOLDOWN);
            }
            itemStack.method_7934(1);
            if (BetterTotemOfUndying.CONFIG.REMOVE_ALL_EFFECTS) {
                livingEntity.method_6012();
            }
            livingEntity.method_6033((float)BetterTotemOfUndying.CONFIG.SET_HEALTH);
            BTUUtils.applyTotemEffects(livingEntity, damageSource);
            BTUUtils.increaseFoodLevel(livingEntity, BetterTotemOfUndying.CONFIG.SET_FOOD_LEVEL);
            BTUUtils.destroyBlocksWhenSuffocatingOrFullyFrozen(livingEntity, world);
            BTUUtils.knockbackMobsAway(livingEntity, world);
            BTUUtils.teleportOutOfVoid(livingEntity, world, damageSource);
            livingEntity.method_37908().method_8421((class_1297)livingEntity, (byte)35);
        }
        return itemStack != null;
    }

    public static boolean isDimensionBlacklisted(@NotNull class_1937 world) {
        return BetterTotemOfUndying.CONFIG.BLACKLISTED_DIMENSIONS.contains(world.method_27983().method_29177().toString());
    }

    public static boolean isStructureBlacklisted(class_2338 pos, @NotNull class_3218 world) {
        List<String> blacklistedStructures = BetterTotemOfUndying.CONFIG.BLACKLISTED_STRUCTURES;
        class_2378 structureRegistry = world.method_27056().method_41036().method_30530(class_7924.field_41246);
        boolean flag = false;
        for (String structureName : blacklistedStructures) {
            class_3195 structure = (class_3195)structureRegistry.method_10223(new class_2960(structureName));
            if (structure == null || !world.method_27056().method_28388(pos, structure).method_16657()) continue;
            flag = true;
        }
        return flag;
    }

    public static boolean damageBypassInvulnerability(@NotNull class_1282 damageSource, class_1309 livingEntity) {
        return damageSource.method_48789(class_8103.field_42242) && !(livingEntity.method_23318() < (double)livingEntity.method_37908().method_31607());
    }

    public static boolean isInVoid(class_1309 livingEntity, @NotNull class_1282 damageSource) {
        return damageSource.method_49708(class_8111.field_42347) && livingEntity.method_23318() < (double)livingEntity.method_37908().method_31607();
    }

    public static class_1799 getTotemItemStack(class_1309 livingEntity) {
        List<class_1799> possibleTotemStacks = BTUUtils.filterPossibleTotemStacks(BTUUtils.getTotemFromTrinketsSlot(livingEntity, itemStack -> itemStack.method_31574(class_1802.field_8288)), BTUUtils.getTotemFromInventory(livingEntity), BTUUtils.getTotemFromHands(livingEntity));
        return possibleTotemStacks.stream().findFirst().orElse(null);
    }

    public static List<class_1799> filterPossibleTotemStacks(class_1799 ... stacks) {
        return Arrays.stream(stacks).filter(Objects::nonNull).toList();
    }

    @Nullable
    public static class_1799 getTotemFromTrinketsSlot(class_1309 livingEntity, Predicate<class_1799> predicate) {
        if (BTUUtils.isModLoaded("trinkets") && BetterTotemOfUndying.CONFIG.USE_TOTEM_FROM_TRINKETS_SLOT) {
            return TrinketsApi.getTrinketComponent((class_1309)livingEntity).map(component -> {
                List res = component.getEquipped(predicate);
                return res.size() > 0 ? (class_1799)((class_3545)res.get(0)).method_15441() : null;
            }).orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_1799 getTotemFromInventory(class_1309 livingEntity) {
        if (BetterTotemOfUndying.CONFIG.USE_TOTEM_FROM_INVENTORY && livingEntity instanceof class_3222) {
            class_3222 player = (class_3222)livingEntity;
            for (class_1799 itemStack : player.method_31548().field_7547) {
                if (!itemStack.method_31574(class_1802.field_8288)) continue;
                return itemStack;
            }
        }
        return null;
    }

    @Nullable
    public static class_1799 getTotemFromHands(class_1309 livingEntity) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemStack = livingEntity.method_5998(hand);
            if (!itemStack.method_31574(class_1802.field_8288)) continue;
            return itemStack;
        }
        return null;
    }

    public static void giveUseStatAndCriterion(@NotNull class_1799 itemStack, class_3222 player) {
        if (!itemStack.method_7960()) {
            player.method_7259(class_3468.field_15372.method_14956((Object)class_1802.field_8288));
            class_174.field_1204.method_9165(player, itemStack);
        }
    }

    public static void addCooldown(class_1799 itemStack, class_3222 player, int cooldown) {
        if (BetterTotemOfUndying.CONFIG.ADD_COOLDOWN) {
            player.method_7357().method_7906(itemStack.method_7909(), cooldown);
        }
    }

    public static void applyTotemEffects(class_1309 livingEntity, class_1282 damageSource) {
        int fireResistanceEffectDuration = BetterTotemOfUndying.CONFIG.FIRE_RESISTANCE_DURATION;
        int regenerationEffectDuration = BetterTotemOfUndying.CONFIG.REGENERATION_DURATION;
        int regenerationEffectAmplifier = BetterTotemOfUndying.CONFIG.REGENERATION_AMPLIFIER;
        int absorptionEffectDuration = BetterTotemOfUndying.CONFIG.ABSORPTION_DURATION;
        int absorptionEffectAmplifier = BetterTotemOfUndying.CONFIG.ABSORPTION_AMPLIFIER;
        int waterBreathingEffectDuration = BetterTotemOfUndying.CONFIG.WATER_BREATHING_DURATION;
        if (BetterTotemOfUndying.CONFIG.APPLY_EFFECTS_ONLY_WHEN_NEEDED) {
            if (livingEntity.method_5809() && BetterTotemOfUndying.CONFIG.ENABLE_FIRE_RESISTANCE) {
                livingEntity.method_6092(new class_1293(class_1294.field_5918, fireResistanceEffectDuration, 0));
            }
            if (livingEntity.method_5816() && BetterTotemOfUndying.CONFIG.ENABLE_WATER_BREATHING) {
                livingEntity.method_6092(new class_1293(class_1294.field_5923, waterBreathingEffectDuration, 0));
            }
        } else {
            if (BetterTotemOfUndying.CONFIG.ENABLE_FIRE_RESISTANCE) {
                livingEntity.method_6092(new class_1293(class_1294.field_5918, fireResistanceEffectDuration, 0));
            }
            if (BetterTotemOfUndying.CONFIG.ENABLE_WATER_BREATHING) {
                livingEntity.method_6092(new class_1293(class_1294.field_5923, waterBreathingEffectDuration, 0));
            }
        }
        if (BetterTotemOfUndying.CONFIG.ENABLE_REGENERATION) {
            livingEntity.method_6092(new class_1293(class_1294.field_5924, regenerationEffectDuration, regenerationEffectAmplifier));
        }
        if (BetterTotemOfUndying.CONFIG.ENABLE_ABSORPTION) {
            livingEntity.method_6092(new class_1293(class_1294.field_5898, absorptionEffectDuration, absorptionEffectAmplifier));
        }
        BetterTotemOfUndying.CONFIG.CUSTOM_EFFECTS.forEach(customEffectProperties -> {
            if (!customEffectProperties.isEmpty()) {
                try {
                    String damageTypeKey = (String)customEffectProperties.get(0);
                    String statusEffectKey = (String)customEffectProperties.get(1);
                    int effectDuration = Integer.parseInt((String)customEffectProperties.get(2));
                    int effectAmplifier = Integer.parseInt((String)customEffectProperties.get(3));
                    class_5321<class_8110> damageType = BTUUtils.getDamageTypeByKey(damageTypeKey, (class_3218)livingEntity.method_37908());
                    class_1291 statusEffect = BTUUtils.getStatusEffectByKey(statusEffectKey);
                    if (damageType != null && damageSource.method_49708(damageType) || damageTypeKey.equals("any")) {
                        livingEntity.method_6092(new class_1293(statusEffect, effectDuration, effectAmplifier));
                    }
                }
                catch (Exception e) {
                    BetterTotemOfUndying.LOGGER.log(Level.WARNING, "Better Totem of Undying error: Couldn't apply custom effect. Wrong/Missing parameter:" + customEffectProperties, e);
                }
            }
        });
    }

    @Nullable
    public static class_5321<class_8110> getDamageTypeByKey(@NotNull String key, class_3218 world) {
        if (!key.equals("any")) {
            class_2378 damageTypeRegistry = world.method_30349().method_30530(class_7924.field_42534);
            return damageTypeRegistry.method_29113((Object)Objects.requireNonNull((class_8110)damageTypeRegistry.method_10223(new class_2960(key)))).orElse(null);
        }
        return null;
    }

    public static class_1291 getStatusEffectByKey(String key) {
        return Objects.requireNonNull((class_1291)class_7923.field_41174.method_10223(new class_2960(key)));
    }

    public static void increaseFoodLevel(class_1309 livingEntity, int foodLevel) {
        int minimumFoodLevel;
        class_3222 player;
        int currentFoodLevel;
        if (BetterTotemOfUndying.CONFIG.ENABLE_INCREASE_FOOD_LEVEL && livingEntity instanceof class_3222 && (currentFoodLevel = (player = (class_3222)livingEntity).method_7344().method_7586()) <= (minimumFoodLevel = BetterTotemOfUndying.CONFIG.MINIMUM_FOOD_LEVEL)) {
            player.method_7344().method_7580(foodLevel);
        }
    }

    public static void destroyBlocksWhenSuffocatingOrFullyFrozen(class_1309 livingEntity, class_1937 world) {
        if (BTUUtils.isInWallOrFullyFrozen(livingEntity)) {
            class_2338 blockPos = livingEntity.method_24515();
            class_2680 blockAtEntityPos = world.method_8320(blockPos);
            class_2680 blockAboveEntityPos = world.method_8320(blockPos.method_10084());
            if (BTUUtils.canDestroy(blockAtEntityPos)) {
                world.method_22352(blockPos, true);
            }
            if (BTUUtils.canDestroy(blockAboveEntityPos)) {
                world.method_22352(blockPos.method_10084(), true);
            }
            int distance = 2;
            while (BTUUtils.isInstanceOfFallingBlock(blockPos, world, distance) && BTUUtils.canDestroy(world.method_8320(blockPos.method_10086(distance)))) {
                world.method_22352(blockPos.method_10086(distance), true);
                ++distance;
            }
        }
    }

    public static boolean isInWallOrFullyFrozen(@NotNull class_1309 livingEntity) {
        return livingEntity.method_5757() && BetterTotemOfUndying.CONFIG.DESTROY_BLOCKS_WHEN_SUFFOCATING || livingEntity.method_32314() && BetterTotemOfUndying.CONFIG.DESTROY_POWDER_SNOW_WHEN_FULLY_FROZEN;
    }

    public static boolean canDestroy(@NotNull class_2680 block) {
        return !block.method_26164(BTUConstants.TOTEM_CANT_DESTROY_TAG) && !block.method_27852(class_2246.field_9987) && !block.method_27852(class_2246.field_10398);
    }

    public static boolean isInstanceOfFallingBlock(@NotNull class_2338 pos, @NotNull class_1937 world, int distance) {
        return world.method_8320(pos.method_10086(distance)).method_26204() instanceof class_2346;
    }

    public static void knockbackMobsAway(class_1309 livingEntity, class_1937 world) {
        if (BetterTotemOfUndying.CONFIG.KNOCKBACK_MOBS_AWAY) {
            List<class_1309> nearbyEntities = BTUUtils.getNearbyEntities(livingEntity, world, BetterTotemOfUndying.CONFIG.KNOCKBACK_RADIUS);
            double strength = BetterTotemOfUndying.CONFIG.KNOCKBACK_STRENGTH;
            for (class_1309 entity : nearbyEntities) {
                if (entity.equals((Object)livingEntity)) continue;
                entity.method_6005(strength, livingEntity.method_23317() - entity.method_23317(), livingEntity.method_23321() - entity.method_23321());
            }
        }
    }

    public static List<class_1309> getNearbyEntities(@NotNull class_1309 livingEntity, @NotNull class_1937 world, double radius) {
        return world.method_8390(class_1309.class, livingEntity.method_5829().method_1014(radius), class_1309::method_5805);
    }

    public static void teleportOutOfVoid(class_1309 livingEntity, class_1937 world, class_1282 damageSource) {
        class_2338 lastBlockPos;
        class_2338 positionNearby;
        if (BTUUtils.isInVoid(livingEntity, damageSource) && (positionNearby = BTUUtils.randomTeleportNearby(livingEntity, world, lastBlockPos = class_2338.method_10092((long)((ILivingEntityMixin)livingEntity).better_totem_of_undying_getLastBlockPos()))) == null) {
            livingEntity.method_20620((double)lastBlockPos.method_10263(), (double)(((class_3218)world).method_32819() + BetterTotemOfUndying.CONFIG.TELEPORT_HEIGHT_OFFSET), (double)lastBlockPos.method_10260());
            BTUUtils.applySlowFallingEffect(livingEntity);
        }
    }

    public static class_2338 randomTeleportNearby(class_1309 livingEntity, class_1937 world, class_2338 blockPos) {
        class_2338 teleportPos = null;
        for (int i = 0; i < 16; ++i) {
            double x = (double)blockPos.method_10263() + (livingEntity.method_6051().method_43058() - 0.5) * 16.0;
            double y = class_3532.method_15350((double)((double)blockPos.method_10264() + (double)(livingEntity.method_6051().method_43048(16) - 8)), (double)world.method_31607(), (double)((class_3218)world).method_32819());
            double z = (double)blockPos.method_10260() + (livingEntity.method_6051().method_43058() - 0.5) * 16.0;
            class_2338 pos = new class_2338((int)x, (int)y, (int)z);
            if (!livingEntity.method_6082(x, y, z, true)) continue;
            teleportPos = pos;
            livingEntity.field_6017 = 0.0f;
            break;
        }
        return teleportPos;
    }

    public static void applySlowFallingEffect(class_1309 livingEntity) {
        int duration = BetterTotemOfUndying.CONFIG.SLOW_FALLING_DURATION;
        if (BetterTotemOfUndying.CONFIG.ENABLE_SLOW_FALLING) {
            livingEntity.method_6092(new class_1293(class_1294.field_5906, duration, 0));
        }
    }
}

