/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.recipe.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AbstractSingleInputRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.rituals.InfusionRitual;

public class InfusionRecipe
implements class_1860<InfusionRitual>,
UnknownReceipBookCategory {
    public static final String GROUP = "infusion";
    public static final class_3956<InfusionRecipe> TYPE = BCLRecipeManager.registerType((String)"betterend", (String)"infusion");
    public static final Serializer SERIALIZER = (Serializer)BCLRecipeManager.registerSerializer((String)"betterend", (String)"infusion", (class_1865)new Serializer());
    private final class_2960 id;
    private final class_1856[] catalysts;
    private class_1856 input;
    private class_1799 output;
    private int time = 1;
    private String group;

    private InfusionRecipe(class_2960 id) {
        this(id, null, null);
    }

    private InfusionRecipe(class_2960 id, class_1856 input, class_1799 output) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.catalysts = new class_1856[]{class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017};
    }

    public static Builder create(String id, class_1935 output) {
        return InfusionRecipe.create(BetterEnd.makeID(id), output);
    }

    public static Builder create(class_2960 id, class_1935 output) {
        return new Builder(id, output);
    }

    public static Builder create(String id, class_1799 output) {
        return InfusionRecipe.create(BetterEnd.makeID(id), output);
    }

    public static Builder create(class_2960 id, class_1799 output) {
        return new Builder(id, output);
    }

    public static Builder create(String id, class_1887 enchantment, int level) {
        return InfusionRecipe.create(BetterEnd.makeID(id), enchantment, level);
    }

    public static Builder create(class_2960 id, class_1887 enchantment, int level) {
        return new Builder(id, InfusionRecipe.createEnchantedBook(enchantment, level));
    }

    public static class_1799 createEnchantedBook(class_1887 enchantment, int level) {
        class_1799 book = new class_1799((class_1935)class_1802.field_8598);
        class_1772.method_7807((class_1799)book, (class_1889)new class_1889(enchantment, level));
        return book;
    }

    public int getInfusionTime() {
        return this.time;
    }

    public boolean matches(InfusionRitual inv, class_1937 world) {
        boolean valid = this.input.method_8093(inv.method_5438(0));
        if (!valid) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            valid &= this.catalysts[i].method_8093(inv.method_5438(i + 1));
        }
        return valid;
    }

    public class_1799 assemble(InfusionRitual ritual, class_5455 acc) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.input);
        defaultedList.addAll(Arrays.asList(this.catalysts));
        return defaultedList;
    }

    public class_1799 method_8110(class_5455 acc) {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    public static void register() {
    }

    public static class Builder
    extends AbstractSingleInputRecipeBuilder<Builder, InfusionRecipe> {
        private final class_1856[] catalysts = new class_1856[]{class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017, class_1856.field_9017};
        private int time = 1;

        protected Builder(class_2960 id, class_1935 output) {
            this(id, new class_1799(output, 1));
        }

        protected Builder(class_2960 id, class_1799 output) {
            super(id, output);
        }

        public Builder setGroup(String group) {
            return (Builder)super.setGroup(group);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(class_1935 input) {
            super.setPrimaryInputAndUnlock(new class_1935[]{input});
            return this;
        }

        public Builder setTime(int time) {
            this.time = time;
            return this;
        }

        public Builder addCatalyst(Catalysts slot, class_1935 ... items) {
            this.catalysts[slot.index] = class_1856.method_8091((class_1935[])items);
            return this;
        }

        public Builder addCatalyst(Catalysts slot, class_1799 stack) {
            this.catalysts[slot.index] = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            return this;
        }

        public Builder addCatalyst(Catalysts slot, class_6862<class_1792> tag) {
            this.catalysts[slot.index] = class_1856.method_8106(tag);
            return this;
        }

        protected boolean checkRecipe() {
            if (this.time < 0) {
                BCLib.LOGGER.warning("Time should be positive, recipe {} will be ignored!", new Object[]{this.id});
                return false;
            }
            return super.checkRecipe();
        }

        protected void serializeRecipeData(JsonObject root) {
            super.serializeRecipeData(root);
            if (this.time != 1) {
                root.addProperty("time", (Number)this.time);
            }
            JsonObject catalystObject = new JsonObject();
            for (Catalysts cat : Catalysts.values()) {
                if (this.catalysts[cat.index] == null || this.catalysts[cat.index].method_8103()) continue;
                catalystObject.add(cat.key, ItemUtil.toJsonIngredientWithNBT((class_1856)this.catalysts[cat.index]));
            }
            root.add("catalysts", (JsonElement)catalystObject);
        }

        protected class_1865<InfusionRecipe> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Serializer
    implements class_1865<InfusionRecipe> {
        private class_1856 readIngredient(JsonObject obj, String key) {
            if (obj.has(key)) {
                JsonElement el = obj.get(key);
                if (el.isJsonObject()) {
                    JsonObject o = el.getAsJsonObject();
                    if (o.has("tag")) {
                        class_1856 res = ItemUtil.fromJsonIngredientWithNBT((JsonObject)o);
                        if (res == null) {
                            return class_1856.field_9017;
                        }
                        return res;
                    }
                    class_1856 res = class_1856.method_8101((class_1799[])new class_1799[]{ItemUtil.fromJsonRecipeWithNBT((JsonObject)o)});
                    if (res == null) {
                        return class_1856.field_9017;
                    }
                    return res;
                }
                if (el.isJsonArray()) {
                    class_1856 res = class_1856.method_52177((JsonElement)el);
                    if (res == null) {
                        return class_1856.field_9017;
                    }
                    return res;
                }
                if (obj.isJsonPrimitive()) {
                    String s = class_3518.method_15253((JsonObject)obj, (String)key, (String)"");
                    class_1799 catalyst = ItemUtil.fromStackString((String)s);
                    return catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
                }
                throw new IllegalStateException("Invalid catalyst ingredient for " + key + ": " + el.toString());
            }
            return class_1856.field_9017;
        }

        public InfusionRecipe fromJson(class_2960 id, JsonObject json) {
            InfusionRecipe recipe = new InfusionRecipe(id);
            JsonObject inputObject = class_3518.method_15296((JsonObject)json, (String)"input");
            recipe.input = ItemUtil.fromJsonIngredientWithNBT((JsonObject)inputObject);
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            recipe.output = ItemUtil.fromJsonRecipeWithNBT((JsonObject)result);
            if (recipe.output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            recipe.group = class_3518.method_15253((JsonObject)json, (String)"group", (String)InfusionRecipe.GROUP);
            recipe.time = class_3518.method_15282((JsonObject)json, (String)"time", (int)1);
            JsonObject catalysts = class_3518.method_15296((JsonObject)json, (String)"catalysts");
            for (Catalysts cat : Catalysts.values()) {
                recipe.catalysts[cat.index] = this.readIngredient(catalysts, cat.key);
            }
            return recipe;
        }

        public InfusionRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            InfusionRecipe recipe = new InfusionRecipe(id);
            recipe.input = class_1856.method_8086((class_2540)buffer);
            recipe.output = buffer.method_10819();
            recipe.group = buffer.method_19772();
            recipe.time = buffer.method_10816();
            for (int i = 0; i < 8; ++i) {
                recipe.catalysts[i] = class_1856.method_8086((class_2540)buffer);
            }
            return recipe;
        }

        public void toNetwork(class_2540 buffer, InfusionRecipe recipe) {
            recipe.input.method_8088(buffer);
            buffer.method_10793(recipe.output);
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.time);
            for (int i = 0; i < 8; ++i) {
                recipe.catalysts[i].method_8088(buffer);
            }
        }
    }

    public static enum Catalysts {
        NORTH(0, "north"),
        NORTH_EAST(1, "north_east"),
        EAST(2, "east"),
        SOUTH_EAST(3, "south_east"),
        SOUTH(4, "south"),
        SOUTH_WEST(5, "south_west"),
        WEST(6, "west"),
        NORTH_WEST(7, "north_west");

        public final int index;
        public final String key;

        private Catalysts(int index, String key) {
            this.index = index;
            this.key = key;
        }
    }
}

