/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.util.RomanNumeral;
import org.joml.Matrix4f;

public class EMIAnvilRecipeCategory
extends EmiRecipeCategory {
    private final int anvilLevel;
    private final List<class_5481> titleLines;

    public EMIAnvilRecipeCategory(class_2960 id, EmiRenderable icon, int anvilLevel) {
        super(id, icon);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public EMIAnvilRecipeCategory(class_2960 id, EmiRenderable icon, EmiRenderable simplified, int anvilLevel) {
        super(id, icon, simplified);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public EMIAnvilRecipeCategory(class_2960 id, EmiRenderable icon, EmiTexture simplified, Comparator<EmiRecipe> sorter, int anvilLevel) {
        super(id, icon, (EmiRenderable)simplified, sorter);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public void renderSimplified(class_332 guiGraphics, int x, int y, float delta) {
        super.renderSimplified(guiGraphics, x, y, delta);
        class_327 font = class_310.method_1551().field_1772;
        String content = RomanNumeral.toRoman(this.anvilLevel);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        int xx = x + 19 - 2 - font.method_1727(content);
        int yy = y + 6 + 3;
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        font.method_27521(content, (float)(xx - 1), (float)(yy - 1), -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)xx, (float)(yy - 1), -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)(xx + 1), (float)(yy - 1), -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)(xx - 1), (float)yy, -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)(xx + 1), (float)yy, -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)(xx - 1), (float)(yy + 1), -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)(xx + 1), (float)(yy + 1), -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)xx, (float)(yy + 1), -16777216, false, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_27521(content, (float)xx, (float)yy, -1, true, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        bufferSource.method_22993();
    }

    public List<class_5684> getTooltip() {
        List list = super.getTooltip();
        if (!this.titleLines.isEmpty()) {
            ArrayList newList = Lists.newArrayList();
            for (class_5481 line : this.titleLines) {
                newList.add(class_5684.method_32662((class_5481)line));
            }
            if (list.size() > 0) {
                list.remove(0);
            }
            newList.addAll(list);
            return newList;
        }
        return list;
    }
}

