/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.config;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_3518;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.FileContentWrapper;
import org.betterx.bclib.config.ConfigKey;
import org.betterx.bclib.config.ConfigWriter;
import org.betterx.bclib.util.JsonFactory;
import org.betterx.bclib.util.Pair;
import org.jetbrains.annotations.Nullable;

public final class ConfigKeeper {
    private final Map<ConfigKey, Entry<?>> configEntries = Maps.newHashMap();
    private final ConfigWriter writer;
    private JsonObject configObject;
    private boolean changed = false;

    public ConfigKeeper(String modID, String group) {
        this.writer = new ConfigWriter(modID, group);
        this.configObject = this.writer.load();
    }

    public File getConfigFile() {
        return this.writer.getConfigFile();
    }

    boolean compareAndUpdateForSync(FileContentWrapper content) {
        ByteArrayInputStream inputStream = content.getInputStream();
        JsonObject other = JsonFactory.getJsonObject(inputStream);
        boolean changed = this.compareAndUpdateForSync(other);
        if (changed) {
            ByteArrayOutputStream outStream = content.getEmptyOutputStream();
            JsonFactory.storeJson(outStream, (JsonElement)this.configObject);
            content.syncWithOutputStream();
        }
        return changed;
    }

    boolean compareAndUpdateForSync(JsonObject other) {
        return ConfigKeeper.compareAndUpdateForSync(this.configObject, other);
    }

    private static Pair<JsonElement, Pair<String, String>> find(JsonObject json, Pair<String, String> key) {
        String kk = (String)key.first + (String)key.second;
        for (Map.Entry entry : json.entrySet()) {
            Pair<String, String> otherKey = ConfigKey.realKey((String)entry.getKey());
            if (!kk.equals(entry)) continue;
            return new Pair<JsonElement, Pair<String, String>>((JsonElement)entry.getValue(), otherKey);
        }
        return null;
    }

    static boolean compareAndUpdateForSync(JsonObject me, JsonObject other) {
        boolean changed = false;
        for (Map.Entry otherEntry : other.entrySet()) {
            Pair<String, String> otherKey = ConfigKey.realKey((String)otherEntry.getKey());
            JsonElement otherValue = (JsonElement)otherEntry.getValue();
            Pair<JsonElement, Pair<String, String>> temp = ConfigKeeper.find(me, otherKey);
            if (temp != null) {
                Pair myKey = (Pair)temp.second;
                JsonElement myValue = (JsonElement)temp.first;
                if (otherValue.isJsonNull() && !myValue.isJsonNull() || otherValue.isJsonPrimitive() && !myValue.isJsonPrimitive() || otherValue.isJsonObject() && !myValue.isJsonObject() || otherValue.isJsonArray() && !myValue.isJsonArray()) {
                    changed = true;
                    me.add((String)myKey.first + (String)myKey.second, otherValue);
                    continue;
                }
                if (otherValue.isJsonPrimitive() || otherValue.isJsonArray() || otherValue.isJsonNull()) {
                    if (otherValue.equals(myValue)) continue;
                    changed = true;
                    me.add((String)myKey.first + (String)myKey.second, otherValue);
                    continue;
                }
                if (!otherValue.isJsonObject()) continue;
                changed |= ConfigKeeper.compareAndUpdateForSync(myValue.getAsJsonObject(), otherValue.getAsJsonObject());
                continue;
            }
            if (otherValue.isJsonNull()) continue;
            changed = true;
            temp = ConfigKeeper.find(me, otherKey);
            me.add((String)otherKey.first + (String)otherKey.second, otherValue);
        }
        return changed;
    }

    public void save() {
        if (!this.changed) {
            return;
        }
        this.writer.save();
        this.changed = false;
    }

    void reload() {
        this.configObject = this.writer.reload();
        this.configEntries.clear();
        this.changed = false;
    }

    private <T, E extends Entry<T>> void initializeEntry(ConfigKey key, E entry) {
        if (this.configObject == null) {
            return;
        }
        String[] path = key.getPath();
        JsonObject obj = this.configObject;
        if (!key.isRoot()) {
            for (String group : path) {
                JsonElement element = obj.get(group);
                if (element == null || !element.isJsonObject()) {
                    element = new JsonObject();
                    obj.add(group, element);
                }
                obj = element.getAsJsonObject();
            }
        }
        Object paramKey = key.getEntry();
        if (entry.hasDefaultInName()) {
            paramKey = (String)paramKey + " [default: " + entry.getDefault() + "]";
        }
        this.changed |= entry.setLocation(obj, (String)paramKey);
    }

    private <T, E extends Entry<T>> void storeValue(E entry, T value) {
        if (this.configObject == null) {
            return;
        }
        T val = entry.getValue();
        if (value.equals(val)) {
            return;
        }
        entry.toJson(value);
        this.changed = true;
    }

    private <T, E extends Entry<T>> T getValue(E entry) {
        if (!entry.hasLocation()) {
            return entry.getDefault();
        }
        return entry.fromJson();
    }

    @Nullable
    public <T, E extends Entry<T>> E getEntry(ConfigKey key, Class<E> type) {
        Entry<?> entry = this.configEntries.get(key);
        if (type.isInstance(entry)) {
            return (E)((Entry)type.cast(entry));
        }
        return null;
    }

    @Nullable
    public <T, E extends Entry<T>> T getValue(ConfigKey key, Class<E> type) {
        E entry = this.getEntry(key, type);
        if (entry == null) {
            return null;
        }
        return ((Entry)entry).getValue();
    }

    public <T, E extends Entry<T>> E registerEntry(ConfigKey key, E entry) {
        entry.setWriter(value -> this.storeValue(entry, value));
        entry.setReader(() -> this.getValue(entry));
        this.initializeEntry(key, entry);
        this.configEntries.put(key, entry);
        return entry;
    }

    public static abstract class Entry<T> {
        protected final T defaultValue;
        protected Consumer<T> writer;
        protected Supplier<T> reader;
        protected JsonObject location;
        protected String key;

        public abstract T fromJson();

        public abstract void toJson(T var1);

        public Entry(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected void setWriter(Consumer<T> writer) {
            this.writer = writer;
        }

        protected void setReader(Supplier<T> reader) {
            this.reader = reader;
        }

        protected boolean setLocation(JsonObject location, String key) {
            this.location = location;
            this.key = key;
            if (!location.has(key)) {
                this.toJson(this.defaultValue);
                return true;
            }
            return false;
        }

        protected boolean hasLocation() {
            return this.location != null && this.key != null;
        }

        public T getValue() {
            return this.reader.get();
        }

        public void setValue(T value) {
            this.writer.accept(value);
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public void setDefault() {
            this.setValue(this.defaultValue);
        }

        protected boolean hasDefaultInName() {
            return true;
        }
    }

    public static abstract class RangeEntry<T extends Comparable<T>>
    extends Entry<T> {
        private final T min;
        private final T max;

        public RangeEntry(T defaultValue, T minVal, T maxVal) {
            super(defaultValue);
            this.min = minVal;
            this.max = maxVal;
        }

        @Override
        public void setValue(T value) {
            super.setValue(value.compareTo(this.min) < 0 ? this.min : (value.compareTo(this.max) > 0 ? this.max : value));
        }

        public T minValue() {
            return this.min;
        }

        public T maxValue() {
            return this.max;
        }
    }

    public static class EnumEntry<T extends Enum<T>>
    extends Entry<T> {
        private final Type type;

        public EnumEntry(T defaultValue) {
            super(defaultValue);
            TypeToken token = new TypeToken<T>(){
                private static final long serialVersionUID = 1L;
            };
            this.type = token.getType();
        }

        @Override
        public T getDefault() {
            return (T)((Enum)this.defaultValue);
        }

        @Override
        public T fromJson() {
            return (T)((Enum)JsonFactory.GSON.fromJson(this.location.get(this.key), this.type));
        }

        @Override
        public void toJson(T value) {
            this.location.addProperty(this.key, JsonFactory.GSON.toJson(value, this.type));
        }
    }

    public static class StringArrayEntry
    extends ArrayEntry<String> {
        public StringArrayEntry(List<String> defaultValue) {
            super(defaultValue);
        }

        @Override
        protected String getValue(JsonElement el) {
            return el.getAsString();
        }

        @Override
        protected void add(JsonArray array, String el) {
            array.add(el);
        }

        @Override
        protected boolean hasDefaultInName() {
            return false;
        }
    }

    public static abstract class ArrayEntry<T>
    extends Entry<List<T>> {
        public ArrayEntry(List<T> defaultValue) {
            super(defaultValue);
        }

        protected abstract T getValue(JsonElement var1);

        protected abstract void add(JsonArray var1, T var2);

        private JsonArray toArray(List<T> input) {
            JsonArray array = new JsonArray();
            input.forEach(s -> this.add(array, s));
            return array;
        }

        @Override
        public List<T> fromJson() {
            JsonArray resArray = class_3518.method_15292((JsonObject)this.location, (String)this.key, (JsonArray)this.toArray((List)this.defaultValue));
            ArrayList res = new ArrayList(resArray.size());
            resArray.forEach(e -> res.add(this.getValue((JsonElement)e)));
            return res;
        }

        @Override
        public void toJson(List<T> value) {
            this.location.add(this.key, (JsonElement)this.toArray(value));
        }
    }

    public static class StringEntry
    extends Entry<String> {
        public StringEntry(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public String fromJson() {
            return class_3518.method_15253((JsonObject)this.location, (String)this.key, (String)((String)this.defaultValue));
        }

        @Override
        public void toJson(String value) {
            this.location.addProperty(this.key, value);
        }
    }

    public static class IntegerRange
    extends RangeEntry<Integer> {
        public IntegerRange(Integer defaultValue, int minVal, int maxVal) {
            super(defaultValue, minVal, maxVal);
        }

        @Override
        public Integer fromJson() {
            return class_3518.method_15282((JsonObject)this.location, (String)this.key, (int)((Integer)this.defaultValue));
        }

        @Override
        public void toJson(Integer value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class IntegerEntry
    extends Entry<Integer> {
        public IntegerEntry(Integer defaultValue) {
            super(defaultValue);
        }

        @Override
        public Integer getDefault() {
            return (Integer)this.defaultValue;
        }

        @Override
        public Integer fromJson() {
            return class_3518.method_15282((JsonObject)this.location, (String)this.key, (int)((Integer)this.defaultValue));
        }

        @Override
        public void toJson(Integer value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class FloatRange
    extends RangeEntry<Float> {
        public FloatRange(Float defaultValue, float minVal, float maxVal) {
            super(defaultValue, Float.valueOf(minVal), Float.valueOf(maxVal));
        }

        @Override
        public Float fromJson() {
            return Float.valueOf(class_3518.method_15277((JsonObject)this.location, (String)this.key, (float)((Float)this.defaultValue).floatValue()));
        }

        @Override
        public void toJson(Float value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class FloatEntry
    extends Entry<Float> {
        public FloatEntry(Float defaultValue) {
            super(defaultValue);
        }

        @Override
        public Float fromJson() {
            return Float.valueOf(class_3518.method_15277((JsonObject)this.location, (String)this.key, (float)((Float)this.defaultValue).floatValue()));
        }

        @Override
        public void toJson(Float value) {
            this.location.addProperty(this.key, (Number)value);
        }
    }

    public static class BooleanEntry
    extends Entry<Boolean> {
        public BooleanEntry(Boolean defaultValue) {
            super(defaultValue);
        }

        @Override
        public Boolean fromJson() {
            return class_3518.method_15258((JsonObject)this.location, (String)this.key, (boolean)((Boolean)this.defaultValue));
        }

        @Override
        public void toJson(Boolean value) {
            this.location.addProperty(this.key, value);
        }
    }
}

