/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.ConfigKeeper;
import org.betterx.bclib.config.ConfigKey;
import org.betterx.bclib.config.PathConfig;

public class BiomesConfig
extends PathConfig {
    private Map<BiomeAPI.BiomeType, List<String>> BIOME_INCLUDE_LIST = null;
    private Map<BiomeAPI.BiomeType, List<String>> BIOME_EXCLUDE_LIST = null;
    public static final BiomeAPI.BiomeType[] endTypes = new BiomeAPI.BiomeType[]{BiomeAPI.BiomeType.END_LAND, BiomeAPI.BiomeType.END_VOID, BiomeAPI.BiomeType.END_CENTER, BiomeAPI.BiomeType.END_BARRENS};
    public static final BiomeAPI.BiomeType[] netherTypes = new BiomeAPI.BiomeType[]{BiomeAPI.BiomeType.NETHER};
    private static final BiomeAPI.BiomeType[] includeTypes = BiomesConfig.all();
    private static final BiomeAPI.BiomeType[] excludeTypes = new BiomeAPI.BiomeType[]{BiomeAPI.BiomeType.NETHER, BiomeAPI.BiomeType.END};

    public BiomesConfig() {
        super("bclib", "biomes", true);
        for (BiomeAPI.BiomeType type : includeTypes) {
            this.keeper.registerEntry(new ConfigKey(type.getName(), "force_include"), new ConfigKeeper.StringArrayEntry(Collections.EMPTY_LIST));
        }
        for (BiomeAPI.BiomeType type : excludeTypes) {
            this.keeper.registerEntry(new ConfigKey(type.getName(), "force_exclude"), new ConfigKeeper.StringArrayEntry(Collections.EMPTY_LIST));
        }
    }

    private static BiomeAPI.BiomeType[] all() {
        BiomeAPI.BiomeType[] res = new BiomeAPI.BiomeType[endTypes.length + netherTypes.length];
        System.arraycopy(netherTypes, 0, res, 0, netherTypes.length);
        System.arraycopy(endTypes, 0, res, netherTypes.length, endTypes.length);
        return res;
    }

    private List<String> getBiomeIncludeList(BiomeAPI.BiomeType type) {
        ConfigKeeper.StringArrayEntry entry = this.getEntry("force_include", type.getName(), ConfigKeeper.StringArrayEntry.class);
        if (entry == null) {
            return List.of();
        }
        return (List)entry.getValue();
    }

    private List<String> getBiomeExcludeList(BiomeAPI.BiomeType type) {
        ConfigKeeper.StringArrayEntry entry = this.getEntry("force_exclude", type.getName(), ConfigKeeper.StringArrayEntry.class);
        if (entry == null) {
            return List.of();
        }
        return (List)entry.getValue();
    }

    public List<String> getIncludeMatching(BiomeAPI.BiomeType type) {
        return this.getBiomeIncludeMap().entrySet().stream().filter(e -> ((BiomeAPI.BiomeType)e.getKey()).is(type)).map(e -> (List)e.getValue()).flatMap(Collection::stream).toList();
    }

    public List<String> getExcludeMatching(BiomeAPI.BiomeType type) {
        return this.getBiomeExcludeMap().entrySet().stream().filter(e -> ((BiomeAPI.BiomeType)e.getKey()).is(type)).map(e -> (List)e.getValue()).flatMap(Collection::stream).toList();
    }

    public Map<BiomeAPI.BiomeType, List<String>> getBiomeIncludeMap() {
        if (this.BIOME_INCLUDE_LIST == null) {
            this.BIOME_INCLUDE_LIST = new HashMap<BiomeAPI.BiomeType, List<String>>();
            for (BiomeAPI.BiomeType type : includeTypes) {
                this.BIOME_INCLUDE_LIST.put(type, this.getBiomeIncludeList(type));
            }
        }
        return this.BIOME_INCLUDE_LIST;
    }

    public Map<BiomeAPI.BiomeType, List<String>> getBiomeExcludeMap() {
        if (this.BIOME_EXCLUDE_LIST == null) {
            this.BIOME_EXCLUDE_LIST = new HashMap<BiomeAPI.BiomeType, List<String>>();
            for (BiomeAPI.BiomeType type : excludeTypes) {
                this.BIOME_EXCLUDE_LIST.put(type, this.getBiomeExcludeList(type));
            }
        }
        return this.BIOME_EXCLUDE_LIST;
    }
}

