/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.config;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.balm.fabric.config.FabricConfigSaver;
import net.blay09.mods.balm.fabric.config.notoml.Notoml;
import net.blay09.mods.balm.fabric.config.notoml.NotomlError;
import net.blay09.mods.balm.fabric.config.notoml.NotomlParser;
import org.slf4j.Logger;

public class FabricConfigLoader {
    private static final Logger logger = LogUtils.getLogger();

    public static void load(File configFile, BalmConfigData configData) throws IOException {
        Notoml notoml = new Notoml();
        if (configFile.exists()) {
            try {
                String input = Files.readString(configFile.toPath());
                notoml = NotomlParser.parse(input);
            }
            catch (IOException e) {
                logger.error("Failed to load config file {}", (Object)configFile, (Object)e);
            }
        }
        for (String category : notoml.getProperties().rowKeySet()) {
            Object categoryInstance;
            if (category.isEmpty()) {
                categoryInstance = configData;
            } else {
                try {
                    Field categoryField = configData.getClass().getField(category);
                    categoryInstance = categoryField.get(configData);
                }
                catch (NoSuchFieldException e) {
                    notoml.addError(new NotomlError("Unknown config category: '" + category + "'"));
                    continue;
                }
                catch (IllegalAccessException e) {
                    notoml.addError(new NotomlError("Error loading config category: '" + category + "'", e));
                    continue;
                }
            }
            Map properties = notoml.getProperties().row((Object)category);
            for (Map.Entry propertyEntry : properties.entrySet()) {
                String property = (String)propertyEntry.getKey();
                Object value = propertyEntry.getValue();
                try {
                    Field propertyField = categoryInstance.getClass().getField(property);
                    ExpectedType expectedTypeAnnotation = propertyField.getAnnotation(ExpectedType.class);
                    Class<?> innerType = expectedTypeAnnotation != null ? expectedTypeAnnotation.value() : null;
                    try {
                        Object convertedValue = FabricConfigLoader.convertValue(value, propertyField.getType(), innerType);
                        if (convertedValue == null) continue;
                        propertyField.set(categoryInstance, convertedValue);
                    }
                    catch (IllegalArgumentException e) {
                        String expectedValueType = FabricConfigLoader.getExpectedValueTypeMessage(propertyField.getType(), innerType);
                        notoml.addError(new NotomlError("Invalid value for config property [" + category + "] '" + property + "': '" + value + "', expected " + expectedValueType));
                    }
                }
                catch (NoSuchFieldException e) {
                    notoml.addError(new NotomlError("Unknown config property: [" + category + "] '" + property + "'"));
                }
                catch (Exception e) {
                    notoml.addError(new NotomlError("Error loading config property [" + category + "] '" + property + "'", e));
                }
            }
        }
        if (notoml.hasErrors()) {
            logger.error("Errors were encountered when loading the config file {}:", (Object)configFile.getName());
            for (NotomlError error : notoml.getErrors()) {
                if (error.hasLine()) {
                    logger.error("- {} near line {}", new Object[]{error.getMessage(), error.getLine(), error.getCause()});
                    continue;
                }
                logger.error("- {}", (Object)error.getMessage(), (Object)error.getCause());
            }
            File backupFile = FabricConfigLoader.getBackupConfigFile(configFile);
            configFile.renameTo(backupFile);
            FabricConfigSaver.save(configFile, configData);
            logger.error("The affected properties have been reset to their defaults and a backup of the corrupted version was created under {}", (Object)backupFile.getName());
        } else {
            Notoml updated = FabricConfigSaver.toNotoml(configData);
            if (!notoml.containsProperties(updated)) {
                logger.info("The config file {} is missing some properties.", (Object)configFile.getName());
                File backupFile = FabricConfigLoader.getBackupConfigFile(configFile);
                configFile.renameTo(backupFile);
                FabricConfigSaver.save(configFile, configData);
                logger.info("The missing properties have been added and a backup of the previous version was created under {}", (Object)backupFile.getName());
            }
        }
        FabricConfigSaver.save(new File(configFile.getParentFile(), "balm-common.out.toml"), configData);
    }

    private static File getBackupConfigFile(File configFile) {
        File backupFile;
        int i = 1;
        do {
            backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak" + i);
            ++i;
        } while (backupFile.exists());
        return backupFile;
    }

    private static String getExpectedValueTypeMessage(Class<?> type, Class<?> innerType) {
        if (type == Integer.class || type == Integer.TYPE) {
            return "integer";
        }
        if (type == Long.class || type == Long.TYPE) {
            return "integer";
        }
        if (type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE) {
            return "floating point number";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "boolean (true or false)";
        }
        if (type == String.class) {
            return "string";
        }
        if (type == List.class) {
            return "list of " + FabricConfigLoader.getExpectedValueTypeMessage(innerType, null);
        }
        if (Enum.class.isAssignableFrom(type)) {
            Enum[] enumConstants = (Enum[])type.getEnumConstants();
            return "enum value (" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(enumConstants).map(Enum::name).toArray(String[]::new)) + ")";
        }
        return null;
    }

    private static Object convertValue(Object value, Class<?> type, Class<?> innerType) {
        if (type == Integer.class || type == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid integer value: '" + value + "'", e);
                }
            }
        } else if (type == Long.class || type == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                try {
                    return Long.parseLong((String)value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid integer value: '" + value + "'", e);
                }
            }
        } else if (type == Double.class || type == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    return Double.parseDouble(stringValue.replace(',', '.'));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid floating point value: '" + value + "'", e);
                }
            }
        } else if (type == Float.class || type == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    return Float.valueOf(Float.parseFloat(stringValue.replace(',', '.')));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid floating point value: '" + value + "'", e);
                }
            }
        } else {
            if (type == String.class) {
                if (value instanceof String) {
                    return value;
                }
                return value.toString();
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                if (value instanceof Number) {
                    return ((Number)value).intValue() != 0;
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    if (stringValue.equalsIgnoreCase("true")) {
                        return true;
                    }
                    if (stringValue.equalsIgnoreCase("false")) {
                        return false;
                    }
                    throw new IllegalArgumentException("Invalid boolean value: '" + value + "'");
                }
                if (value instanceof Boolean) {
                    return value;
                }
            } else {
                if (type == List.class) {
                    if (value instanceof List) {
                        List list = (List)value;
                        ArrayList<Object> convertedList = new ArrayList<Object>();
                        for (Object entry : list) {
                            Object convertedEntry = FabricConfigLoader.convertValue(entry, innerType, null);
                            if (convertedEntry == null) continue;
                            convertedList.add(convertedEntry);
                        }
                        return convertedList;
                    }
                    if (value.getClass() == innerType) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(value);
                        return list;
                    }
                    throw new IllegalArgumentException("Invalid list value: '" + value + "'");
                }
                if (Enum.class.isAssignableFrom(type)) {
                    if (value instanceof String) {
                        try {
                            return FabricConfigLoader.parseEnumValue(type, (String)value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid enum value: '" + value + "'", e);
                        }
                    }
                    throw new IllegalArgumentException("Invalid enum value: '" + value + "'");
                }
            }
        }
        return null;
    }

    private static Object parseEnumValue(Class<?> type, String value) {
        for (Object enumConstant : type.getEnumConstants()) {
            if (!enumConstant.toString().equalsIgnoreCase(value)) continue;
            return enumConstant;
        }
        return null;
    }
}

