/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.config;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.config.AbstractBalmConfig;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.fabric.config.FabricConfigLoader;
import net.blay09.mods.balm.fabric.config.FabricConfigSaver;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class FabricBalmConfig
extends AbstractBalmConfig {
    private static final Logger logger = LogUtils.getLogger();
    private final Map<Class<?>, BalmConfigData> configs = new HashMap();

    @Override
    public <T extends BalmConfigData> T initializeBackingConfig(Class<T> clazz) {
        String configName = this.getConfigName(clazz);
        File configFile = this.getConfigFile(configName);
        BalmConfigData configData = (BalmConfigData)this.createConfigDataInstance(clazz);
        if (configFile.exists()) {
            try {
                FabricConfigLoader.load(configFile, configData);
            }
            catch (IOException e) {
                logger.error("Failed to load config file {}", (Object)configFile, (Object)e);
            }
        } else {
            try {
                FabricConfigSaver.save(configFile, configData);
            }
            catch (IOException e) {
                logger.error("Failed to generate config file {}", (Object)configFile, (Object)e);
            }
        }
        this.configs.put(clazz, configData);
        return (T)configData;
    }

    @Override
    public <T extends BalmConfigData> T getBackingConfig(Class<T> clazz) {
        return (T)this.configs.get(clazz);
    }

    @Override
    public <T extends BalmConfigData> void saveBackingConfig(Class<T> clazz) {
        String configName = this.getConfigName(clazz);
        File configFile = this.getConfigFile(configName);
        try {
            FabricConfigSaver.save(configFile, this.configs.get(clazz));
        }
        catch (IOException e) {
            logger.error("Failed to save config file {}", (Object)configFile, (Object)e);
        }
    }

    @Override
    public File getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }
}

