/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.model;

import artifacts.client.item.ArtifactLayers;
import artifacts.client.item.RendererUtil;
import artifacts.extensions.pocketpiston.LivingEntityExtensions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class ArmsModel
extends HumanoidModel<LivingEntity> {
    public ArmsModel(ModelPart part, Function<ResourceLocation, RenderType> renderType) {
        super(part, renderType);
    }

    public ArmsModel(ModelPart part) {
        this(part, RenderType::m_110458_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102812_, (Object)this.f_102811_);
    }

    public void renderArm(HumanoidArm handSide, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_102851_((HumanoidArm)handSide).f_104207_ = true;
        this.m_102851_((HumanoidArm)handSide.m_20828_()).f_104207_ = false;
        this.m_7695_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static ArmsModel createClawsModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.claws(hasSlimArms)));
    }

    public static ArmsModel createGloveModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.glove(hasSlimArms)));
    }

    public static ArmsModel createGoldenHookModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.goldenHook(hasSlimArms)));
    }

    public static ArmsModel createPocketPistonModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.pocketPiston(hasSlimArms))){

            public void m_6973_(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                HumanoidArm mainHandSide = RendererUtil.getArmSide(entity, entity.f_20912_);
                this.getPistonHead((HumanoidArm)mainHandSide.m_20828_()).f_104201_ = 0.0f;
                this.getPistonHead((HumanoidArm)mainHandSide).f_104201_ = ((LivingEntityExtensions)entity).artifacts$getPocketPistonLength() * 2.0f;
            }

            private ModelPart getPistonHead(HumanoidArm arm) {
                return this.m_102851_(arm).m_171324_("artifact").m_171324_("piston_head");
            }
        };
    }

    public static ArmsModel createOnionRingModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.onionRing(hasSlimArms)));
    }

    public static ArmsModel createPickaxeHeaterModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.pickaxeHeater(hasSlimArms)));
    }

    public static MeshDefinition createEmptyArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean hasSlimArms) {
        MeshDefinition mesh = ArmsModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        mesh.m_171576_().m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        mesh.m_171576_().m_171597_("left_arm").m_171599_("artifact", leftArm, PartPose.m_171419_((float)(-1.0f + armWidth / 2.0f), (float)10.0f, (float)0.0f));
        mesh.m_171576_().m_171597_("right_arm").m_171599_("artifact", rightArm, PartPose.m_171419_((float)(1.0f - armWidth / 2.0f), (float)10.0f, (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean hasSlimArms) {
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        leftArm.m_171514_(0, 0);
        leftArm.m_171488_(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new CubeDeformation(0.5f));
        rightArm.m_171514_(16, 0);
        rightArm.m_171488_(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new CubeDeformation(0.5f));
        return ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }

    public static MeshDefinition createSleevedArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean hasSlimArms) {
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        leftArm.m_171514_(0, 16);
        leftArm.m_171488_(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new CubeDeformation(0.75f));
        rightArm.m_171514_(16, 16);
        rightArm.m_171488_(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new CubeDeformation(0.75f));
        return ArmsModel.createArms(leftArm, rightArm, hasSlimArms);
    }

    public static MeshDefinition createSleevedArms(boolean hasSlimArms) {
        return ArmsModel.createSleevedArms(CubeListBuilder.m_171558_(), CubeListBuilder.m_171558_(), hasSlimArms);
    }

    public static MeshDefinition createClaws(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        leftArm.m_171514_(0, 0);
        leftArm.m_171481_(hasSlimArms ? -2.0f : -1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 1.0f);
        rightArm.m_171514_(8, 0);
        rightArm.m_171481_(hasSlimArms ? -1.0f : -1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 1.0f);
        leftArm.m_171514_(0, 6);
        leftArm.m_171481_(hasSlimArms ? -2.0f : -1.5f, 0.0f, 0.5f, 3.0f, 5.0f, 1.0f);
        rightArm.m_171514_(8, 6);
        rightArm.m_171481_(hasSlimArms ? -1.0f : -1.5f, 0.0f, 0.5f, 3.0f, 5.0f, 1.0f);
        leftArm.m_171514_(16, 0);
        leftArm.m_171481_(hasSlimArms ? 1.0f : 1.5f, 0.0f, -1.5f, 1.0f, 4.0f, 1.0f);
        rightArm.m_171514_(20, 0);
        rightArm.m_171481_(hasSlimArms ? -2.0f : -2.5f, 0.0f, -1.5f, 1.0f, 4.0f, 1.0f);
        leftArm.m_171514_(16, 6);
        leftArm.m_171481_(hasSlimArms ? 1.0f : 1.5f, 0.0f, 0.5f, 1.0f, 4.0f, 1.0f);
        rightArm.m_171514_(20, 6);
        rightArm.m_171481_(hasSlimArms ? -2.0f : -2.5f, 0.0f, 0.5f, 1.0f, 4.0f, 1.0f);
        return ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }

    public static MeshDefinition createGoldenHook(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        leftArm.m_171514_(32, 0);
        leftArm.m_171481_(-2.5f, 2.0f, -0.5f, 5.0f, 5.0f, 1.0f);
        rightArm.m_171514_(48, 0);
        rightArm.m_171481_(-2.5f, 2.0f, -0.5f, 5.0f, 5.0f, 1.0f);
        leftArm.m_171514_(32, 6);
        leftArm.m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        rightArm.m_171514_(48, 6);
        rightArm.m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        return ArmsModel.createSleevedArms(leftArm, rightArm, hasSlimArms);
    }

    public static MeshDefinition createPocketPiston(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        CubeListBuilder leftPistonHead = CubeListBuilder.m_171558_();
        CubeListBuilder rightPistonHead = CubeListBuilder.m_171558_();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float d = 0.135f;
        CubeDeformation baseDeformation = new CubeDeformation(d * armWidth, d * 3.0f, d * armDepth);
        leftArm.m_171514_(0, 0);
        leftArm.m_171488_(-armWidth / 2.0f, -3.0f, -armDepth / 2.0f, armWidth, 3.0f, armDepth, baseDeformation);
        rightArm.m_171514_(16, 0);
        rightArm.m_171488_(-armWidth / 2.0f, -3.0f, -armDepth / 2.0f, armWidth, 3.0f, armDepth, baseDeformation);
        CubeDeformation rodDeformation = new CubeDeformation(d * armWidth / 2.0f, 0.0f, d * armDepth / 2.0f);
        leftPistonHead.m_171514_(0, 12);
        leftPistonHead.m_171488_(-(armWidth - 2.0f) / 2.0f, -2.0f + d * 3.0f, -(armDepth - 2.0f) / 2.0f, armWidth - 2.0f, 2.0f, armDepth - 2.0f, rodDeformation);
        rightPistonHead.m_171514_(16, 12);
        rightPistonHead.m_171488_(-(armWidth - 2.0f) / 2.0f, -2.0f + d * 3.0f, -(armDepth - 2.0f) / 2.0f, armWidth - 2.0f, 2.0f, armDepth - 2.0f, rodDeformation);
        CubeDeformation headDeformation = new CubeDeformation(d * armWidth, d, d * armDepth);
        leftPistonHead.m_171514_(0, 7);
        leftPistonHead.m_171488_(-armWidth / 2.0f, d * 3.0f + d, -armDepth / 2.0f, armWidth, 1.0f, armDepth, headDeformation);
        rightPistonHead.m_171514_(16, 7);
        rightPistonHead.m_171488_(-armWidth / 2.0f, d * 3.0f + d, -armDepth / 2.0f, armWidth, 1.0f, armDepth, headDeformation);
        MeshDefinition mesh = ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
        mesh.m_171576_().m_171597_("left_arm").m_171597_("artifact").m_171599_("piston_head", leftPistonHead, PartPose.f_171404_);
        mesh.m_171576_().m_171597_("right_arm").m_171597_("artifact").m_171599_("piston_head", rightPistonHead, PartPose.f_171404_);
        return mesh;
    }

    public static MeshDefinition createOnionRing(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float h = -4.0f;
        leftArm.m_171514_(0, 0);
        leftArm.m_171481_(-1.0f - armWidth / 2.0f, h, -1.0f - armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.m_171514_(16, 0);
        rightArm.m_171481_(-1.0f - armWidth / 2.0f, h, -1.0f - armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.m_171514_(0, 3);
        leftArm.m_171481_(-1.0f - armWidth / 2.0f, h, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.m_171514_(16, 3);
        rightArm.m_171481_(-1.0f - armWidth / 2.0f, h, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.m_171514_(0, 6);
        leftArm.m_171481_(armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.m_171514_(16, 6);
        rightArm.m_171481_(armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        leftArm.m_171514_(0, 12);
        leftArm.m_171481_(-1.0f - armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.m_171514_(16, 12);
        rightArm.m_171481_(-1.0f - armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        return ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }

    public static MeshDefinition createPickaxeHeater(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float deformationY = 1.0833334f;
        CubeDeformation deformation = new CubeDeformation(0.0f, 0.083333336f, 0.25f);
        leftArm.m_171514_(32, 0);
        leftArm.m_171488_(armWidth / 2.0f + 0.5f, 0.5f - 2.0f * deformationY - 1.0f, -armDepth / 4.0f, 1.0f, 2.0f, 2.0f, deformation);
        rightArm.m_171514_(48, 0);
        rightArm.m_171488_(-armWidth / 2.0f - 1.5f, 0.5f - 2.0f * deformationY - 1.0f, -armDepth / 4.0f, 1.0f, 2.0f, 2.0f, deformation);
        return ArmsModel.createSleevedArms(leftArm, rightArm, hasSlimArms);
    }
}

