/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.model;

import artifacts.client.item.ArtifactLayers;
import artifacts.client.item.RendererUtil;
import artifacts.extensions.pocketpiston.LivingEntityExtensions;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_572;
import net.minecraft.class_630;

public class ArmsModel
extends class_572<class_1309> {
    public ArmsModel(class_630 part, Function<class_2960, class_1921> renderType) {
        super(part, renderType);
    }

    public ArmsModel(class_630 part) {
        this(part, class_1921::method_23578);
    }

    protected Iterable<class_630> method_22946() {
        return ImmutableList.of();
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.field_27433, (Object)this.field_3401);
    }

    public void renderArm(class_1306 handSide, class_4587 matrixStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.method_2808((class_1306)handSide).field_3665 = true;
        this.method_2808((class_1306)handSide.method_5928()).field_3665 = false;
        this.method_2828(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static ArmsModel createClawsModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.claws(hasSlimArms)));
    }

    public static ArmsModel createGloveModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.glove(hasSlimArms)));
    }

    public static ArmsModel createGoldenHookModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.goldenHook(hasSlimArms)));
    }

    public static ArmsModel createPocketPistonModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.pocketPiston(hasSlimArms))){

            public void method_17087(class_1309 entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                super.method_17087(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                class_1306 mainHandSide = RendererUtil.getArmSide(entity, entity.field_6266);
                this.getPistonHead((class_1306)mainHandSide.method_5928()).field_3656 = 0.0f;
                this.getPistonHead((class_1306)mainHandSide).field_3656 = ((LivingEntityExtensions)entity).artifacts$getPocketPistonLength() * 2.0f;
            }

            private class_630 getPistonHead(class_1306 arm) {
                return this.method_2808(arm).method_32086("artifact").method_32086("piston_head");
            }
        };
    }

    public static ArmsModel createOnionRingModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.onionRing(hasSlimArms)));
    }

    public static ArmsModel createPickaxeHeaterModel(boolean hasSlimArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.pickaxeHeater(hasSlimArms)));
    }

    public static class_5609 createEmptyArms(class_5606 leftArm, class_5606 rightArm, boolean hasSlimArms) {
        class_5609 mesh = ArmsModel.method_32011((class_5605)class_5605.field_27715, (float)0.0f);
        mesh.method_32111().method_32117("left_arm", class_5606.method_32108(), class_5603.field_27701);
        mesh.method_32111().method_32117("right_arm", class_5606.method_32108(), class_5603.field_27701);
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        mesh.method_32111().method_32116("left_arm").method_32117("artifact", leftArm, class_5603.method_32090((float)(-1.0f + armWidth / 2.0f), (float)10.0f, (float)0.0f));
        mesh.method_32111().method_32116("right_arm").method_32117("artifact", rightArm, class_5603.method_32090((float)(1.0f - armWidth / 2.0f), (float)10.0f, (float)0.0f));
        return mesh;
    }

    public static class_5609 createArms(class_5606 leftArm, class_5606 rightArm, boolean hasSlimArms) {
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        leftArm.method_32101(0, 0);
        leftArm.method_32098(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new class_5605(0.5f));
        rightArm.method_32101(16, 0);
        rightArm.method_32098(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new class_5605(0.5f));
        return ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }

    public static class_5609 createSleevedArms(class_5606 leftArm, class_5606 rightArm, boolean hasSlimArms) {
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        leftArm.method_32101(0, 16);
        leftArm.method_32098(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new class_5605(0.75f));
        rightArm.method_32101(16, 16);
        rightArm.method_32098(-armWidth / 2.0f, -12.0f, -2.0f, armWidth, 12.0f, 4.0f, new class_5605(0.75f));
        return ArmsModel.createArms(leftArm, rightArm, hasSlimArms);
    }

    public static class_5609 createSleevedArms(boolean hasSlimArms) {
        return ArmsModel.createSleevedArms(class_5606.method_32108(), class_5606.method_32108(), hasSlimArms);
    }

    public static class_5609 createClaws(boolean hasSlimArms) {
        class_5606 leftArm = class_5606.method_32108();
        class_5606 rightArm = class_5606.method_32108();
        leftArm.method_32101(0, 0);
        leftArm.method_32097(hasSlimArms ? -2.0f : -1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 1.0f);
        rightArm.method_32101(8, 0);
        rightArm.method_32097(hasSlimArms ? -1.0f : -1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 1.0f);
        leftArm.method_32101(0, 6);
        leftArm.method_32097(hasSlimArms ? -2.0f : -1.5f, 0.0f, 0.5f, 3.0f, 5.0f, 1.0f);
        rightArm.method_32101(8, 6);
        rightArm.method_32097(hasSlimArms ? -1.0f : -1.5f, 0.0f, 0.5f, 3.0f, 5.0f, 1.0f);
        leftArm.method_32101(16, 0);
        leftArm.method_32097(hasSlimArms ? 1.0f : 1.5f, 0.0f, -1.5f, 1.0f, 4.0f, 1.0f);
        rightArm.method_32101(20, 0);
        rightArm.method_32097(hasSlimArms ? -2.0f : -2.5f, 0.0f, -1.5f, 1.0f, 4.0f, 1.0f);
        leftArm.method_32101(16, 6);
        leftArm.method_32097(hasSlimArms ? 1.0f : 1.5f, 0.0f, 0.5f, 1.0f, 4.0f, 1.0f);
        rightArm.method_32101(20, 6);
        rightArm.method_32097(hasSlimArms ? -2.0f : -2.5f, 0.0f, 0.5f, 1.0f, 4.0f, 1.0f);
        return ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }

    public static class_5609 createGoldenHook(boolean hasSlimArms) {
        class_5606 leftArm = class_5606.method_32108();
        class_5606 rightArm = class_5606.method_32108();
        leftArm.method_32101(32, 0);
        leftArm.method_32097(-2.5f, 2.0f, -0.5f, 5.0f, 5.0f, 1.0f);
        rightArm.method_32101(48, 0);
        rightArm.method_32097(-2.5f, 2.0f, -0.5f, 5.0f, 5.0f, 1.0f);
        leftArm.method_32101(32, 6);
        leftArm.method_32097(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        rightArm.method_32101(48, 6);
        rightArm.method_32097(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        return ArmsModel.createSleevedArms(leftArm, rightArm, hasSlimArms);
    }

    public static class_5609 createPocketPiston(boolean hasSlimArms) {
        class_5606 leftArm = class_5606.method_32108();
        class_5606 rightArm = class_5606.method_32108();
        class_5606 leftPistonHead = class_5606.method_32108();
        class_5606 rightPistonHead = class_5606.method_32108();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float d = 0.135f;
        class_5605 baseDeformation = new class_5605(d * armWidth, d * 3.0f, d * armDepth);
        leftArm.method_32101(0, 0);
        leftArm.method_32098(-armWidth / 2.0f, -3.0f, -armDepth / 2.0f, armWidth, 3.0f, armDepth, baseDeformation);
        rightArm.method_32101(16, 0);
        rightArm.method_32098(-armWidth / 2.0f, -3.0f, -armDepth / 2.0f, armWidth, 3.0f, armDepth, baseDeformation);
        class_5605 rodDeformation = new class_5605(d * armWidth / 2.0f, 0.0f, d * armDepth / 2.0f);
        leftPistonHead.method_32101(0, 12);
        leftPistonHead.method_32098(-(armWidth - 2.0f) / 2.0f, -2.0f + d * 3.0f, -(armDepth - 2.0f) / 2.0f, armWidth - 2.0f, 2.0f, armDepth - 2.0f, rodDeformation);
        rightPistonHead.method_32101(16, 12);
        rightPistonHead.method_32098(-(armWidth - 2.0f) / 2.0f, -2.0f + d * 3.0f, -(armDepth - 2.0f) / 2.0f, armWidth - 2.0f, 2.0f, armDepth - 2.0f, rodDeformation);
        class_5605 headDeformation = new class_5605(d * armWidth, d, d * armDepth);
        leftPistonHead.method_32101(0, 7);
        leftPistonHead.method_32098(-armWidth / 2.0f, d * 3.0f + d, -armDepth / 2.0f, armWidth, 1.0f, armDepth, headDeformation);
        rightPistonHead.method_32101(16, 7);
        rightPistonHead.method_32098(-armWidth / 2.0f, d * 3.0f + d, -armDepth / 2.0f, armWidth, 1.0f, armDepth, headDeformation);
        class_5609 mesh = ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
        mesh.method_32111().method_32116("left_arm").method_32116("artifact").method_32117("piston_head", leftPistonHead, class_5603.field_27701);
        mesh.method_32111().method_32116("right_arm").method_32116("artifact").method_32117("piston_head", rightPistonHead, class_5603.field_27701);
        return mesh;
    }

    public static class_5609 createOnionRing(boolean hasSlimArms) {
        class_5606 leftArm = class_5606.method_32108();
        class_5606 rightArm = class_5606.method_32108();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float h = -4.0f;
        leftArm.method_32101(0, 0);
        leftArm.method_32097(-1.0f - armWidth / 2.0f, h, -1.0f - armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.method_32101(16, 0);
        rightArm.method_32097(-1.0f - armWidth / 2.0f, h, -1.0f - armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.method_32101(0, 3);
        leftArm.method_32097(-1.0f - armWidth / 2.0f, h, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.method_32101(16, 3);
        rightArm.method_32097(-1.0f - armWidth / 2.0f, h, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.method_32101(0, 6);
        leftArm.method_32097(armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.method_32101(16, 6);
        rightArm.method_32097(armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        leftArm.method_32101(0, 12);
        leftArm.method_32097(-1.0f - armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.method_32101(16, 12);
        rightArm.method_32097(-1.0f - armWidth / 2.0f, h, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        return ArmsModel.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }

    public static class_5609 createPickaxeHeater(boolean hasSlimArms) {
        class_5606 leftArm = class_5606.method_32108();
        class_5606 rightArm = class_5606.method_32108();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float deformationY = 1.0833334f;
        class_5605 deformation = new class_5605(0.0f, 0.083333336f, 0.25f);
        leftArm.method_32101(32, 0);
        leftArm.method_32098(armWidth / 2.0f + 0.5f, 0.5f - 2.0f * deformationY - 1.0f, -armDepth / 4.0f, 1.0f, 2.0f, 2.0f, deformation);
        rightArm.method_32101(48, 0);
        rightArm.method_32098(-armWidth / 2.0f - 1.5f, 0.5f - 2.0f * deformationY - 1.0f, -armDepth / 4.0f, 1.0f, 2.0f, 2.0f, deformation);
        return ArmsModel.createSleevedArms(leftArm, rightArm, hasSlimArms);
    }
}

