/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.common.mixin.ChatComponentAccessor;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.Style;
import net.minecraftforge.network.NetworkEvent;

public class PacketNoSpamChatMessage {
    private final Component message;
    private final int messageChannelId;
    private final boolean overlayMessage;
    private static final int MESSAGE_ID = "ars_nouveau".hashCode();
    private static final MessageSignature AN_SIGNATURE;

    public PacketNoSpamChatMessage(Component message, int messageChannelId, boolean overlayMessage) {
        this.message = message;
        this.messageChannelId = MESSAGE_ID + messageChannelId;
        this.overlayMessage = overlayMessage;
    }

    public PacketNoSpamChatMessage(FriendlyByteBuf buf) {
        this.message = buf.m_130238_();
        this.messageChannelId = buf.readInt();
        this.overlayMessage = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130083_(this.message);
        buf.writeInt(this.messageChannelId);
        buf.writeBoolean(this.overlayMessage);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (this.overlayMessage) {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_(this.message, true);
                }
            } else {
                ChatComponent gui = Minecraft.m_91087_().f_91065_.m_93076_();
                ChatComponentAccessor chatComponentAccessor = (ChatComponentAccessor)gui;
                chatComponentAccessor.getAllMessages().removeIf(m -> m.f_240905_() != null && m.f_240905_().equals((Object)AN_SIGNATURE));
                gui.m_93769_();
                gui.m_240964_((Component)this.message.m_6879_().m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), AN_SIGNATURE, GuiMessageTag.m_240701_());
            }
        });
        ctx.setPacketHandled(true);
    }

    static {
        byte[] bytes = new byte[256];
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)random.nextInt(127);
        }
        AN_SIGNATURE = new MessageSignature(bytes);
    }
}

