/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AtlasStructureLandmark;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.StructureTileProvider;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3816;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7151;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class StructureTileProviders
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final StructureTileProviders INSTANCE = new StructureTileProviders();
    public static final class_2960 ID = AntiqueAtlas.id("structures");
    private final Map<class_2960, StructureTileProvider> startTiles = new HashMap<class_2960, StructureTileProvider>();
    private final Map<class_2960, StructureTileProvider> typeTiles = new HashMap<class_2960, StructureTileProvider>();
    private final Map<class_2960, StructureTileProvider> tagTiles = new HashMap<class_2960, StructureTileProvider>();
    private final Map<class_2960, StructureTileProvider> pieceTypeTiles = new HashMap<class_2960, StructureTileProvider>();
    private final Map<class_2960, StructureTileProvider> pieceJigsawSingleTiles = new HashMap<class_2960, StructureTileProvider>();
    private final Map<class_2960, StructureTileProvider> pieceJigsawFeatureTiles = new HashMap<class_2960, StructureTileProvider>();
    private final Map<class_2960, MarkerTexture> startMarkers = new HashMap<class_2960, MarkerTexture>();
    private final Map<class_2960, MarkerTexture> typeMarkers = new HashMap<class_2960, MarkerTexture>();
    private final Map<class_2960, MarkerTexture> tagMarkers = new HashMap<class_2960, MarkerTexture>();
    private final Map<class_2960, MarkerTexture> pieceTypeMarkers = new HashMap<class_2960, MarkerTexture>();
    private final Map<class_2960, MarkerTexture> pieceJigsawSingleMarkers = new HashMap<class_2960, MarkerTexture>();
    private final Map<class_2960, MarkerTexture> pieceJigsawFeatureMarkers = new HashMap<class_2960, MarkerTexture>();
    private final Map<ProviderType, Pair<Map<class_2960, StructureTileProvider>, Map<class_2960, MarkerTexture>>> PROVIDER_MAPS = Map.of(ProviderType.START, Pair.of(this.startTiles, this.startMarkers), ProviderType.TYPE, Pair.of(this.typeTiles, this.typeMarkers), ProviderType.TAG, Pair.of(this.tagTiles, this.tagMarkers), ProviderType.PIECE_TYPE, Pair.of(this.pieceTypeTiles, this.pieceTypeMarkers), ProviderType.JIGSAW_SINGLE, Pair.of(this.pieceJigsawSingleTiles, this.pieceJigsawSingleMarkers), ProviderType.JIGSAW_FEATURE, Pair.of(this.pieceJigsawFeatureTiles, this.pieceJigsawFeatureMarkers));

    public static StructureTileProviders getInstance() {
        return INSTANCE;
    }

    public StructureTileProviders() {
        super(new Gson(), "atlas/structure");
    }

    public Map<class_1923, TileTexture> resolve(Map<class_1923, TileTexture> outTiles, Map<class_1923, StructureTileProvider> structureProviders, Map<class_1923, String> tilePredicates, StructurePieceSummary piece, class_1937 world) {
        if (piece instanceof JigsawPieceSummary) {
            JigsawPieceSummary jigsawPiece = (JigsawPieceSummary)piece;
            if (this.pieceJigsawSingleTiles.containsKey(jigsawPiece.getId())) {
                StructureTileProvider provider = (jigsawPiece.getElementType() == class_3816.field_16971 ? this.pieceJigsawFeatureTiles : this.pieceJigsawSingleTiles).get(jigsawPiece.getId());
                provider.getTextures(world, jigsawPiece.method_14935(), jigsawPiece.getJunctions(), tilePredicates).forEach((pos, texture) -> {
                    if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                        return;
                    }
                    outTiles.put((class_1923)pos, (TileTexture)texture);
                    structureProviders.put((class_1923)pos, provider);
                });
                return outTiles;
            }
        } else {
            class_2960 pieceTypeId = class_7923.field_41146.method_10221((Object)piece.method_16653());
            if (this.pieceTypeTiles.containsKey(pieceTypeId)) {
                StructureTileProvider provider = this.pieceTypeTiles.get(pieceTypeId);
                provider.getTextures(world, piece.method_14935(), tilePredicates).forEach((pos, texture) -> {
                    if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                        return;
                    }
                    outTiles.put((class_1923)pos, (TileTexture)texture);
                    structureProviders.put((class_1923)pos, provider);
                });
            }
        }
        return outTiles;
    }

    public void resolve(Map<class_1923, TileTexture> outTiles, Map<class_1923, StructureTileProvider> structureProviders, Map<class_1923, String> debugPredicates, Map<Landmark<?>, MarkerTexture> outMarkers, class_1937 world, class_5321<class_3195> key, class_1923 pos, StructureStartSummary summary, class_5321<class_7151<?>> type, Collection<class_6862<class_3195>> tags) {
        if (this.startMarkers.containsKey(key.method_29177())) {
            texture = this.startMarkers.get(key.method_29177());
            outMarkers.put(new AtlasStructureLandmark(pos.method_33943(0), ProviderType.START, key.method_29177()), texture);
        } else if (type != null && this.typeMarkers.containsKey(type.method_29177())) {
            texture = this.typeMarkers.get(type.method_29177());
            outMarkers.put(new AtlasStructureLandmark(pos.method_33943(0), ProviderType.TYPE, type.method_29177()), texture);
        } else {
            this.tagMarkers.entrySet().stream().filter(entry -> tags.contains(class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)((class_2960)entry.getKey())))).findFirst().ifPresent(entry -> outMarkers.put(new AtlasStructureLandmark(pos.method_33943(0), ProviderType.TAG, (class_2960)entry.getKey()), (MarkerTexture)entry.getValue()));
        }
        if (this.startTiles.containsKey(key.method_29177())) {
            provider = this.startTiles.get(key.method_29177());
            provider.getTextures(world, summary.getBoundingBox(), debugPredicates).forEach((pos2, texture) -> {
                if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                    return;
                }
                outTiles.put((class_1923)pos2, (TileTexture)texture);
                structureProviders.put((class_1923)pos2, provider);
            });
        } else if (type != null && this.typeTiles.containsKey(type.method_29177())) {
            provider = this.typeTiles.get(key.method_29177());
            provider.getTextures(world, summary.getBoundingBox(), debugPredicates).forEach((pos2, texture) -> {
                if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                    return;
                }
                outTiles.put((class_1923)pos2, (TileTexture)texture);
                structureProviders.put((class_1923)pos2, provider);
            });
        } else {
            tags.stream().filter(t -> this.tagTiles.containsKey(t.comp_327())).findFirst().ifPresent(tag -> {
                StructureTileProvider provider = this.tagTiles.get(tag.comp_327());
                provider.getTextures(world, summary.getBoundingBox(), debugPredicates).forEach((pos2, texture) -> {
                    if (structureProviders.containsKey(pos) && ((StructureTileProvider)structureProviders.get(pos)).priority() < provider.priority()) {
                        return;
                    }
                    outTiles.put((class_1923)pos2, (TileTexture)texture);
                    structureProviders.put((class_1923)pos2, provider);
                });
            });
        }
        summary.getChildren().forEach(p -> this.resolve(outTiles, structureProviders, debugPredicates, (StructurePieceSummary)p, world));
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Structure Tile / Marker Providers...");
        Map<class_2960, TileTexture> textures = TileTextures.getInstance().getTextures();
        HashSet<TileTexture> unusedTextures = new HashSet<TileTexture>(textures.values().stream().filter(t -> t.id().method_12832().startsWith("structure")).toList());
        this.PROVIDER_MAPS.values().forEach(p -> ((Map)p.left()).clear());
        this.PROVIDER_MAPS.values().forEach(p -> ((Map)p.right()).clear());
        for (Map.Entry<class_2960, JsonElement> fileEntry : prepared.entrySet()) {
            class_2960 fileId = fileEntry.getKey();
            this.PROVIDER_MAPS.forEach((providerType, pair) -> {
                Map providerMap = (Map)pair.left();
                Map markerMap = (Map)pair.right();
                if (fileId.method_12832().startsWith(providerType.prefix())) {
                    class_2960 id = new class_2960(fileId.method_12836(), fileId.method_12832().substring(providerType.prefix().length()));
                    try {
                        JsonObject fileJson = ((JsonElement)fileEntry.getValue()).getAsJsonObject();
                        if (fileJson.has("textures")) {
                            JsonElement textureJson = fileJson.get("textures");
                            int priority = fileJson.has("priority") ? fileJson.get("priority").getAsInt() : 999;
                            List<TileTexture> defaultTextures = BiomeTileProviders.resolveTextureJson(textures, textureJson);
                            if (defaultTextures != null) {
                                StructureTileProvider provider = new StructureTileProvider(id, priority, defaultTextures);
                                providerMap.put(provider.id(), provider);
                                unusedTextures.removeAll(provider.allTextures());
                            } else {
                                JsonObject textureObject = textureJson.getAsJsonObject();
                                HashMap<StructureTileProvider.ChunkMatcher, List<TileTexture>> matchers = new HashMap<StructureTileProvider.ChunkMatcher, List<TileTexture>>();
                                for (String matcherKey : textureObject.keySet()) {
                                    class_2960 matcherId = matcherKey.contains(":") ? new class_2960(matcherKey) : AntiqueAtlas.id(matcherKey);
                                    StructureTileProvider.ChunkMatcher matcher = StructureTileProvider.getChunkMatcher(matcherId);
                                    if (matcher == null) {
                                        throw new IllegalStateException("Matcher %s does not exist!".formatted(matcherId.toString()));
                                    }
                                    List<TileTexture> matcherTextures = BiomeTileProviders.resolveTextureJson(textures, textureObject.get(matcherKey));
                                    if (matcherTextures == null) {
                                        throw new IllegalStateException("Malformed object %s in textures object!".formatted(matcherId.toString()));
                                    }
                                    matcherTextures.forEach(unusedTextures::remove);
                                    matchers.put(matcher, matcherTextures);
                                }
                                if (matchers.isEmpty()) {
                                    throw new IllegalStateException("No matcher keys were found in the textures object!");
                                }
                                StructureTileProvider provider = new StructureTileProvider(id, priority, matchers);
                                providerMap.put(provider.id(), provider);
                                unusedTextures.removeAll(provider.allTextures());
                            }
                        }
                        if (fileJson.has("markers")) {
                            JsonElement markerJson = fileJson.get("markers");
                            class_2960 markerTextureId = new class_2960(markerJson.getAsString());
                            MarkerTexture texture = MarkerTextures.getInstance().asMap().get(markerTextureId);
                            if (texture == null) {
                                throw new IllegalStateException("Marker texture %s does not exist!".formatted(markerTextureId));
                            }
                            AntiqueAtlas.CONFIG.structureMarkers.putIfAbsent(fileId.toString(), true);
                            if (AntiqueAtlas.CONFIG.structureMarkers.get(fileId.toString()).booleanValue()) {
                                markerMap.put(id, texture);
                            }
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlas.LOGGER.error("[Antique Atlas] Error reading structure tile provider {}!", (Object)fileId, (Object)e);
                    }
                }
            });
        }
        for (TileTexture texture : unusedTextures) {
            AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} isn't referenced by any structure tile provider!", (Object)texture.displayId());
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(TileTextures.ID, MarkerTextures.ID);
    }

    public static enum ProviderType {
        START("start"),
        TAG("tag"),
        TYPE("type"),
        PIECE_TYPE("piece/type"),
        JIGSAW_SINGLE("piece/jigsaw/single"),
        JIGSAW_FEATURE("piece/jigsaw/feature");

        private final String key;

        private ProviderType(String key) {
            this.key = key;
        }

        public String prefix() {
            return this.key + "/";
        }

        public String translation(class_2960 id) {
            return "structure.%s.%s".formatted(this.key.replace('/', '.'), id.toString().replace(':', '.'));
        }
    }
}

