/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.tiles;

import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.tiles.SubTile;
import folk.sisby.antique_atlas.gui.tiles.SubTileQuartet;
import folk.sisby.antique_atlas.util.Rect;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class TileRenderIterator
implements Iterator<SubTileQuartet>,
Iterable<SubTileQuartet> {
    private final WorldAtlasData tiles;
    private int step = 1;
    private final Rect scope = new Rect();
    private TileTexture a;
    private TileTexture b;
    private TileTexture c;
    private TileTexture d;
    private TileTexture e;
    private TileTexture f;
    private TileTexture g;
    private TileTexture h;
    private TileTexture i;
    private TileTexture j;
    private TileTexture k;
    private TileTexture l;
    private final SubTile _d = new SubTile(SubTile.Part.BOTTOM_RIGHT);
    private final SubTile _e = new SubTile(SubTile.Part.BOTTOM_LEFT);
    private final SubTile _h = new SubTile(SubTile.Part.TOP_RIGHT);
    private final SubTile _i = new SubTile(SubTile.Part.TOP_LEFT);
    private final SubTileQuartet quartet = new SubTileQuartet(this._d, this._e, this._h, this._i);
    private int chunkX;
    private int chunkY;
    private int subtileX = -1;
    private int subtileY = -1;

    public void setStep(int step) {
        if (step >= 1) {
            this.step = step;
        }
    }

    public void setScope(Rect scope) {
        this.scope.set(scope);
        this.chunkX = scope.minX;
        this.chunkY = scope.minY;
    }

    public TileRenderIterator(WorldAtlasData tiles) {
        this.tiles = tiles;
        this.setScope(tiles.getScope());
    }

    @Override
    @NotNull
    public Iterator<SubTileQuartet> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.chunkX >= this.scope.minX && this.chunkX <= this.scope.maxX + 1 && this.chunkY >= this.scope.minY && this.chunkY <= this.scope.maxY + 1;
    }

    @Override
    public SubTileQuartet next() {
        this.a = this.b;
        this.b = this.tiles.getTile(this.chunkX, this.chunkY - this.step * 2);
        this.c = this.d;
        this.d = this.e;
        this.e = this.f;
        this.f = this.tiles.getTile(this.chunkX + this.step, this.chunkY - this.step);
        this.g = this.h;
        this.h = this.i;
        this.i = this.j;
        this.j = this.tiles.getTile(this.chunkX + this.step, this.chunkY);
        this.k = this.l;
        this.l = this.tiles.getTile(this.chunkX, this.chunkY + this.step);
        this.quartet.setCoords(this.subtileX, this.subtileY);
        this._d.texture = this.d;
        this._e.texture = this.e;
        this._h.texture = this.h;
        this._i.texture = this.i;
        for (SubTile subtile : this.quartet) {
            subtile.shape = SubTile.Shape.CONVEX;
        }
        if (TileRenderIterator.tilesToHorizontal(this.d, this.e)) {
            TileRenderIterator.applyTilingHorizontally(this._d);
        }
        if (TileRenderIterator.tilesToHorizontal(this.e, this.d)) {
            TileRenderIterator.applyTilingHorizontally(this._e);
        }
        if (TileRenderIterator.tilesToHorizontal(this.h, this.i)) {
            TileRenderIterator.applyTilingHorizontally(this._h);
        }
        if (TileRenderIterator.tilesToHorizontal(this.i, this.h)) {
            TileRenderIterator.applyTilingHorizontally(this._i);
        }
        if (TileRenderIterator.tilesToVertical(this.d, this.h)) {
            TileRenderIterator.applyTilingVertically(this._d);
            if (this._d.shape == SubTile.Shape.CONCAVE && TileRenderIterator.tilesTo(this.d, this.i)) {
                this._d.shape = SubTile.Shape.FULL;
            }
        }
        if (TileRenderIterator.tilesToVertical(this.h, this.d)) {
            TileRenderIterator.applyTilingVertically(this._h);
            if (this._h.shape == SubTile.Shape.CONCAVE && TileRenderIterator.tilesTo(this.h, this.e)) {
                this._h.shape = SubTile.Shape.FULL;
            }
        }
        if (TileRenderIterator.tilesToVertical(this.e, this.i)) {
            TileRenderIterator.applyTilingVertically(this._e);
            if (this._e.shape == SubTile.Shape.CONCAVE && TileRenderIterator.tilesTo(this.e, this.h)) {
                this._e.shape = SubTile.Shape.FULL;
            }
        }
        if (TileRenderIterator.tilesToVertical(this.i, this.e)) {
            TileRenderIterator.applyTilingVertically(this._i);
            if (this._i.shape == SubTile.Shape.CONCAVE && TileRenderIterator.tilesTo(this.i, this.d)) {
                this._i.shape = SubTile.Shape.FULL;
            }
        }
        if (this._d.shape == SubTile.Shape.CONVEX && !TileRenderIterator.tilesToVertical(this.d, this.a) && !TileRenderIterator.tilesToHorizontal(this.d, this.c)) {
            this._d.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        if (this._e.shape == SubTile.Shape.CONVEX && !TileRenderIterator.tilesToVertical(this.e, this.b) && !TileRenderIterator.tilesToHorizontal(this.e, this.f)) {
            this._e.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        if (this._h.shape == SubTile.Shape.CONVEX && !TileRenderIterator.tilesToHorizontal(this.h, this.g) && !TileRenderIterator.tilesToVertical(this.h, this.k)) {
            this._h.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        if (this._i.shape == SubTile.Shape.CONVEX && !TileRenderIterator.tilesToHorizontal(this.i, this.j) && !TileRenderIterator.tilesToVertical(this.i, this.l)) {
            this._i.shape = SubTile.Shape.SINGLE_OBJECT;
        }
        this.chunkX += this.step;
        this.subtileX += 2;
        if (this.chunkX > this.scope.maxX + 1) {
            this.chunkX = this.scope.minX;
            this.subtileX = -1;
            this.chunkY += this.step;
            this.subtileY += 2;
            this.a = null;
            this.b = null;
            this.c = null;
            this.d = null;
            this.e = null;
            this.f = this.tiles.getTile(this.chunkX, this.chunkY - this.step);
            this.g = null;
            this.h = null;
            this.i = null;
            this.j = this.tiles.getTile(this.chunkX, this.chunkY);
            this.k = null;
            this.l = null;
        }
        return this.quartet;
    }

    private static boolean tilesTo(TileTexture tile, TileTexture to) {
        return tile != null && to != null && tile.tiles(to);
    }

    private static boolean tilesToHorizontal(TileTexture tile, TileTexture to) {
        return tile != null && to != null && tile.tilesHorizontally(to);
    }

    private static boolean tilesToVertical(TileTexture tile, TileTexture to) {
        return tile != null && to != null && tile.tilesVertically(to);
    }

    private static void applyTilingHorizontally(SubTile subtile) {
        if (subtile.shape == SubTile.Shape.VERTICAL) {
            subtile.shape = SubTile.Shape.CONCAVE;
        } else if (subtile.shape == SubTile.Shape.CONVEX) {
            subtile.shape = SubTile.Shape.HORIZONTAL;
        }
    }

    private static void applyTilingVertically(SubTile subtile) {
        if (subtile.shape == SubTile.Shape.HORIZONTAL) {
            subtile.shape = SubTile.Shape.CONCAVE;
        } else if (subtile.shape == SubTile.Shape.CONVEX) {
            subtile.shape = SubTile.Shape.VERTICAL;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove subtiles from tile storage");
    }
}

