/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.ViewportComponent;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_768;

public class ScrollBoxComponent
extends Component {
    public static final class_2960 ARROW = AntiqueAtlas.id("textures/gui/arrow.png");
    public static final int ARROW_SIZE = 16;
    public static final int ARROW_TEXTURE_WIDTH = 32;
    public static final int ARROW_TEXTURE_HEIGHT = 64;
    private final int scrollStep;
    private final boolean vertical;
    private final ViewportComponent viewport;
    int scrollPos = 0;

    public ScrollBoxComponent(boolean vertical, int scrollStep) {
        this.vertical = vertical;
        this.scrollStep = scrollStep;
        this.viewport = new ViewportComponent();
        this.addChild(this.viewport);
    }

    public void renderArrow(class_332 context, int mouseX, int mouseY, boolean prev) {
        int x;
        int n = !this.vertical ? (prev ? this.getGuiX() - 16 : this.getGuiX() + this.getWidth()) : (x = this.getGuiX() + (this.getWidth() - 16) / 2);
        int y = this.vertical ? (prev ? this.getGuiY() - 16 : this.getGuiY() + this.getHeight()) : this.getGuiY() + (this.getHeight() - 16) / 2;
        boolean hovered = new class_768(x, y, 16, 16).method_3318(mouseX, mouseY);
        int u = prev ? 0 : 16;
        int v = (this.vertical ? 0 : 16) + (hovered ? 32 : 0);
        context.method_25290(ARROW, x, y, (float)u, (float)v, 16, 16, 32, 64);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTick) {
        super.method_25394(context, mouseX, mouseY, partialTick);
        if (this.scrollPos > 0) {
            this.renderArrow(context, mouseX, mouseY, true);
        }
        if (this.scrollPos < this.getContentSize() - this.getViewportSize()) {
            this.renderArrow(context, mouseX, mouseY, false);
        }
    }

    public boolean clickArrow(double mouseX, double mouseY, boolean prev) {
        int x;
        int n = !this.vertical ? (prev ? this.getGuiX() - 16 : this.getGuiX() + this.getWidth()) : (x = this.getGuiX() + (this.getWidth() - 16) / 2);
        int y = this.vertical ? (prev ? this.getGuiY() - 16 : this.getGuiY() + this.getHeight()) : this.getGuiY() + (this.getHeight() - 16) / 2;
        boolean hovered = new class_768(x, y, 16, 16).method_3318((int)mouseX, (int)mouseY);
        if (hovered) {
            int numSteps = (int)Math.round((double)this.getViewportSize() / (double)this.scrollStep);
            this.doSetScrollPos(this.scrollPos + numSteps * this.scrollStep * (prev ? -1 : 1));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mb) {
        if (this.scrollPos > 0 && this.clickArrow(mouseX, mouseY, true)) {
            return true;
        }
        if (this.scrollPos < this.getContentSize() - this.getViewportSize() && this.clickArrow(mouseX, mouseY, false)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mb);
    }

    @Override
    public boolean method_25401(double mx, double my, double wheelMove) {
        if (this.method_25405(mx, my) && wheelMove != 0.0) {
            wheelMove = wheelMove > 0.0 ? -1.0 : 1.0;
            this.doSetScrollPos((int)((double)this.scrollPos + wheelMove * (double)this.scrollStep));
            return true;
        }
        return super.method_25401(mx, my, wheelMove);
    }

    public void setScrollPos(int scrollPos) {
        this.viewport.content.updateSize();
        this.viewport.updateSize();
        this.doSetScrollPos(scrollPos);
    }

    private void doSetScrollPos(int scrollPos) {
        this.scrollPos = scrollPos = Math.max(0, Math.min(scrollPos, this.getContentSize() - this.getViewportSize()));
        this.updateContentPos();
    }

    protected void updateContentPos() {
        this.viewport.content.setRelativeCoords(this.vertical ? this.viewport.content.getRelativeX() : -this.scrollPos, this.vertical ? -this.scrollPos : this.viewport.content.getRelativeY());
    }

    public int getContentSize() {
        return this.vertical ? this.viewport.contentHeight : this.viewport.contentWidth;
    }

    public int getViewportSize() {
        return this.vertical ? this.viewport.getHeight() : this.viewport.getWidth();
    }

    public ViewportComponent getViewport() {
        return this.viewport;
    }
}

