/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasKeybindings;
import folk.sisby.antique_atlas.AtlasStructureLandmark;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.BlinkingMarkerComponent;
import folk.sisby.antique_atlas.gui.BookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerBookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerModal;
import folk.sisby.antique_atlas.gui.TextBookmarkButton;
import folk.sisby.antique_atlas.gui.core.ButtonComponent;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.CursorComponent;
import folk.sisby.antique_atlas.gui.core.ScreenState;
import folk.sisby.antique_atlas.gui.core.ScrollBoxComponent;
import folk.sisby.antique_atlas.gui.tiles.SubTile;
import folk.sisby.antique_atlas.gui.tiles.SubTileQuartet;
import folk.sisby.antique_atlas.gui.tiles.TileRenderIterator;
import folk.sisby.antique_atlas.util.DrawBatcher;
import folk.sisby.antique_atlas.util.DrawUtil;
import folk.sisby.antique_atlas.util.MathUtil;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.Landmark;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import org.joml.Vector2d;

public class AtlasScreen
extends Component {
    public static final class_2960 BOOK = AntiqueAtlas.id("textures/gui/book.png");
    public static final class_2960 BOOK_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_fullscreen.png");
    public static final class_2960 BOOK_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_fullscreen_r.png");
    public static final class_2960 BOOK_FRAME = AntiqueAtlas.id("textures/gui/book_frame.png");
    public static final class_2960 BOOK_FRAME_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_frame_fullscreen.png");
    public static final class_2960 BOOK_FRAME_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_frame_fullscreen_r.png");
    public static final class_2960 BOOK_FRAME_NARROW = AntiqueAtlas.id("textures/gui/book_frame_narrow.png");
    public static final class_2960 BOOK_FRAME_NARROW_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_frame_narrow_fullscreen.png");
    public static final class_2960 BOOK_FRAME_NARROW_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_frame_narrow_fullscreen_r.png");
    public static final class_2960 PLAYER = AntiqueAtlas.id("textures/gui/player.png");
    public static final class_2960 ERASER = AntiqueAtlas.id("textures/gui/eraser.png");
    public static final class_2960 ICON_ADD_MARKER = AntiqueAtlas.id("textures/gui/icons/add_marker.png");
    public static final class_2960 ICON_DELETE_MARKER = AntiqueAtlas.id("textures/gui/icons/del_marker.png");
    public static final class_2960 ICON_SHOW_MARKERS = AntiqueAtlas.id("textures/gui/icons/show_markers.png");
    public static final class_2960 ICON_HIDE_MARKERS = AntiqueAtlas.id("textures/gui/icons/hide_markers.png");
    private static final class_2561 TEXT_ADD_MARKER = class_2561.method_43471((String)"gui.antique_atlas.addMarker");
    private static final class_2561 TEXT_ADD_MARKER_HERE = class_2561.method_43471((String)"gui.antique_atlas.addMarkerHere");
    private static final int MAP_BORDER_WIDTH = 17;
    private static final int MAP_BORDER_HEIGHT = 11;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    private static final int BOOKMARK_SPACING = 2;
    public static final int MARKER_SIZE = 32;
    private static final int NAVIGATE_STEP = 24;
    public static final ScreenState.State<AtlasScreen> NORMAL = new ScreenState.ToggleState<AtlasScreen>();
    public static final ScreenState.State<AtlasScreen> PLACING_MARKER = new ScreenState.ToggleState<AtlasScreen>(s -> s.addMarkerBookmark);
    public static final ScreenState.State<AtlasScreen> DELETING_MARKER = new ScreenState.ToggleState<AtlasScreen>(s -> s.deleteMarkerBookmark, s -> s.addChild(s.eraser), s -> s.removeChild(s.eraser));
    public static final ScreenState.State<AtlasScreen> HIDING_MARKERS = new ScreenState.ToggleState<AtlasScreen>(s -> s.markerVisibilityBookmark, s -> {
        s.markerVisibilityBookmark.setTitle((class_2561)class_2561.method_43471((String)"gui.antique_atlas.showMarkers"));
        s.markerVisibilityBookmark.setIconTexture(ICON_SHOW_MARKERS);
    }, s -> {
        s.clearTargetBookmarks(s.playerBookmark);
        s.markerVisibilityBookmark.setTitle((class_2561)class_2561.method_43471((String)"gui.antique_atlas.hideMarkers"));
        s.markerVisibilityBookmark.setIconTexture(ICON_HIDE_MARKERS);
    });
    private final int bookWidth;
    private final int bookHeight;
    private final int mapWidth;
    private final int mapHeight;
    private final boolean fullscreen;
    private final BookmarkButton addMarkerBookmark;
    private final BookmarkButton deleteMarkerBookmark;
    private final BookmarkButton markerVisibilityBookmark;
    private final TextBookmarkButton resetScaleBookmark;
    private final BookmarkButton playerBookmark;
    private final ScrollBoxComponent markerScrollBox = new ScrollBoxComponent(true, 20);
    private final MarkerModal markerModal = new MarkerModal();
    private final BlinkingMarkerComponent markerCursor = new BlinkingMarkerComponent();
    private final CursorComponent eraser = new CursorComponent();
    private final List<BookmarkButton> markerBookmarks = new ArrayList<BookmarkButton>();
    private final ScreenState<AtlasScreen> state = new ScreenState((oldState, newState) -> AntiqueAtlas.lastState.switchTo((ScreenState.State<AtlasScreen>)newState, this));
    private Landmark<?> hoveredLandmark = null;
    private PlayerSummary hoveredFriend = null;
    private ButtonComponent selectedButton = null;
    private class_1657 player;
    private WorldAtlasData worldAtlasData;
    private Integer targetOffsetX;
    private Integer targetOffsetY;
    private boolean isMouseOverMap = false;
    private boolean isDragging = false;
    private static double mapOffsetX;
    private static double mapOffsetY;
    private static int tilePixels;
    private static int tileChunks;
    private int mapScale;

    public AtlasScreen() {
        this.fullscreen = AntiqueAtlas.CONFIG.fullscreen;
        if (this.fullscreen) {
            this.bookWidth = (int)((double)class_310.method_1551().method_22683().method_4486() * 0.9 - 40.0);
            this.bookHeight = (int)((double)class_310.method_1551().method_22683().method_4502() * 0.9);
        } else {
            this.bookWidth = 310;
            this.bookHeight = 218;
        }
        this.setSize(this.bookWidth, this.bookHeight);
        this.mapWidth = this.bookWidth - 34;
        this.mapHeight = this.bookHeight - 22;
        this.mapScale = this.getMapScale();
        this.playerBookmark = new BookmarkButton((class_2561)class_2561.method_43471((String)"gui.antique_atlas.followPlayer"), AntiqueAtlas.id("textures/gui/player.png"), class_1767.field_7944, null, 7, 8, false);
        this.addChild(this.playerBookmark).offsetGuiCoords(this.bookWidth - 10, this.bookHeight - 11 - 18 - 10);
        this.playerBookmark.addListener(b -> {
            this.selectedButton = this.playerBookmark;
            this.clearTargetBookmarks(this.playerBookmark);
            this.playerBookmark.setSelected(true);
        });
        this.addMarkerBookmark = new BookmarkButton(TEXT_ADD_MARKER, ICON_ADD_MARKER, class_1767.field_7964, null, 16, 16, false);
        this.addChild(this.addMarkerBookmark).offsetGuiCoords(this.bookWidth - 10, 14);
        this.addMarkerBookmark.addListener(button -> {
            if (this.state.is(PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = button;
                this.state.switchTo(PLACING_MARKER, this);
                if (AtlasScreen.method_25442()) {
                    this.markerModal.setMarkerData(this.player.method_5770(), this.player.method_31477(), this.player.method_31479());
                    this.addChild(this.markerModal);
                    this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight());
                    this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)this.worldXToScreenX(this.player.method_31477() - 16), (int)this.worldZToScreenY(this.player.method_31479() - 16));
                    class_304.method_1437();
                    this.selectedButton = null;
                    this.state.switchTo(NORMAL, this);
                }
            }
        });
        this.deleteMarkerBookmark = new BookmarkButton((class_2561)class_2561.method_43471((String)"gui.antique_atlas.delMarker"), ICON_DELETE_MARKER, class_1767.field_7947, null, 16, 16, false);
        this.addChild(this.deleteMarkerBookmark).offsetGuiCoords(this.bookWidth - 10, 33);
        this.deleteMarkerBookmark.addListener(button -> {
            if (this.state.is(DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = button;
                this.state.switchTo(DELETING_MARKER, this);
            }
        });
        this.markerVisibilityBookmark = new BookmarkButton((class_2561)class_2561.method_43471((String)"gui.antique_atlas.hideMarkers"), ICON_HIDE_MARKERS, class_1767.field_7942, null, 16, 16, false);
        this.addChild(this.markerVisibilityBookmark).offsetGuiCoords(this.bookWidth - 10, 52);
        this.markerVisibilityBookmark.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(HIDING_MARKERS)) {
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = null;
                this.state.switchTo(HIDING_MARKERS, this);
            }
        });
        this.resetScaleBookmark = new TextBookmarkButton((class_2561)class_2561.method_43471((String)"gui.antique_atlas.resetScale"), class_2561.method_30163((String)"1c"));
        this.addChild(this.resetScaleBookmark).offsetGuiCoords(this.bookWidth - 10, 71);
        this.resetScaleBookmark.addListener(button -> {
            this.resetZoom();
            this.resetScaleBookmark.setSelected(false);
        });
        this.addChild(this.markerScrollBox).setRelativeCoords(-14, 19);
        int markersOnScreen = (this.mapHeight - 20) / 18;
        this.markerScrollBox.getViewport().setSize(24, markersOnScreen * 20 - 2);
        this.markerModal.addMarkerListener(this.markerCursor);
        this.eraser.setTexture(ERASER, 12, 14, 2, 11);
        this.state.switchTo(AntiqueAtlas.lastState.is(HIDING_MARKERS) ? HIDING_MARKERS : NORMAL, this);
    }

    private int getMapScale() {
        return switch (AntiqueAtlas.CONFIG.mapScale) {
            case -2 -> Math.max(1, (int)Math.floor(class_310.method_1551().method_22683().method_4495() / 2.0));
            case -1 -> Math.max(1, (int)Math.ceil(class_310.method_1551().method_22683().method_4495() / 2.0));
            case 0 -> (int)class_310.method_1551().method_22683().method_4495();
            default -> AntiqueAtlas.CONFIG.mapScale;
        };
    }

    public AtlasScreen prepareToOpen() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
        this.player = class_310.method_1551().field_1724;
        this.updateAtlasData();
        if (!AntiqueAtlas.CONFIG.keepOffset) {
            this.playerBookmark.setSelected(true);
            this.setMapPosition(this.player.method_31477(), this.player.method_31479());
        }
        if (!AntiqueAtlas.CONFIG.keepZoom) {
            this.resetZoom();
        }
        return this;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.setGuiCoords((this.field_22789 - this.bookWidth) / 2, (this.field_22790 - this.bookHeight) / 2);
        this.updateScaleBookmark();
        this.updateBookmarkerList();
    }

    public void updateBookmarkerList() {
        this.markerScrollBox.getViewport().removeAllContent();
        this.markerScrollBox.setScrollPos(0);
        this.markerBookmarks.clear();
        if (this.worldAtlasData == null) {
            return;
        }
        this.worldAtlasData.getEditableLandmarks().forEach((landmark, texture) -> {
            MarkerBookmarkButton bookmark = new MarkerBookmarkButton(landmark.name(), (MarkerTexture)texture, landmark.color(), true);
            bookmark.addListener(button -> {
                if (this.state.is(NORMAL)) {
                    this.clearTargetBookmarks(bookmark);
                    this.setTargetPosition(new class_2265(landmark.pos().method_10263(), landmark.pos().method_10260()));
                } else if (this.state.is(DELETING_MARKER)) {
                    if (!this.worldAtlasData.deleteLandmark(this.player.method_5770(), (Landmark<?>)landmark)) {
                        return;
                    }
                    this.updateBookmarkerList();
                    this.player.method_5770().method_8396(this.player, this.player.method_24515(), class_3417.field_17484, class_3419.field_15256, 1.0f, 0.5f);
                    this.state.switchTo(NORMAL, this);
                }
            });
            this.markerBookmarks.add(bookmark);
        });
        int[] contentY = new int[]{0};
        for (BookmarkButton bookmark : this.markerBookmarks) {
            this.markerScrollBox.getViewport().addContent(bookmark).setRelativeY(contentY[0]);
            contentY[0] = contentY[0] + 20;
        }
    }

    public void clearTargetBookmarks(BookmarkButton except) {
        if (this.playerBookmark != except) {
            this.playerBookmark.setSelected(false);
        }
        for (BookmarkButton bookmark : this.markerBookmarks) {
            if (bookmark == except) continue;
            bookmark.setSelected(false);
        }
    }

    public void updateMouse(double mouseX, double mouseY) {
        double relativeMouseX = mouseX - (double)this.getGuiX();
        double relativeMouseY = mouseY - (double)this.getGuiY();
        this.isMouseOverMap = relativeMouseX >= 17.0 && relativeMouseX <= (double)(17 + this.mapWidth) && relativeMouseY >= 11.0 && relativeMouseY <= (double)(11 + this.mapHeight);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        this.updateMouse(mouseX, mouseY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseState) {
        this.updateMouse(mouseX, mouseY);
        if (super.method_25402(mouseX, mouseY, mouseState)) {
            return true;
        }
        if (this.markerModal.getParent() != null) {
            return false;
        }
        if (!this.state.is(NORMAL) && !this.state.is(HIDING_MARKERS)) {
            if (this.state.is(PLACING_MARKER) && this.isMouseOverMap && mouseState == 0) {
                this.markerModal.setMarkerData(this.player.method_5770(), this.screenXToWorldX(mouseX), this.screenYToWorldZ(mouseY));
                this.addChild(this.markerModal);
                this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), 32, 32);
                this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)mouseX - 16, (int)mouseY - 16);
                class_304.method_1437();
                this.state.switchTo(NORMAL, this);
                return true;
            }
            if (this.state.is(DELETING_MARKER) && this.hoveredLandmark != null && this.isMouseOverMap && mouseState == 0 && this.worldAtlasData.deleteLandmark(this.player.method_5770(), this.hoveredLandmark)) {
                this.updateBookmarkerList();
                this.player.method_5770().method_8396(this.player, this.player.method_24515(), class_3417.field_17484, class_3419.field_15256, 1.0f, 0.5f);
            }
            this.state.switchTo(NORMAL, this);
        } else if (this.isMouseOverMap && this.selectedButton == null) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.zoomIn(true, 16 << AntiqueAtlas.CONFIG.maxTilePixels);
        } else if (keyCode == 45 || keyCode == 333) {
            this.zoomOut(true, 1 << AntiqueAtlas.CONFIG.maxTileChunks);
        } else if (keyCode == 256 || AntiqueAtlasKeybindings.ATLAS_KEYMAPPING.method_1417(keyCode, scanCode) && this.markerModal.getParent() == null) {
            this.method_25419();
        } else {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return true;
    }

    private double getPixelsPerBlock() {
        return (double)this.mapScale / class_310.method_1551().method_22683().method_4495() * (double)tilePixels / ((double)tileChunks * 16.0);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double wheelMove) {
        this.updateMouse(mouseX, mouseY);
        if (super.method_25401(mouseX, mouseY, wheelMove)) {
            return true;
        }
        if (this.markerModal.getParent() == null && wheelMove != 0.0) {
            int direction;
            int n = direction = wheelMove > 0.0 ? 1 : -1;
            if ((wheelMove > 0.0 ? this.zoomIn(true, 16 << AntiqueAtlas.CONFIG.maxTilePixels) : this.zoomOut(true, 1 << AntiqueAtlas.CONFIG.maxTileChunks)) && (this.isMouseOverMap || this.isDragging)) {
                double xOffset = ((double)(this.getGuiX() + 17) + (double)this.mapWidth / 2.0 - mouseX) * (double)direction;
                double yOffset = ((double)(this.getGuiY() + 11) + (double)this.mapHeight / 2.0 - mouseY) * (double)direction;
                if (Math.abs(xOffset) > 5.0 || Math.abs(yOffset) > 5.0) {
                    mapOffsetX += xOffset / (direction < 0 ? 2.0 : 1.0);
                    mapOffsetY += yOffset / (direction < 0 ? 2.0 : 1.0);
                    this.clearTargetBookmarks(null);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.clearTargetBookmarks(null);
            mapOffsetX += deltaX;
            mapOffsetY += deltaY;
            result = true;
        }
        return super.method_25403(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.player == null) {
            return;
        }
        if (this.playerBookmark.isSelected() && (mapOffsetX != (double)(-this.player.method_31477()) * this.getPixelsPerBlock() || mapOffsetY != (double)(-this.player.method_31479()) * this.getPixelsPerBlock())) {
            this.setTargetPosition(new class_2265(this.player.method_31477(), this.player.method_31479()));
        }
        if (this.targetOffsetX != null) {
            if (Math.abs(this.getTargetPositionX() - mapOffsetX) > 24.0) {
                this.softNavigateMap(this.getTargetPositionX() > mapOffsetX ? 24 : -24, 0);
            } else {
                mapOffsetX = this.getTargetPositionX();
                this.targetOffsetX = null;
            }
        }
        if (this.targetOffsetY != null) {
            if (Math.abs(this.getTargetPositionY() - mapOffsetY) > 24.0) {
                this.softNavigateMap(0, this.getTargetPositionY() > mapOffsetY ? 24 : -24);
            } else {
                mapOffsetY = this.getTargetPositionY();
                this.targetOffsetY = null;
            }
        }
    }

    private void updateAtlasData() {
        if (class_310.method_1551().field_1687 != null) {
            this.worldAtlasData = WorldAtlasData.getOrCreate((class_1937)class_310.method_1551().field_1687);
        }
    }

    private void navigateMap(int dx, int dy) {
        mapOffsetX += (double)dx;
        mapOffsetY += (double)dy;
        this.clearTargetBookmarks(null);
    }

    private void softNavigateMap(int dx, int dy) {
        mapOffsetX += (double)dx;
        mapOffsetY += (double)dy;
    }

    private void setMapPosition(int x, int z) {
        mapOffsetX = (int)((double)(-x) * this.getPixelsPerBlock());
        mapOffsetY = (int)((double)(-z) * this.getPixelsPerBlock());
    }

    private void setTargetPosition(class_2265 pos) {
        this.targetOffsetX = pos.comp_638();
        this.targetOffsetY = pos.comp_639();
    }

    private double getTargetPositionX() {
        return (double)(-this.targetOffsetX.intValue()) * this.getPixelsPerBlock();
    }

    private double getTargetPositionY() {
        return (double)(-this.targetOffsetY.intValue()) * this.getPixelsPerBlock();
    }

    private void updateScaleBookmark() {
        int tileSizeBlocks = tileChunks * 16 * 16 / tilePixels;
        int defaultTileSizeBlocks = 16;
        int rulerSizeBlocks = tileSizeBlocks * (int)class_310.method_1551().method_22683().method_4495() / this.mapScale;
        this.resetScaleBookmark.setLabel((class_2561)class_2561.method_43470((String)(rulerSizeBlocks == 16 | rulerSizeBlocks >= 32 ? "%dc".formatted(rulerSizeBlocks / 16) : "%db".formatted(rulerSizeBlocks))).method_27692(tileSizeBlocks < defaultTileSizeBlocks ? class_124.field_1079 : (tileSizeBlocks == defaultTileSizeBlocks ? class_124.field_1074 : class_124.field_1058)));
    }

    private boolean zoomIn(boolean playSound, int maxTilePixels) {
        if (tileChunks == 1) {
            if (tilePixels >= maxTilePixels) {
                return false;
            }
            tilePixels <<= 1;
            if (playSound) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_26972, (float)1.0f));
            }
        } else {
            tileChunks >>= 1;
            if (playSound) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            }
        }
        mapOffsetX *= 2.0;
        mapOffsetY *= 2.0;
        this.updateScaleBookmark();
        return true;
    }

    private boolean zoomOut(boolean playSound, int maxTileChunks) {
        if (tilePixels == 16) {
            if (tileChunks >= maxTileChunks) {
                return false;
            }
            tileChunks <<= 1;
            if (playSound) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            }
        } else {
            tilePixels >>= 1;
            if (playSound) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_26972, (float)1.0f));
            }
        }
        mapOffsetX /= 2.0;
        mapOffsetY /= 2.0;
        this.updateScaleBookmark();
        return true;
    }

    private void resetZoom() {
        block3: {
            block2: {
                if (!this.zoomIn(true, 8)) break block2;
                while (this.zoomIn(false, 8)) {
                }
                break block3;
            }
            if (!this.zoomOut(true, 1)) break block3;
            while (this.zoomOut(false, 1)) {
            }
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float par3) {
        Object texture2;
        super.method_25420(context);
        this.mapScale = this.getMapScale();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fullscreen) {
            int left_width = this.bookWidth / 2 - 15;
            context.method_48586(BOOK_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.method_48586(BOOK_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.method_48586(BOOK_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.method_25290(BOOK, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, 310, 218, 310, 218);
        }
        if (this.worldAtlasData == null) {
            return;
        }
        if (this.state.is(DELETING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        double guiScale = this.field_22787.method_22683().method_4495();
        RenderSystem.enableScissor((int)((int)(guiScale * (double)(this.getGuiX() + 17))), (int)((int)(guiScale * (double)(this.getGuiY() + 11))), (int)((int)(guiScale * (double)this.mapWidth)), (int)((int)(guiScale * (double)this.mapHeight)));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int mapStartChunkX = MathUtil.roundToBase(this.screenXToWorldX(this.getGuiX()) >> 4, tileChunks) - 2 * tileChunks;
        int mapStartChunkZ = MathUtil.roundToBase(this.screenYToWorldZ(this.getGuiY()) >> 4, tileChunks) - 2 * tileChunks;
        int mapEndChunkX = MathUtil.roundToBase(this.screenXToWorldX(this.getGuiX() + this.bookWidth) >> 4, tileChunks) + 2 * tileChunks;
        int mapEndChunkZ = MathUtil.roundToBase(this.screenYToWorldZ(this.getGuiY() + this.bookWidth) >> 4, tileChunks) + 2 * tileChunks;
        double mapStartScreenX = this.worldXToScreenX(mapStartChunkX << 4);
        double mapStartScreenY = this.worldZToScreenY(mapStartChunkZ << 4);
        TileRenderIterator tiles = new TileRenderIterator(this.worldAtlasData);
        tiles.setScope(new Rect(mapStartChunkX, mapStartChunkZ, mapEndChunkX, mapEndChunkZ));
        tiles.setStep(tileChunks);
        context.method_51448().method_22903();
        context.method_51448().method_22904(mapStartScreenX, mapStartScreenY, 0.0);
        context.method_51448().method_22905((float)((double)this.mapScale / guiScale), (float)((double)this.mapScale / guiScale), 1.0f);
        Reference2ObjectArrayMap tileTextures = new Reference2ObjectArrayMap();
        for (SubTileQuartet subTiles : tiles) {
            for (SubTile subtile : subTiles) {
                if (subtile == null || subtile.texture == null) continue;
                tileTextures.computeIfAbsent(subtile.texture, k -> new ArrayList()).add(subtile.copy());
            }
        }
        int subTilePixels = tilePixels / 2;
        tileTextures.forEach((texture, subtiles) -> {
            try (DrawBatcher batcher = new DrawBatcher(context, texture.id(), 32, 48);){
                for (SubTile subtile : subtiles) {
                    batcher.add(subtile.x * subTilePixels, subtile.y * subTilePixels, subTilePixels, subTilePixels, subtile.getTextureU() * 8, subtile.getTextureV() * 8, 8, 8);
                }
            }
        });
        context.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fullscreen) {
            int left_width = this.bookWidth / 2 - 15;
            context.method_48586(BOOK_FRAME_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.method_48586(BOOK_FRAME_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.method_48586(BOOK_FRAME_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.method_25290(BOOK_FRAME, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, 310, 218, 310, 218);
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.getGuiX(), (float)this.getGuiY(), 0.0f);
        float markerScale = (float)((double)tilePixels * (double)this.mapScale / (guiScale * 16.0));
        Map friends = SurveyorClient.getFriends();
        this.hoveredLandmark = null;
        this.hoveredFriend = null;
        if (!this.state.is(HIDING_MARKERS)) {
            if (this.isMouseOverMap) {
                double bestDistance = Double.MAX_VALUE;
                for (Map.Entry<Landmark<?>, MarkerTexture> entry : this.worldAtlasData.getAllMarkers(tileChunks).entrySet()) {
                    Landmark<?> landmark2 = entry.getKey();
                    texture2 = entry.getValue();
                    double markerX = this.worldXToScreenX(landmark2.pos().method_10263());
                    double markerY = this.worldZToScreenY(landmark2.pos().method_10260());
                    Vector2d markerCenter = ((MarkerTexture)texture2).getCenter(tileChunks);
                    double squaredDistance = Vector2d.distanceSquared((double)(markerX + (double)markerScale * markerCenter.x), (double)(markerY + (double)markerScale * markerCenter.y), (double)mouseX, (double)mouseY);
                    if (!(squaredDistance > 0.0) || !(squaredDistance < bestDistance) || !(squaredDistance < ((MarkerTexture)texture2).getSquaredSize(tileChunks) * (double)markerScale * (double)markerScale / 4.0)) continue;
                    bestDistance = squaredDistance;
                    this.hoveredLandmark = landmark2;
                }
                for (PlayerSummary friend2 : friends.values()) {
                    double markerY;
                    double markerX = this.worldXToScreenX(friend2.pos().method_10216());
                    double squaredDistance = Vector2d.distanceSquared((double)markerX, (double)(markerY = this.worldZToScreenY(friend2.pos().method_10215())), (double)mouseX, (double)mouseY);
                    if (!(squaredDistance > 0.0) || !(squaredDistance < bestDistance) || !(squaredDistance < 21.0)) continue;
                    bestDistance = squaredDistance;
                    this.hoveredFriend = friend2;
                    this.hoveredLandmark = null;
                }
            }
            this.worldAtlasData.getAllMarkers(tileChunks).forEach((landmark, texture) -> this.renderMarker(context, (Landmark<?>)landmark, (MarkerTexture)texture, WorldAtlasData.landmarkIsEditable(landmark), this.hoveredLandmark == landmark && this.markerModal.getParent() == null, markerScale));
        }
        context.method_51448().method_22909();
        RenderSystem.disableScissor();
        if (this.fullscreen) {
            int left_width = this.bookWidth / 2 - 15;
            context.method_48586(BOOK_FRAME_NARROW_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.method_48586(BOOK_FRAME_NARROW_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.method_48586(BOOK_FRAME_NARROW_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.method_25290(BOOK_FRAME_NARROW, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, 310, 218, 310, 218);
        }
        this.markerScrollBox.getViewport().setHidden(this.state.is(HIDING_MARKERS));
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.getGuiX(), (float)this.getGuiY(), 0.0f);
        PlayerSummary playerSummary = (PlayerSummary)friends.remove(SurveyorClient.getClientUuid());
        LinkedHashMap<UUID, PlayerSummary> orderedFriends = new LinkedHashMap<UUID, PlayerSummary>(friends);
        if (playerSummary != null) {
            orderedFriends.put(SurveyorClient.getClientUuid(), playerSummary);
        }
        orderedFriends.forEach((uuid, friend) -> {
            if (this.state.is(HIDING_MARKERS) && (!this.playerBookmark.isSelected() || friend != playerSummary)) {
                return;
            }
            this.renderPlayer(context, (PlayerSummary)friend, 1.0f, this.hoveredFriend == friend && this.markerModal.getParent() == null, friend == playerSummary);
        });
        context.method_51448().method_22909();
        super.method_25394(context, mouseX, mouseY, par3);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.state.is(PLACING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.method_25290(this.markerModal.selectedTexture.id(), mouseX + this.markerModal.selectedTexture.offsetX(), mouseY + this.markerModal.selectedTexture.offsetY(), 0.0f, 0.0f, this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight(), this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
        this.addMarkerBookmark.setTitle(AtlasScreen.method_25442() ? TEXT_ADD_MARKER_HERE : TEXT_ADD_MARKER);
        if (AntiqueAtlas.CONFIG.debugRender && !this.isDragging && this.isMouseOverMap && this.markerModal.getParent() == null) {
            int x = this.screenXToWorldX((int)this.getMouseX());
            int z = this.screenYToWorldZ((int)this.getMouseY());
            class_1923 pos = new class_1923(new class_2338(x, 0, z));
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"%d,%d (%d,%d)".formatted(pos.field_9181, pos.field_9180, x, z)), this.getGuiX(), this.getGuiY() - 12, -1, true);
            if (this.hoveredLandmark != null) {
                texture2 = this.worldAtlasData.getMarkerTexture(this.hoveredLandmark);
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)this.hoveredLandmark.type().id().toString()), this.getGuiX() + this.bookWidth - this.field_22793.method_27525((class_5348)class_2561.method_43470((String)this.hoveredLandmark.type().id().toString())), this.getGuiY() - 12, -1, true);
                Landmark<?> landmark3 = this.hoveredLandmark;
                if (landmark3 instanceof AtlasStructureLandmark) {
                    AtlasStructureLandmark sLandmark = (AtlasStructureLandmark)landmark3;
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)sLandmark.displayId().toString()), this.getGuiX(), this.getGuiY() + this.bookHeight, -1, true);
                }
                if (texture2 != null) {
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)((MarkerTexture)texture2).displayId()), this.getGuiX() + this.bookWidth - this.field_22793.method_27525((class_5348)class_2561.method_43470((String)((MarkerTexture)texture2).displayId())), this.getGuiY() + this.bookHeight, -1, true);
                }
            } else {
                texture2 = this.worldAtlasData.getTile(pos);
                class_2960 providerId = this.worldAtlasData.getProvider(pos);
                String predicate = this.worldAtlasData.getTilePredicate(pos);
                if (texture2 != null) {
                    if (predicate != null) {
                        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)predicate), this.getGuiX() + this.bookWidth - this.field_22793.method_27525((class_5348)class_2561.method_43470((String)predicate)), this.getGuiY() - 12, -1, true);
                    }
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)providerId.toString()), this.getGuiX(), this.getGuiY() + this.bookHeight, -1, true);
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)((TileTexture)texture2).displayId()), this.getGuiX() + this.bookWidth - this.field_22793.method_27525((class_5348)class_2561.method_43470((String)((TileTexture)texture2).displayId())), this.getGuiY() + this.bookHeight, -1, true);
                }
            }
        }
    }

    private void renderPlayer(class_332 context, PlayerSummary player, float iconScale, boolean hovering, boolean self) {
        double playerOffsetX = this.worldXToScreenX(player.pos().method_10216()) - (double)this.getGuiX();
        double playerOffsetY = this.worldZToScreenY(player.pos().method_10215()) - (double)this.getGuiY();
        playerOffsetX = class_3532.method_15350((double)playerOffsetX, (double)17.0, (double)(this.mapWidth + 17));
        playerOffsetY = class_3532.method_15350((double)playerOffsetY, (double)11.0, (double)(this.mapHeight + 11));
        float tint = (player.online() ? 1.0f : 0.5f) * (hovering ? 0.9f : 1.0f);
        float greenTint = self ? 1.0f : 0.7f;
        RenderSystem.setShaderColor((float)tint, (float)(tint * greenTint), (float)tint, (float)(this.state.is(PLACING_MARKER) ? 0.5f : 1.0f));
        float playerRotation = (float)Math.round(player.yaw() / 360.0f * 16.0f) / 16.0f * 360.0f;
        DrawUtil.drawCenteredWithRotation(context, PLAYER, playerOffsetX, playerOffsetY, iconScale, 7, 8, playerRotation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (hovering && !self) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)player.username()).method_27692(player.online() ? class_124.field_1076 : class_124.field_1080), (int)this.getMouseX() - this.getGuiX(), (int)this.getMouseY() - this.getGuiY());
        }
    }

    private void renderMarker(class_332 context, Landmark<?> landmark, MarkerTexture texture, boolean editable, boolean hovering, float markerScale) {
        class_1767 color;
        double markerX = this.worldXToScreenX(landmark.pos().method_10263()) - (double)this.getGuiX();
        double markerY = this.worldZToScreenY(landmark.pos().method_10260()) - (double)this.getGuiY();
        float tint = hovering ? 0.8f : 1.0f;
        float alpha = this.state.is(PLACING_MARKER) || this.state.is(DELETING_MARKER) && !editable || editable && markerX <= 17.0 || markerX >= (double)(this.mapWidth + 17) || markerY <= 11.0 || markerY >= (double)(this.mapHeight + 11) ? 0.5f : 1.0f;
        RenderSystem.setShaderColor((float)tint, (float)tint, (float)tint, (float)alpha);
        if (editable) {
            markerX = class_3532.method_15350((double)markerX, (double)17.0, (double)(this.mapWidth + 17));
            markerY = class_3532.method_15350((double)markerY, (double)11.0, (double)(this.mapHeight + 11));
        }
        texture.draw(context, markerX, markerY, markerScale, tileChunks, (color = landmark.color()) == null ? null : color.method_7787(), tint, alpha);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (hovering && landmark.name() != null && !landmark.name().getString().isEmpty()) {
            context.method_51438(this.field_22793, landmark.name(), (int)this.getMouseX() - this.getGuiX(), (int)this.getMouseY() - this.getGuiY());
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void method_25419() {
        super.method_25419();
        this.markerModal.closeChild();
        this.removeChild(this.markerCursor);
    }

    private int screenXToWorldX(double mouseX) {
        double mapX = (int)Math.round(mouseX - (double)this.getGuiX() - 17.0);
        return (int)Math.round((mapX - (double)((float)this.mapWidth / 2.0f) - mapOffsetX) / this.getPixelsPerBlock());
    }

    private int screenYToWorldZ(double mouseY) {
        double mapY = (int)Math.round(mouseY - (double)this.getGuiY() - 11.0);
        return (int)Math.round((mapY - (double)((float)this.mapHeight / 2.0f) - mapOffsetY) / this.getPixelsPerBlock());
    }

    private double worldXToScreenX(double x) {
        double mapX = x * this.getPixelsPerBlock() + mapOffsetX + (double)((float)this.mapWidth / 2.0f);
        return mapX + (double)this.getGuiX() + 17.0;
    }

    private double worldZToScreenY(double z) {
        double mapY = z * this.getPixelsPerBlock() + mapOffsetY + (double)((float)this.mapHeight / 2.0f);
        return mapY + (double)this.getGuiY() + 11.0;
    }

    @Override
    protected void onChildClosed(Component child) {
        if (((Object)((Object)child)).equals((Object)this.markerModal)) {
            this.removeChild(this.markerCursor);
        }
    }

    public WorldAtlasData getworldAtlasData() {
        return this.worldAtlasData;
    }

    static {
        tilePixels = 16;
        tileChunks = 1;
    }
}

