/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.util;

import com.google.common.collect.ImmutableList;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import dev.mrturtle.analog.ModBlocks;
import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.audio.RadioAudioInstance;
import dev.mrturtle.analog.block.ReceiverBlockEntity;
import dev.mrturtle.analog.block.TransmitterBlockEntity;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.world.GlobalRadioState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RadioUtil {
    public static int getRadioChannel(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        int channel = 0;
        if (nbt.method_10545("channel")) {
            channel = nbt.method_10550("channel");
        }
        return channel;
    }

    public static boolean isRadioTransmitting(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        boolean transmitting = false;
        if (nbt.method_10545("isTransmitting")) {
            transmitting = nbt.method_10577("isTransmitting");
        }
        return transmitting;
    }

    public static boolean isRadioReceiving(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        boolean receiving = true;
        if (nbt.method_10545("isReceiving")) {
            receiving = nbt.method_10577("isReceiving");
        }
        return receiving;
    }

    public static boolean isRadioEnabled(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        boolean receiving = false;
        if (nbt.method_10545("isEnabled")) {
            receiving = nbt.method_10577("isEnabled");
        }
        return receiving;
    }

    public static void setRadioChannel(class_1799 stack, int channel) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("channel", channel);
        stack.method_7980(nbt);
    }

    public static void setRadioTransmitting(class_1799 stack, boolean transmitting) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10556("isTransmitting", transmitting);
        stack.method_7980(nbt);
    }

    public static void setRadioReceiving(class_1799 stack, boolean receiving) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10556("isReceiving", receiving);
        stack.method_7980(nbt);
    }

    public static void setRadioEnabled(class_1799 stack, boolean enabled) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10556("isEnabled", enabled);
        stack.method_7980(nbt);
    }

    public static void transmitOnChannel(VoicechatServerApi serverApi, MicrophonePacket packet, class_3222 sender, int senderChannel) {
        MinecraftServer server = sender.method_5682();
        class_3218 world = sender.method_51469();
        byte[] encodedData = packet.getOpusEncodedData();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player == sender || !RadioUtil.isReceivingChannel((class_1657)player, senderChannel)) continue;
            int listeningDistance = ConfigManager.config.radioListeningDistance * 2;
            List playersInRange = world.method_8390(class_1657.class, class_238.method_30048((class_243)player.method_19538(), (double)listeningDistance, (double)listeningDistance, (double)listeningDistance), entity -> true);
            for (class_1657 entity2 : playersInRange) {
                if (serverApi.getConnectionOf(entity2.method_5667()) == null || entity2 != player && entity2 != sender && RadioUtil.isReceivingChannel(entity2, senderChannel)) continue;
                serverApi.sendLocationalSoundPacketTo(serverApi.getConnectionOf(entity2.method_5667()), (LocationalSoundPacket)((LocationalSoundPacket.Builder)packet.locationalSoundPacketBuilder().opusEncodedData(encodedData)).position(serverApi.createPosition(player.method_23317(), player.method_23318(), player.method_23321())).distance(8.0f).build());
            }
        }
        server.execute(() -> {
            List<class_2338> receivers = RadioUtil.getGlobalRadioState(world).getReceivers();
            for (class_2338 receiverPos : receivers) {
                ReceiverBlockEntity receiver;
                if (!world.method_22340(receiverPos) || (receiver = (ReceiverBlockEntity)world.method_8321(receiverPos)) == null || !receiver.enabled || receiver.channel != senderChannel) continue;
                receiver.lastAudioPlayedTick = world.method_8510();
                world.method_8452(receiverPos, ModBlocks.RECEIVER_BLOCK);
                List playersInRange = world.method_8390(class_1657.class, class_238.method_30048((class_243)receiverPos.method_46558(), (double)64.0, (double)64.0, (double)64.0), entity -> true);
                for (class_1657 entity2 : playersInRange) {
                    if (serverApi.getConnectionOf(entity2.method_5667()) == null || entity2 != sender && RadioUtil.isReceivingChannel(entity2, senderChannel)) continue;
                    serverApi.sendLocationalSoundPacketTo(serverApi.getConnectionOf(entity2.method_5667()), (LocationalSoundPacket)((LocationalSoundPacket.Builder)packet.locationalSoundPacketBuilder().opusEncodedData(encodedData)).position(serverApi.createPosition((double)receiverPos.method_10263(), (double)receiverPos.method_10264(), (double)receiverPos.method_10260())).distance(32.0f).build());
                }
            }
        });
    }

    public static RadioAudioInstance transmitDataOnChannel(VoicechatServerApi serverApi, class_3218 world, short[] audioData, int senderChannel) {
        return RadioUtil.transmitDataOnChannel(serverApi, world, audioData, senderChannel, null);
    }

    public static RadioAudioInstance transmitDataOnChannel(VoicechatServerApi serverApi, class_3218 world, short[] audioData, int senderChannel, Runnable onAudioStopped) {
        RadioAudioInstance audioInstance = new RadioAudioInstance(senderChannel, audioData, onAudioStopped);
        MinecraftServer server = world.method_8503();
        GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
        globalRadioState.audioManager.activeAudioInstances.add(audioInstance);
        for (class_3222 player : server.method_3760().method_14571()) {
            if (serverApi.getConnectionOf(player.method_5667()) == null || !RadioUtil.isReceivingChannel((class_1657)player, senderChannel)) continue;
            globalRadioState.audioManager.startReceivingAudioInstance(world, player, audioInstance);
        }
        server.execute(() -> {
            List<class_2338> receivers = globalRadioState.getReceivers();
            for (class_2338 receiverPos : receivers) {
                ReceiverBlockEntity receiver;
                if (!world.method_22340(receiverPos) || (receiver = (ReceiverBlockEntity)world.method_8321(receiverPos)) == null || !receiver.enabled || receiver.channel != senderChannel) continue;
                globalRadioState.audioManager.startReceivingAudioInstance(world, receiverPos, audioInstance);
            }
        });
        return audioInstance;
    }

    public static void transmitOnNearbyTransmitters(VoicechatServerApi serverApi, MicrophonePacket packet, class_3222 sender) {
        MinecraftServer server = sender.method_5682();
        class_3218 world = sender.method_51469();
        List<class_2338> transmitters = RadioUtil.getGlobalRadioState(world).getTransmitters();
        class_243 pos = sender.method_19538();
        server.execute(() -> {
            for (class_2338 transmitterPos : transmitters) {
                TransmitterBlockEntity transmitter;
                if (pos.method_1022(transmitterPos.method_46558()) > (double)ConfigManager.config.radioListeningDistance || (transmitter = (TransmitterBlockEntity)world.method_8321(transmitterPos)) == null || !transmitter.enabled) continue;
                RadioUtil.transmitOnChannel(serverApi, packet, sender, transmitter.channel);
            }
        });
    }

    public static boolean isReceivingChannel(class_1657 player, int channel) {
        List<class_1799> radios = RadioUtil.getRadios(player);
        for (class_1799 stack : radios) {
            if (!RadioUtil.isRadioEnabled(stack) || !RadioUtil.isRadioReceiving(stack) || RadioUtil.getRadioChannel(stack) != channel) continue;
            return true;
        }
        return false;
    }

    public static List<class_1799> getRadios(class_1657 player) {
        ImmutableList inventories = ImmutableList.of((Object)player.method_31548().field_7547, (Object)player.method_31548().field_7544);
        ArrayList<class_1799> radios = new ArrayList<class_1799>();
        for (List inventory : inventories) {
            for (class_1799 stack : inventory) {
                if (!stack.method_31574(ModItems.RADIO_ITEM)) continue;
                radios.add(stack);
            }
        }
        return radios;
    }

    public static GlobalRadioState getGlobalRadioState(class_3218 world) {
        return (GlobalRadioState)world.method_17983().method_17924(GlobalRadioState::fromNbt, GlobalRadioState::new, "globalRadios");
    }
}

