/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.gui;

import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.block.ReceiverBlockEntity;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.gui.RadioSelectChannelGui;
import dev.mrturtle.analog.util.RadioUtil;
import dev.mrturtle.analog.world.GlobalRadioState;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class ReceiverBlockGui
extends SimpleGui {
    private final ReceiverBlockEntity receiver;

    public ReceiverBlockGui(class_3222 player, ReceiverBlockEntity receiver) {
        super(class_3917.field_17328, player, false);
        this.receiver = receiver;
        this.createEnableButton();
        this.createChannelText();
        this.setSlot(0, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_DOWN_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_down")).setCallback(() -> {
            int currentChannel = receiver.channel;
            receiver.channel = Math.max(0, currentChannel - 1);
            class_3218 world = player.method_51469();
            GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
            if (receiver.enabled) {
                globalRadioState.audioManager.receiverTurnedOff(receiver.method_11016());
                globalRadioState.audioManager.receiverTurnedOn(world, receiver.method_11016(), receiver.channel);
            }
            receiver.method_5431();
            this.createChannelText();
        })).build());
        this.setSlot(1, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_SET_CHANNEL_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.set_channel")).setCallback(() -> {
            RadioSelectChannelGui gui = new RadioSelectChannelGui(player, receiver.channel, channel -> {
                receiver.channel = channel;
                class_3218 world = player.method_51469();
                GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
                if (receiver.enabled) {
                    globalRadioState.audioManager.receiverTurnedOff(receiver.method_11016());
                    globalRadioState.audioManager.receiverTurnedOn(world, receiver.method_11016(), receiver.channel);
                }
                receiver.method_5431();
                ReceiverBlockGui radioGui = new ReceiverBlockGui(player, receiver);
                radioGui.open();
            });
            gui.open();
        })).build());
        this.setSlot(2, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_UP_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_up")).setCallback(() -> {
            int maxRadioChannel = ConfigManager.config.maxRadioChannels - 1;
            int currentChannel = receiver.channel;
            receiver.channel = Math.min(maxRadioChannel, currentChannel + 1);
            class_3218 world = player.method_51469();
            GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
            if (receiver.enabled) {
                globalRadioState.audioManager.receiverTurnedOff(receiver.method_11016());
                globalRadioState.audioManager.receiverTurnedOn(world, receiver.method_11016(), receiver.channel);
            }
            receiver.method_5431();
            this.createChannelText();
        })).build());
    }

    private void createChannelText() {
        int currentChannel = this.receiver.channel;
        Object channelText = String.valueOf(currentChannel);
        if (((String)channelText).length() == 1) {
            channelText = "0" + (String)channelText;
        }
        this.setTitle((class_2561)this.getDefaultTitle().method_10852((class_2561)class_2561.method_43470((String)channelText)));
    }

    private void createEnableButton() {
        boolean isEnabled = this.receiver.enabled;
        this.setSlot(4, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isEnabled ? ModItems.RADIO_DISABLE_BUTTON : ModItems.RADIO_ENABLE_BUTTON).setName((class_2561)class_2561.method_43471((String)(isEnabled ? "gui.analog.radio.turn_off" : "gui.analog.radio.turn_on"))).setCallback(() -> {
            this.receiver.enabled = !isEnabled;
            class_3218 world = this.player.method_51469();
            GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
            if (this.receiver.enabled) {
                globalRadioState.audioManager.receiverTurnedOn(world, this.receiver.method_11016(), this.receiver.channel);
            } else {
                globalRadioState.audioManager.receiverTurnedOff(this.receiver.method_11016());
            }
            this.receiver.method_5431();
            this.createEnableButton();
        })).build());
    }

    public class_5250 getDefaultTitle() {
        return class_2561.method_43470((String)"aec").method_10862(class_2583.field_24360.method_10977(class_124.field_1068).method_27704(new class_2960("analog", "radio_gui")));
    }
}

