/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.FlowerPotHandler;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Amendments {
    public static final String MOD_ID = "amendments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Amendments");
    public static final List<String> OLD_MODS = List.of("supplementaries", "carpeted", "betterlily", "betterjukebox");
    private static boolean hasRun = false;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void init() {
        CommonConfigs.init();
        ModRegistry.init();
        ModNetwork.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            AmendmentsClient.init();
        }
        PlatHelper.addCommonSetupAsync(Amendments::setupAsync);
        PlatHelper.addCommonSetup(Amendments::setup);
        RegHelper.registerSimpleRecipeCondition((ResourceLocation)Amendments.res("flag"), CommonConfigs::isFlagOn);
    }

    private static void setup() {
        if (CommonConfigs.INVERSE_POTIONS.get() == null) {
            throw new IllegalStateException("Inverse potions config is null. How??");
        }
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.setup();
        }
    }

    private static void setupAsync() {
        FlowerPotHandler.setup();
    }

    public static void onCommonTagUpdate(RegistryAccess registryAccess, boolean client) {
        InteractEvents.setupOverrides();
        if (!hasRun) {
            hasRun = true;
            for (SoftFluid f : SoftFluidRegistry.getRegistry((RegistryAccess)registryAccess)) {
                Amendments.registerFluidBehavior(f);
            }
        }
        if (client) {
            AmendmentsClient.afterTagSetup();
        }
    }

    public static void registerFluidBehavior(SoftFluid f) {
        HashSet<Item> itemSet = new HashSet<Item>();
        Collection categories = f.getContainerList().getCategories();
        for (FluidContainerList.Category c : categories) {
            for (Item full : c.getFilledItems()) {
                if (full == Items.f_41852_ || itemSet.contains(full)) continue;
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new CauldronConversion.DispenserBehavior(full));
                itemSet.add(full);
            }
        }
    }

    public static boolean isSupportingCeiling(BlockPos pos, LevelReader world) {
        return Amendments.isSupportingCeiling(world.m_8055_(pos), pos, world);
    }

    public static boolean isSupportingCeiling(BlockState upState, BlockPos pos, LevelReader world) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.isSupportingCeiling(upState, pos, world);
        }
        return Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN);
    }

    public static boolean canConnectDown(BlockState neighborState, LevelAccessor level, BlockPos pos) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.canConnectDown(neighborState);
        }
        return neighborState.m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.CENTER);
    }
}

