/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.FlowerPotHandler;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_5431;
import net.minecraft.class_5455;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Amendments {
    public static final String MOD_ID = "amendments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Amendments");
    public static final List<String> OLD_MODS = List.of("supplementaries", "carpeted", "betterlily", "betterjukebox");
    private static boolean hasRun = false;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void init() {
        CommonConfigs.init();
        ModRegistry.init();
        ModNetwork.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            AmendmentsClient.init();
        }
        PlatHelper.addCommonSetupAsync(Amendments::setupAsync);
        PlatHelper.addCommonSetup(Amendments::setup);
        RegHelper.registerSimpleRecipeCondition((class_2960)Amendments.res("flag"), CommonConfigs::isFlagOn);
    }

    private static void setup() {
        if (CommonConfigs.INVERSE_POTIONS.get() == null) {
            throw new IllegalStateException("Inverse potions config is null. How??");
        }
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.setup();
        }
    }

    private static void setupAsync() {
        FlowerPotHandler.setup();
    }

    public static void onCommonTagUpdate(class_5455 registryAccess, boolean client) {
        InteractEvents.setupOverrides();
        if (!hasRun) {
            hasRun = true;
            for (SoftFluid f : SoftFluidRegistry.getRegistry((class_5455)registryAccess)) {
                Amendments.registerFluidBehavior(f);
            }
        }
        if (client) {
            AmendmentsClient.afterTagSetup();
        }
    }

    public static void registerFluidBehavior(SoftFluid f) {
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        Collection categories = f.getContainerList().getCategories();
        for (FluidContainerList.Category c : categories) {
            for (class_1792 full : c.getFilledItems()) {
                if (full == class_1802.field_8162 || itemSet.contains(full)) continue;
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new CauldronConversion.DispenserBehavior(full));
                itemSet.add(full);
            }
        }
    }

    public static boolean isSupportingCeiling(class_2338 pos, class_4538 world) {
        return Amendments.isSupportingCeiling(world.method_8320(pos), pos, world);
    }

    public static boolean isSupportingCeiling(class_2680 upState, class_2338 pos, class_4538 world) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.isSupportingCeiling(upState, pos, world);
        }
        return class_2248.method_20044((class_4538)world, (class_2338)pos, (class_2350)class_2350.field_11033);
    }

    public static boolean canConnectDown(class_2680 neighborState, class_1936 level, class_2338 pos) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.canConnectDown(neighborState);
        }
        return neighborState.method_30368((class_1922)level, pos, class_2350.field_11036, class_5431.field_25823);
    }
}

