/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment.pocket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.block.AmbientBlockGroup;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.pocket.AirPocket;
import team.creative.ambientsounds.environment.pocket.BlockDistribution;
import team.creative.creativecore.common.util.type.map.HashMapDouble;
import team.creative.creativecore.common.util.type.set.QuadBitSet;

public class AirPocketScanner
extends Thread {
    public final AmbientEngine engine;
    public final Level level;
    public final BlockPos origin;
    private List<HashMap<BlockPosInspection, BlockPosInspection>> toScan = new ArrayList<HashMap<BlockPosInspection, BlockPosInspection>>();
    private final HashMapDouble<BlockState> foundCount = new HashMapDouble();
    private QuadBitSet sky = new QuadBitSet();
    private BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    private double distributionCounter;
    private int totalSize = 0;
    private int currentDistance = 0;
    private int lightValueCounter = 0;
    private int skyLightValueCounter = 0;
    private int faceCounter = 0;
    private int air;
    private Consumer<AirPocket> consumer;

    public AirPocketScanner(AmbientEngine engine, Level level, BlockPos origin, Consumer<AirPocket> consumer) {
        this.origin = origin;
        this.engine = engine;
        this.level = level;
        this.consumer = consumer;
        this.start();
    }

    @Override
    public void run() {
        HashMap<BlockPosInspection, BlockPosInspection> first = new HashMap<BlockPosInspection, BlockPosInspection>();
        BlockPosInspection ins = new BlockPosInspection(this.origin);
        first.put(ins, ins);
        this.toScan.add(first);
        int steps = 0;
        while (this.currentDistance < this.toScan.size()) {
            for (BlockPosInspection pos : this.toScan.get(this.currentDistance).keySet()) {
                this.scan(this.level, this.currentDistance, pos);
                if (++steps <= AmbientSounds.CONFIG.scanStepAmount) continue;
                steps = 0;
                try {
                    AirPocketScanner.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.currentDistance;
        }
        HashMap<String, BlockDistribution> distribution = new HashMap<String, BlockDistribution>();
        for (Map.Entry<String, AmbientBlockGroup> entry : this.engine.blockGroups.entrySet()) {
            BlockDistribution dist = new BlockDistribution();
            for (Map.Entry state : this.foundCount.entrySet()) {
                if (!entry.getValue().is((BlockState)state.getKey())) continue;
                dist.add((Double)state.getValue());
            }
            dist.calculatePercentage(this.distributionCounter);
            distribution.put(entry.getKey(), dist);
        }
        this.consumer.accept(new AirPocket(this.engine, distribution, (double)this.lightValueCounter / (double)this.faceCounter, (double)this.skyLightValueCounter / (double)this.faceCounter, (double)this.air / (double)this.engine.maxAirPocketCount));
    }

    protected HashMap<BlockPosInspection, BlockPosInspection> getOrCreate(int distance) {
        if (distance >= this.toScan.size()) {
            HashMap<BlockPosInspection, BlockPosInspection> set = new HashMap<BlockPosInspection, BlockPosInspection>();
            this.toScan.add(set);
            return set;
        }
        return this.toScan.get(distance);
    }

    protected void findState(BlockState state, int distance) {
        double factor = this.engine.airWeightFactor(distance);
        this.distributionCounter += factor;
        this.foundCount.put((Object)state, Double.valueOf(factor));
    }

    protected boolean hearThrough(LevelReader level, BlockState state, BlockPos pos) {
        return state.m_60795_() || !state.m_60838_((BlockGetter)level, pos) && !this.engine.considerSolid.is(state);
    }

    protected void scan(Level level, int distance, BlockPosInspection pos) {
        BlockState state = level.m_8055_((BlockPos)pos);
        if (this.hearThrough((LevelReader)level, state, pos)) {
            if (!state.m_60795_()) {
                this.findState(state, distance);
            }
            if (distance < this.engine.airPocketDistance && this.air < this.engine.maxAirPocketCount) {
                ++this.air;
            }
            ++distance;
            if (this.sky.get(pos.m_123341_(), pos.m_123343_()) && this.sky.get(pos.m_123341_() - 1, pos.m_123343_()) && this.sky.get(pos.m_123341_(), pos.m_123343_() - 1) && this.sky.get(pos.m_123341_() + 1, pos.m_123343_()) && this.sky.get(pos.m_123341_(), pos.m_123343_() + 1)) {
                return;
            }
            for (int i = 0; i < Direction.values().length; ++i) {
                BlockPos newPos;
                if (this.totalSize > this.engine.airPocketCount) {
                    return;
                }
                Direction direction = Direction.values()[i];
                Direction.Axis axis = direction.m_122434_();
                if (direction.m_122421_() != Direction.AxisDirection.POSITIVE ? pos.m_123304_(axis) - 1 >= this.origin.m_123304_(axis) : pos.m_123304_(axis) + 1 <= this.origin.m_123304_(axis)) continue;
                HashMap<BlockPosInspection, BlockPosInspection> map = this.getOrCreate(distance);
                BlockPosInspection ins = map.get(newPos = pos.m_121945_(direction));
                if (ins != null) {
                    ins.add(direction.m_122424_());
                } else {
                    ins = new BlockPosInspection(newPos, direction.m_122424_());
                    map.put(ins, ins);
                }
                ++this.totalSize;
            }
        } else {
            if (!this.sky.get(pos.m_123341_(), pos.m_123343_()) && pos.isUp() && this.canSeeSkyConsiderSolids((LevelReader)level, pos)) {
                this.sky.set(pos.m_123341_(), pos.m_123343_());
                if (distance < this.engine.airPocketDistance) {
                    this.air = this.engine.maxAirPocketCount;
                }
            }
            for (Direction direction : pos) {
                BlockPos other = pos.m_121945_(direction);
                this.lightValueCounter += level.m_7146_(other);
                this.skyLightValueCounter += level.m_45517_(LightLayer.SKY, other);
                ++this.faceCounter;
            }
            this.findState(state, distance);
        }
    }

    protected boolean canSeeSkyConsiderSolids(LevelReader level, BlockPos pos) {
        this.mutable.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        if (!level.m_45527_((BlockPos)this.mutable)) {
            return false;
        }
        int maxHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        for (int y = this.mutable.m_123342_(); y <= maxHeight; ++y) {
            this.mutable.m_142448_(y);
            if (this.hearThrough(level, level.m_8055_((BlockPos)this.mutable), (BlockPos)this.mutable)) continue;
            return false;
        }
        return true;
    }

    public static class BlockPosInspection
    extends BlockPos
    implements Iterable<Direction> {
        protected boolean east;
        protected boolean west;
        protected boolean up;
        protected boolean down;
        protected boolean south;
        protected boolean north;

        public BlockPosInspection(BlockPos pos) {
            super((Vec3i)pos);
            this.north = true;
            this.south = true;
            this.down = true;
            this.up = true;
            this.west = true;
            this.east = true;
        }

        public BlockPosInspection(BlockPos pos, Direction direction) {
            super((Vec3i)pos);
            this.add(direction);
        }

        public void add(Direction direction) {
            switch (direction) {
                case DOWN: {
                    this.down = true;
                    break;
                }
                case EAST: {
                    this.east = true;
                    break;
                }
                case NORTH: {
                    this.north = true;
                    break;
                }
                case SOUTH: {
                    this.south = true;
                    break;
                }
                case UP: {
                    this.up = true;
                    break;
                }
                case WEST: {
                    this.west = true;
                    break;
                }
            }
        }

        public boolean isUp() {
            return this.up;
        }

        public boolean is(Direction direction) {
            switch (direction) {
                case DOWN: {
                    return this.down;
                }
                case EAST: {
                    return this.east;
                }
                case NORTH: {
                    return this.north;
                }
                case SOUTH: {
                    return this.south;
                }
                case UP: {
                    return this.up;
                }
                case WEST: {
                    return this.west;
                }
            }
            return false;
        }

        @Override
        public Iterator<Direction> iterator() {
            return new Iterator<Direction>(){
                int next = this.findNext(-1);

                int findNext(int next) {
                    while (next < 6) {
                        switch (++next) {
                            case 0: {
                                if (!east) break;
                                return next;
                            }
                            case 1: {
                                if (!west) break;
                                return next;
                            }
                            case 2: {
                                if (!up) break;
                                return next;
                            }
                            case 3: {
                                if (!down) break;
                                return next;
                            }
                            case 4: {
                                if (!south) break;
                                return next;
                            }
                            case 5: {
                                if (!north) break;
                                return next;
                            }
                        }
                    }
                    return next;
                }

                @Override
                public boolean hasNext() {
                    return this.next >= 0 && this.next < 6;
                }

                @Override
                public Direction next() {
                    Direction result = switch (this.next) {
                        case 0 -> Direction.EAST;
                        case 1 -> Direction.WEST;
                        case 2 -> Direction.UP;
                        case 3 -> Direction.DOWN;
                        case 4 -> Direction.SOUTH;
                        case 5 -> Direction.NORTH;
                        default -> null;
                    };
                    this.next = this.findNext(this.next);
                    return result;
                }
            };
        }
    }
}

