/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.creativecore.common.util.math.interpolation.LinearInterpolation;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.type.list.TupleList;

@JsonAdapter(value=Serializer.class)
public abstract class AmbientTime {
    public static final HashMap<String, AmbientTimePremade> PREMADE = new HashMap();
    public static final double ANGLE_TO_TIME = 0.06666666666666667;
    public static final double TIME_TO_ANGLE = 15.0;
    public static final double FADE = 1.0;
    public static final AmbientTime NONE = new AmbientTime(){

        @Override
        public double value(AmbientEnvironment env) {
            return 0.0;
        }

        @Override
        public JsonElement toJson() {
            return new JsonArray();
        }
    };
    public static final AmbientTimePremade DAY = new AmbientTimePremade("day", 1.0, 6.0, 18.0);
    public static final AmbientTimePremade NIGHT = new AmbientTimePremade("night", 0.0, 1.0, 4.0, 1.0, 5.0, 0.0, 19.0, 0.0, 19.0, 1.0, 24.0, 1.0);
    public static final AmbientTimePremade SUNRISE = new AmbientTimePremade("sunrise", 1.0, 5.0, 6.0);
    public static final AmbientTimePremade SUNSET = new AmbientTimePremade("sunset", 1.0, 18.0, 19.0);
    public static final AmbientTimePremade NOON = new AmbientTimePremade("noon", 0.5, 10.5, 13.5);
    public static final AmbientTimePremade MIDNIGHT = new AmbientTimePremade("midnight", 0.0, 1.0, 1.0, 1.0, 1.5, 0.0, 22.5, 0.0, 23.0, 1.0, 24.0, 1.0);

    public abstract double value(AmbientEnvironment var1);

    public abstract JsonElement toJson();

    public static class AmbientTimePremade
    extends AmbientTimeHour {
        public final String name;

        public AmbientTimePremade(String name, double fade, double begin, double end) {
            super(begin, 0.0, begin + fade, 1.0, end - fade, 1.0, end, 0.0);
            this.name = name;
            PREMADE.put(name, this);
        }

        public AmbientTimePremade(String name, double ... times) {
            super(times);
            this.name = name;
            PREMADE.put(name, this);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(this.name);
        }
    }

    public static class Serializer
    implements JsonDeserializer<AmbientTime>,
    JsonSerializer<AmbientTime> {
        public JsonElement serialize(AmbientTime src, Type typeOfSrc, JsonSerializationContext context) {
            return src.toJson();
        }

        public AmbientTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                if (!json.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Invalid json element given " + json);
                }
                AmbientTimePremade premade = PREMADE.get(json.getAsString());
                if (premade == null) {
                    throw new JsonParseException("Invalid time given " + json);
                }
                return premade;
            }
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                if (array.isEmpty()) {
                    return NONE;
                }
                AmbientTimePremade[] content = new AmbientTimePremade[array.size()];
                for (int i = 0; i < content.length; ++i) {
                    AmbientTimePremade premade = (AmbientTimePremade)AmbientTimePremade.PREMADE.get(array.get(i).getAsString());
                    if (premade == null) {
                        throw new JsonParseException("Invalid time given " + array.get(i));
                    }
                    content[i] = premade;
                }
                return new AmbientTimeMulti(content);
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("Invalid json element given " + json);
            }
            JsonObject object = json.getAsJsonObject();
            DoubleArrayList list = new DoubleArrayList();
            for (Map.Entry entry : object.entrySet()) {
                try {
                    list.add(Double.parseDouble((String)entry.getKey()));
                    list.add(((JsonElement)entry.getValue()).getAsDouble());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (object.has("type") && object.get("type").getAsString().equalsIgnoreCase("angle")) {
                return new AmbientTimeSunAngle(list.toDoubleArray());
            }
            return new AmbientTimeHour(list.toDoubleArray());
        }
    }

    public static class AmbientTimeMulti
    extends AmbientTime {
        public final AmbientTimePremade[] times;

        public AmbientTimeMulti(AmbientTimePremade ... times) {
            this.times = times;
        }

        @Override
        public double value(AmbientEnvironment env) {
            double value = 0.0;
            for (int i = 0; i < this.times.length; ++i) {
                value = Math.max(value, this.times[i].value(env));
            }
            return value;
        }

        @Override
        public JsonElement toJson() {
            JsonArray array = new JsonArray(this.times.length);
            for (int i = 0; i < this.times.length; ++i) {
                array.add(this.times[i].name);
            }
            return array;
        }
    }

    public static class AmbientTimeHour
    extends AmbientTime {
        private final LinearInterpolation<Vec1d> interpolation;
        private final double[] times;

        public AmbientTimeHour(double ... times) {
            this.times = times;
            if (times.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid times " + Arrays.toString(times) + " cannot calculate ambient time");
            }
            TupleList points = new TupleList();
            if (times[times.length - 2] < 24.0) {
                points.add((Object)(times[times.length - 2] - 24.0), (Object)new Vec1d(times[times.length - 1]));
            }
            for (int i = 0; i < times.length; i += 2) {
                points.add((Object)times[i], (Object)new Vec1d(times[i + 1]));
            }
            if (times[0] > 0.0) {
                points.add((Object)(times[0] + 24.0), (Object)new Vec1d(times[1]));
            }
            this.interpolation = new LinearInterpolation(points);
        }

        @Override
        public double value(AmbientEnvironment env) {
            return ((Vec1d)this.interpolation.valueAt((double)env.dayTimeHour)).x;
        }

        @Override
        public JsonElement toJson() {
            JsonObject object = new JsonObject();
            for (int i = 0; i < this.times.length; i += 2) {
                object.add("" + this.times[i], (JsonElement)new JsonPrimitive((Number)this.times[i + 1]));
            }
            return object;
        }
    }

    public static class AmbientTimeSunAngle
    extends AmbientTime {
        private final LinearInterpolation<Vec1d> interpolation;
        private final double[] times;

        public AmbientTimeSunAngle(double ... times) {
            this.times = times;
            if (times.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid times " + Arrays.toString(times) + " cannot calculate ambient time");
            }
            TupleList points = new TupleList();
            points.add((Object)(times[times.length - 2] - 360.0), (Object)new Vec1d(times[times.length - 1]));
            for (int i = 0; i < times.length; i += 2) {
                points.add((Object)times[i], (Object)new Vec1d(times[i + 1]));
            }
            points.add((Object)(times[0] + 360.0), (Object)new Vec1d(times[1]));
            this.interpolation = new LinearInterpolation(points);
        }

        @Override
        public double value(AmbientEnvironment env) {
            return ((Vec1d)this.interpolation.valueAt((double)env.sunAngle)).x;
        }

        @Override
        public JsonElement toJson() {
            JsonObject object = new JsonObject();
            object.add("type", (JsonElement)new JsonPrimitive("angle"));
            for (int i = 0; i < this.times.length; i += 2) {
                object.add("" + this.times[i], (JsonElement)new JsonPrimitive((Number)this.times[i + 1]));
            }
            return object;
        }
    }
}

