/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.block;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public final class AmbientBlockFilters {
    public static final NamedHandlerRegistry<Function<String, Predicate<BlockState>>> REGISTRY = new NamedHandlerRegistry(x -> state -> true);

    public static Predicate<BlockState> get(String data) {
        String[] conditions = data.split("&");
        Predicate[] parsed = new Predicate[conditions.length];
        for (int i = 0; i < parsed.length; ++i) {
            parsed[i] = AmbientBlockFilters.parse(conditions[i]);
        }
        return state -> {
            for (int i = 0; i < parsed.length; ++i) {
                if (parsed[i].test(state)) continue;
                return false;
            }
            return true;
        };
    }

    private static Predicate<BlockState> parse(String data) {
        String[] parts = data.split("->");
        if (parts.length == 1) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(parts[0]));
            return state -> state.m_60734_() == block;
        }
        if (parts.length != 2) {
            AmbientSounds.LOGGER.error("Found invalid block filter '{}'. It will be ignored", (Object)data);
            return state -> true;
        }
        try {
            return (Predicate)((Function)REGISTRY.getOrThrow(parts[0])).apply(parts[1]);
        }
        catch (IllegalArgumentException e) {
            AmbientSounds.LOGGER.error("Found invalid block filter type {}. '{}' will be ignored", (Object)parts[0], (Object)data);
            return state -> true;
        }
    }

    static {
        REGISTRY.register("t", data -> {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(data));
            return state -> state.m_204336_(tag);
        });
        REGISTRY.register("p", data -> {
            String[] parts = data.split("=");
            if (parts.length != 2) {
                AmbientSounds.LOGGER.error("Found invalid property condition '{}'. It will be ignored", data);
                return state -> true;
            }
            return state -> {
                Property property = state.m_60734_().m_49965_().m_61081_(parts[0]);
                if (property == null) {
                    return false;
                }
                Optional value = property.m_6215_(parts[1]);
                if (value.isPresent()) {
                    return state.m_61143_(property).equals(value.get());
                }
                return false;
            };
        });
    }
}

