/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.api;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.Shape;

public interface OffsetProvider {
    public static final OffsetProvider HEAD = OffsetProvider.createVanilla(Shape.HEAD, false);
    public static final OffsetProvider LEFT_LEG = OffsetProvider.createVanilla(Shape.LEGS, false);
    public static final OffsetProvider RIGHT_LEG = OffsetProvider.createVanilla(Shape.LEGS, false);
    public static final OffsetProvider LEFT_ARM = OffsetProvider.createVanilla(Shape.ARMS, false);
    public static final OffsetProvider LEFT_ARM_SLIM = OffsetProvider.createVanilla(Shape.ARMS_SLIM, false);
    public static final OffsetProvider RIGHT_ARM = OffsetProvider.createVanilla(Shape.ARMS, true);
    public static final OffsetProvider RIGHT_ARM_SLIM = OffsetProvider.createVanilla(Shape.ARMS_SLIM, true);
    public static final OffsetProvider BODY = OffsetProvider.createVanilla(Shape.BODY, false);

    public void applyOffset(PoseStack var1, Mesh var2);

    private static OffsetProvider createVanilla(Shape shape, boolean mirrored) {
        return (stack, mesh) -> {
            float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
            float heightScaling = 1.035f;
            float widthScaling = SkinLayersModBase.config.baseVoxelSize;
            float x = 0.0f;
            float y = 0.0f;
            if (shape == Shape.ARMS) {
                x = 0.998f;
            } else if (shape == Shape.ARMS_SLIM) {
                x = 0.499f;
            }
            if (shape == Shape.BODY) {
                widthScaling = SkinLayersModBase.config.bodyVoxelWidthSize;
            }
            if (mirrored) {
                x *= -1.0f;
            }
            if (shape == Shape.HEAD) {
                float voxelSize = SkinLayersModBase.config.headVoxelSize;
                stack.m_85837_(0.0, -0.25, 0.0);
                stack.m_85841_(voxelSize, voxelSize, voxelSize);
                stack.m_85837_(0.0, 0.25, 0.0);
                stack.m_85837_(0.0, -0.04, 0.0);
            } else {
                stack.m_85841_(widthScaling, heightScaling, pixelScaling);
                y = shape.yOffsetMagicValue();
            }
            mesh.setPosition(x, y, 0.0f);
        };
    }
}

