/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshTransformer;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.skinlayers.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

class CustomizableModelPart
implements Mesh {
    private float x;
    private float y;
    private float z;
    private float xRot;
    private float yRot;
    private float zRot;
    private boolean visible = true;
    private final List<ModelPart.Cube> cubes;
    private final Map<String, ModelPart> children;
    private float[] polygonData = null;
    private int polygonAmount = 0;
    private final int polyDataSize = 23;
    private Vector4f[] vector4f = new Vector4f[]{new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f()};

    public CustomizableModelPart(List<ModelPart.Cube> list, List<CustomizableCube> customCubes, Map<String, ModelPart> map) {
        this.cubes = list;
        this.children = map;
        this.compactCubes(customCubes);
    }

    private void compactCubes(List<CustomizableCube> customCubes) {
        for (CustomizableCube cube : customCubes) {
            this.polygonAmount += cube.polygonCount;
        }
        this.polygonData = new float[this.polygonAmount * 23];
        int offset = 0;
        for (CustomizableCube cube : customCubes) {
            for (int id = 0; id < cube.polygonCount; ++id) {
                CustomizableCube.Polygon polygon = cube.polygons[id];
                Vector3f vector3f = polygon.normal;
                this.polygonData[offset + 0] = vector3f.x();
                this.polygonData[offset + 1] = vector3f.y();
                this.polygonData[offset + 2] = vector3f.z();
                for (int i = 0; i < 4; ++i) {
                    CustomizableCube.Vertex vertex = polygon.vertices[i];
                    this.polygonData[offset + 3 + i * 5 + 0] = vertex.scaledX;
                    this.polygonData[offset + 3 + i * 5 + 1] = vertex.scaledY;
                    this.polygonData[offset + 3 + i * 5 + 2] = vertex.scaledZ;
                    this.polygonData[offset + 3 + i * 5 + 3] = vertex.u;
                    this.polygonData[offset + 3 + i * 5 + 4] = vertex.v;
                }
                offset += 23;
            }
        }
    }

    @Override
    public void loadPose(PartPose partPose) {
        this.x = partPose.f_171405_;
        this.y = partPose.f_171406_;
        this.z = partPose.f_171407_;
        this.xRot = partPose.f_171408_;
        this.yRot = partPose.f_171409_;
        this.zRot = partPose.f_171410_;
    }

    @Override
    public void copyFrom(ModelPart modelPart) {
        this.xRot = modelPart.f_104203_;
        this.yRot = modelPart.f_104204_;
        this.zRot = modelPart.f_104205_;
        this.x = modelPart.f_104200_;
        this.y = modelPart.f_104201_;
        this.z = modelPart.f_104202_;
    }

    public ModelPart getChild(String string) {
        ModelPart modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    @Override
    public void setPosition(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    @Override
    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j) {
        this.render(null, poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void render(ModelPart vanillaModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.visible) {
            return;
        }
        poseStack.m_85836_();
        this.translateAndRotate(poseStack);
        this.compile(vanillaModel, poseStack.m_85850_(), vertexConsumer, light, overlay, red, green, blue, alpha);
        for (ModelPart modelPart : this.children.values()) {
            modelPart.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.m_252880_(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
    }

    private void compile(ModelPart vanillaModel, PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        MeshTransformer transformer = SkinLayersAPI.getMeshTransformerProvider().prepareTransformer(vanillaModel);
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        for (int id = 0; id < this.polygonData.length; id += 23) {
            int o;
            Vector3f vector3f = new Vector3f(this.polygonData[id + 0], this.polygonData[id + 1], this.polygonData[id + 2]);
            for (o = 0; o < 4; ++o) {
                this.vector4f[o].set(this.polygonData[id + 3 + o * 5 + 0], this.polygonData[id + 3 + o * 5 + 1], this.polygonData[id + 3 + o * 5 + 2], 1.0f);
            }
            transformer.transform(vector3f, this.vector4f);
            vector3f = matrix3f.transform(vector3f);
            for (o = 0; o < 4; ++o) {
                matrix4f.transform(this.vector4f[o]);
                vertexConsumer.m_5954_(this.vector4f[o].x(), this.vector4f[o].y(), this.vector4f[o].z(), red, green, blue, alpha, this.polygonData[id + 3 + o * 5 + 3], this.polygonData[id + 3 + o * 5 + 4], overlay, light, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
        for (ModelPart.Cube cube : this.cubes) {
            transformer.transform(cube);
            cube.m_171332_(pose, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

