/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

class CustomizableCube
extends ModelPart.Cube {
    private final Direction[] hidden;
    protected final Polygon[] polygons;
    protected int polygonCount = 0;
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public CustomizableCube(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, Direction[] hide, Direction[][] hideCorners) {
        super(u, v, x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirror, textureWidth, textureHeight, Collections.emptySet());
        this.hidden = hide;
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x + sizeX;
        this.maxY = y + sizeY;
        this.maxZ = z + sizeZ;
        this.polygons = new Polygon[6];
        float pX = x + sizeX;
        float pY = y + sizeY;
        float pZ = z + sizeZ;
        x -= extraX;
        y -= extraY;
        z -= extraZ;
        pX += extraX;
        pY += extraY;
        pZ += extraZ;
        if (mirror) {
            float i = pX;
            pX = x;
            x = i;
        }
        Vertex vertexNNN = new Vertex(x, y, z, 0.0f, 0.0f);
        Vertex vertexPNN = new Vertex(pX, y, z, 0.0f, 8.0f);
        Vertex vertexPPN = new Vertex(pX, pY, z, 8.0f, 8.0f);
        Vertex vertexNPN = new Vertex(x, pY, z, 8.0f, 0.0f);
        Vertex vertexNNP = new Vertex(x, y, pZ, 0.0f, 0.0f);
        Vertex vertexPNP = new Vertex(pX, y, pZ, 0.0f, 8.0f);
        Vertex vertexPPP = new Vertex(pX, pY, pZ, 8.0f, 8.0f);
        Vertex vertexNPP = new Vertex(x, pY, pZ, 8.0f, 0.0f);
        float minU = u;
        float maxU = (float)u + 1.0f;
        float minV = v;
        float maxV = (float)v + 1.0f;
        HashMap<Direction.Axis, Direction[]> axisToCorner = new HashMap<Direction.Axis, Direction[]>();
        block0: for (Direction[] corner : hideCorners) {
            block1: for (Direction.Axis axis : Direction.Axis.f_122448_) {
                for (Direction dir : corner) {
                    if (dir.m_122434_() == axis) continue block1;
                }
                axisToCorner.put(axis, corner);
                continue block0;
            }
        }
        if (this.visibleFace(Direction.DOWN)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPNP, vertexNNP, vertexNNN, vertexPNN}, (Direction[])axisToCorner.get(Direction.Axis.Y)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, Direction.DOWN);
        }
        if (this.visibleFace(Direction.UP)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPPN, vertexNPN, vertexNPP, vertexPPP}, (Direction[])axisToCorner.get(Direction.Axis.Y)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, Direction.UP);
        }
        if (this.visibleFace(Direction.NORTH)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPNN, vertexNNN, vertexNPN, vertexPPN}, (Direction[])axisToCorner.get(Direction.Axis.Z)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, Direction.NORTH);
        }
        if (this.visibleFace(Direction.SOUTH)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexNNP, vertexPNP, vertexPPP, vertexNPP}, (Direction[])axisToCorner.get(Direction.Axis.Z)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, Direction.SOUTH);
        }
        if (this.visibleFace(Direction.WEST)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexNNN, vertexNNP, vertexNPP, vertexNPN}, (Direction[])axisToCorner.get(Direction.Axis.X)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, Direction.WEST);
        }
        if (this.visibleFace(Direction.EAST)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPNP, vertexPNN, vertexPPN, vertexPPP}, (Direction[])axisToCorner.get(Direction.Axis.X)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, Direction.EAST);
        }
    }

    private boolean visibleFace(Direction face) {
        for (Direction dir : this.hidden) {
            if (dir != face) continue;
            return false;
        }
        return true;
    }

    private static Vertex[] removeCornerVertex(Vertex[] vertices, Direction[] corner) {
        if (corner == null) {
            return vertices;
        }
        Vertex except = vertices[0];
        for (int i = 1; i < 4; ++i) {
            except = CustomizableCube.compareVertices(except, vertices[i], corner);
        }
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (vertices[i] == except) continue;
            vertices[index++] = vertices[i];
        }
        vertices[3] = vertices[2];
        return vertices;
    }

    private static Vertex compareVertices(Vertex vertex1, Vertex vertex2, Direction[] corner) {
        for (Direction dir : corner) {
            double d = dir.m_122434_().m_6150_((double)(vertex1.pos.x() - vertex2.pos.x()), (double)(vertex1.pos.y() - vertex2.pos.y()), (double)(vertex1.pos.z() - vertex2.pos.z())) * (double)dir.m_122421_().m_122540_();
            if (d > 0.0) {
                return vertex1;
            }
            if (!(d < 0.0)) continue;
            return vertex2;
        }
        return vertex1;
    }

    public void m_171332_(PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        for (int id = 0; id < this.polygonCount; ++id) {
            Polygon polygon = this.polygons[id];
            Vector3f vector3f = new Vector3f((Vector3fc)polygon.normal);
            vector3f.mul((Matrix3fc)matrix3f);
            float x = vector3f.x();
            float y = vector3f.y();
            float z = vector3f.z();
            for (int i = 0; i < 4; ++i) {
                Vertex vertex = polygon.vertices[i];
                Vector4f vector4f = new Vector4f(vertex.scaledX, vertex.scaledY, vertex.scaledZ, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                vertexConsumer.m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), red, green, blue, alpha, vertex.u, vertex.v, overlay, light, x, y, z);
            }
        }
    }

    protected static class Polygon {
        public final Vertex[] vertices;
        public final Vector3f normal;

        public Polygon(Vertex[] vertexs, float minU, float minV, float maxU, float maxV, float textureWidth, float textureHeight, boolean mirror, Direction direction) {
            this.vertices = vertexs;
            float zeroWidth = 0.0f / textureWidth;
            float zeroHeight = 0.0f / textureHeight;
            vertexs[0] = vertexs[0].remap(maxU / textureWidth - zeroWidth, minV / textureHeight + zeroHeight);
            vertexs[1] = vertexs[1].remap(minU / textureWidth + zeroWidth, minV / textureHeight + zeroHeight);
            vertexs[2] = vertexs[2].remap(minU / textureWidth + zeroWidth, maxV / textureHeight - zeroHeight);
            vertexs[3] = vertexs[3].remap(maxU / textureWidth - zeroWidth, maxV / textureHeight - zeroHeight);
            if (mirror) {
                int vertexCount = vertexs.length;
                for (int i = 0; i < vertexCount / 2; ++i) {
                    Vertex vertex = vertexs[i];
                    vertexs[i] = vertexs[vertexCount - 1 - i];
                    vertexs[vertexCount - 1 - i] = vertex;
                }
            }
            this.normal = direction.m_253071_();
            if (mirror) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    protected static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;
        public final float scaledX;
        public final float scaledY;
        public final float scaledZ;

        public Vertex(float x, float y, float z, float u, float v) {
            this(new Vector3f(x, y, z), u, v);
        }

        public Vertex remap(float u, float v) {
            return new Vertex(this.pos, u, v);
        }

        public Vertex(Vector3f vector3f, float u, float v) {
            this.pos = vector3f;
            this.u = u;
            this.v = v;
            this.scaledX = this.pos.x() / 16.0f;
            this.scaledY = this.pos.y() / 16.0f;
            this.scaledZ = this.pos.z() / 16.0f;
        }
    }
}

