/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.hydrogen.common.jvm;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import me.jellysquid.mods.hydrogen.common.jvm.ClassDefineTool;

public class ClassConstructors {
    private static MethodHandle FAST_IMMUTABLE_REFERENCE_HASH_MAP_CONSTRUCTOR;

    public static void init() {
        ClassConstructors.initGuavaExtensions();
    }

    private static void initGuavaExtensions() {
        ClassDefineTool.defineClass(ImmutableMap.class, "com.google.common.collect.HydrogenImmutableMapEntry");
        ClassDefineTool.defineClass(ImmutableMap.class, "com.google.common.collect.HydrogenEntrySetIterator");
        ClassDefineTool.defineClass(ImmutableMap.class, "com.google.common.collect.HydrogenEntrySet");
        Class<?> immutableRefHashMapClass = ClassDefineTool.defineClass(ImmutableMap.class, "com.google.common.collect.HydrogenImmutableReferenceHashMap");
        try {
            FAST_IMMUTABLE_REFERENCE_HASH_MAP_CONSTRUCTOR = MethodHandles.lookup().findConstructor(immutableRefHashMapClass, MethodType.methodType(Void.TYPE, Map.class)).asType(MethodType.methodType(ImmutableMap.class, Map.class));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to find constructor", e);
        }
    }

    public static <K, V> ImmutableMap<K, V> createFastImmutableMap(Map<K, V> orig) {
        try {
            return FAST_IMMUTABLE_REFERENCE_HASH_MAP_CONSTRUCTOR.invokeExact(orig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not instantiate collection", e);
        }
    }
}

