/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.hydrogen.common.jvm;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassDefineTool {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Logger LOGGER = LogManager.getLogger((String)"Hydrogen");

    public static Class<?> defineClass(Class<?> context, String name) {
        byte[] code;
        String path = "/" + name.replace('.', '/') + ".class";
        URL url = ClassDefineTool.class.getResource(path);
        if (url == null) {
            throw new RuntimeException("Couldn't find resource: " + path);
        }
        LOGGER.info("Injecting class '{}' (url: {})", (Object)name, (Object)url);
        try {
            code = IOUtils.toByteArray((URL)url);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read class bytes from resources: " + path, e);
        }
        try {
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(context, LOOKUP);
            return privateLookup.defineClass(code);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to define class", throwable);
        }
    }
}

