/*
 * Decompiled with CFR 0.152.
 */
package createbicyclesbitterballen.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import createbicyclesbitterballen.CreateBicBitMod;
import createbicyclesbitterballen.index.BlockRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FluidsRegistry {
    private static final float FRYING_OIL_FOG_DISTANCE = 0.2f;
    public static final ResourceLocation FRYINGOIL_STILL_RL = new ResourceLocation("create_bic_bit", "block/fryingoil_still");
    public static final ResourceLocation FRYINGOIL_FLOW_RL = new ResourceLocation("create_bic_bit", "block/fryingoil_flow");
    private static final FluidBuilder.FluidTypeFactory FRYING_OIL_TYPE_FACTORY = (properties, still, flowing) -> {
        CustomSolidRenderedFluidType fluidType = new CustomSolidRenderedFluidType(properties, FRYINGOIL_STILL_RL, FRYINGOIL_FLOW_RL);
        fluidType.fogColor = new Vector3f(0.92941177f, 0.76862746f, 0.5137255f);
        fluidType.fogDistance = () -> Float.valueOf(0.2f);
        return fluidType;
    };
    public static final FluidEntry<ForgeFlowingFluid.Flowing> FRYING_OIL = CreateBicBitMod.REGISTRATE.standardFluid("frying_oil", FRYING_OIL_TYPE_FACTORY).lang("Frying Oil").properties(b -> b.viscosity(1500).density(500)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(5).explosionResistance(100.0f)).register();
    public static final ResourceLocation STAMPPOT_STILL_RL = new ResourceLocation("create_bic_bit", "block/stamppot");
    public static final ResourceLocation STAMPPOT_FLOW_RL = new ResourceLocation("create_bic_bit", "block/stamppot");
    public static final FluidEntry<VirtualFluid> STAMPPOT = CreateBicBitMod.REGISTRATE.virtualFluid("stamppot", STAMPPOT_STILL_RL, STAMPPOT_FLOW_RL, CreateRegistrate::defaultFluidType, VirtualFluid::new).lang("Stamppot").register();

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)FRYING_OIL.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((GlassBlock)BlockRegistry.CRYSTALLISED_OIL.get()).m_49966_();
        }));
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_6212_((Fluid)FRYING_OIL.get())) {
            return ((GlassBlock)BlockRegistry.CRYSTALLISED_OIL.get()).m_49966_();
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerStep(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level world = player.m_20193_();
        if (this.isInFryingOil(player, world) && world.m_46471_()) {
            this.applyLevitationEffect(player);
        }
    }

    private boolean isInFryingOil(Player player, Level world) {
        BlockPos pos = player.m_20183_();
        FluidState fluidState = world.m_6425_(pos);
        Fluid fluid = fluidState.m_76152_();
        return fluid.m_6212_((Fluid)FRYING_OIL.get());
    }

    private void applyLevitationEffect(Player player) {
        MobEffectInstance levitation = new MobEffectInstance(MobEffects.f_19620_, 100, 0);
        player.m_7292_(levitation);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.grantAdvancementCriterion(serverPlayer, "create_bic_bit:step_3", "got_levitation");
        }
    }

    private void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        AdvancementProgress advancementProgress;
        PlayerAdvancements playerAdvancements = player.m_8960_();
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(advancementID));
        if (advancement != null && advancement.m_138325_().containsKey(criterionKey) && !(advancementProgress = playerAdvancements.m_135996_(advancement)).m_8193_()) {
            playerAdvancements.m_135988_(advancement, criterionKey);
        }
    }

    private static class CustomSolidRenderedFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public CustomSolidRenderedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return -1;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected abstract Vector3f getCustomFogColor();

        protected abstract float getFogDistanceModifier();
    }
}

