/*
 * Decompiled with CFR 0.152.
 */
package createbicyclesbitterballen.block.mechanicalfryer;

import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import createbicyclesbitterballen.index.RecipeRegistry;
import createbicyclesbitterballen.index.SoundsRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class MechanicalFryerEntity
extends BasinOperatingBlockEntity {
    private static final Object DeepFryingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalFryerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
        if (clientPacket && this.m_58898_()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
    }

    public void tick() {
        super.tick();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.f_58857_ != null) {
            if (this.f_58857_.f_46443_ && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!this.f_58857_.f_46443_ || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple tanks;
                    int t;
                    float recipeSpeed = 1.0f;
                    if (this.currentRecipe instanceof ProcessingRecipe && (t = ((ProcessingRecipe)this.currentRecipe).getProcessingDuration()) != 0) {
                        recipeSpeed = (float)t / 100.0f;
                    }
                    this.processingTicks = Mth.m_14045_((int)(Mth.m_14173_((int)((int)(512.0f / speed))) * Mth.m_14167_((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    Optional basin = this.getBasin();
                    if (!(!basin.isPresent() || ((SmartFluidTankBehaviour)(tanks = ((BasinBlockEntity)basin.get()).getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11773_, SoundSource.BLOCKS, 0.75f, 1.6f);
                    }
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    public void renderParticles() {
        Optional basin = this.getBasin();
        if (!basin.isPresent() || this.f_58857_ == null) {
            return;
        }
        for (SmartFluidTankBehaviour behaviour : ((BasinBlockEntity)basin.get()).getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle((FluidStack)tankSegment.getRenderedFluid()));
            }
        }
    }

    protected void spillParticle(ParticleOptions data) {
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).m_82520_(0.0, 0.25, 0.0);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_(data, center.f_82479_, center.f_82480_ - 1.75, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List matchingRecipes = super.getMatchingRecipes();
        Optional basin = this.getBasin();
        if (!basin.isPresent()) {
            return matchingRecipes;
        }
        BasinBlockEntity basinBlockEntity = (BasinBlockEntity)basin.get();
        if (basin.isEmpty()) {
            return matchingRecipes;
        }
        IItemHandler availableItems = (IItemHandler)basinBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (availableItems == null) {
            return matchingRecipes;
        }
        return matchingRecipes;
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == RecipeRegistry.DEEP_FRYING.getType();
    }

    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    protected Object getRecipeCacheKey() {
        return DeepFryingRecipesKey;
    }

    protected boolean isRunning() {
        return this.running;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            SoundsRegistry.FRYING.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 1.0f, true);
        }
    }
}

