/*
 * Decompiled with CFR 0.152.
 */
package createbicyclesbitterballen.block.mechanicalfryer;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import createbicyclesbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import createbicyclesbitterballen.index.PartialsRegistry;
import net.minecraft.core.Direction;

public class FryerInstance
extends ShaftInstance<MechanicalFryerEntity>
implements DynamicInstance {
    private final RotatingData mixerHead;
    private final OrientedData mixerPole;
    private final MechanicalFryerEntity mixer;

    public FryerInstance(MaterialManager materialManager, MechanicalFryerEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.mixer = blockEntity;
        this.mixerHead = (RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(PartialsRegistry.MECHANICAL_FRYER_HEAD, this.blockState).createInstance();
        this.mixerHead.setRotationAxis(Direction.Axis.Y);
        this.mixerPole = (OrientedData)this.getOrientedMaterial().getModel(AllPartialModels.MECHANICAL_MIXER_POLE, this.blockState).createInstance();
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    public void beginFrame() {
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    private void transformHead(float renderedHeadOffset) {
        this.mixerHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private void transformPole(float renderedHeadOffset) {
        this.mixerPole.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset() {
        return this.mixer.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks());
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos.m_7495_(), new FlatLit[]{this.mixerHead});
        this.relight(this.pos, new FlatLit[]{this.mixerPole});
    }

    public void remove() {
        super.remove();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }
}

