/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyPotionBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class PotionTakeGoal
extends GoToPosGoal<StarbyPotionBehavior> {
    public PotionTakeGoal(Starbuncle starbuncle, StarbyPotionBehavior behavior) {
        super(starbuncle, behavior, () -> behavior.getHeldPotion().getPotion() == Potions.f_43598_);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    @Override
    public boolean m_8036_() {
        boolean superCan = super.m_8036_();
        if (!superCan) {
            return false;
        }
        if (((StarbyPotionBehavior)this.behavior).isBedPowered()) {
            this.starbuncle.setBackOff(20);
            this.starbuncle.addDebugEvent(new DebugEvent("BED_POWERED", "Cannot take potion, bed is powered"));
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public BlockPos getDestination() {
        return ((StarbyPotionBehavior)this.behavior).getJarForTake();
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyPotionBehavior)this.behavior).isPositionValidTake(pos);
    }

    @Override
    public boolean onDestinationReached() {
        BlockEntity blockEntity = this.starbuncle.f_19853_.m_7702_(this.targetPos);
        if (blockEntity instanceof PotionJarTile) {
            PotionJarTile jarTile = (PotionJarTile)blockEntity;
            BlockPos pos = ((StarbyPotionBehavior)this.behavior).getJarForStorage(jarTile.getData());
            if (pos == null) {
                return true;
            }
            BlockEntity blockEntity2 = this.starbuncle.f_19853_.m_7702_(pos);
            if (blockEntity2 instanceof PotionJarTile) {
                PotionJarTile destJar = (PotionJarTile)blockEntity2;
                int maxRoom = destJar.getMaxFill() - destJar.getAmount();
                if (maxRoom <= 0) {
                    return true;
                }
                ((StarbyPotionBehavior)this.behavior).setHeldPotion(jarTile.getData());
                int takeAmount = Math.min(jarTile.getAmount(), Math.min(maxRoom, 300));
                this.starbuncle.f_19853_.m_5594_(null, this.targetPos, SoundEvents.f_11781_, SoundSource.NEUTRAL, 0.5f, 1.3f);
                jarTile.remove(takeAmount);
                ((StarbyPotionBehavior)this.behavior).setAmount(takeAmount);
            }
        }
        return true;
    }
}

