/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.api.recipe.SummonRitualRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SummonRitualProvider
extends SimpleDataProvider {
    public List<SummonRitualRecipe> recipes = new ArrayList<SummonRitualRecipe>();

    public SummonRitualProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (SummonRitualRecipe recipe : this.recipes) {
            Path path = SummonRitualProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addEntries() {
        ArrayList<SummonRitualRecipe.WeightedMobType> bats = new ArrayList<SummonRitualRecipe.WeightedMobType>();
        bats.add(new SummonRitualRecipe.WeightedMobType(EntityType.m_20613_((EntityType)EntityType.f_20549_)));
        this.recipes.add(new SummonRitualRecipe(new ResourceLocation("", ""), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151049_}), SummonRitualRecipe.MobSource.MOB_LIST, 5, bats));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipes/summon_ritual/" + id + ".json");
    }

    public String m_6055_() {
        return "Summon Ritual Datagen";
    }
}

