/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WealdWalkerModel<W extends WealdWalker>
extends GeoModel<W> {
    String type;

    public WealdWalkerModel(String type) {
        this.type = type;
    }

    public void setCustomAnimations(W entity, long uniqueID, @Nullable AnimationState<W> customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * 0.010453292f);
        head.setRotY(extraData.netHeadYaw() * 0.015453292f);
        if (((Boolean)entity.m_20088_().m_135370_(WealdWalker.CASTING)).booleanValue()) {
            CoreGeoBone frontLeftLeg = this.getAnimationProcessor().getBone("leg_right");
            CoreGeoBone frontRightLeg = this.getAnimationProcessor().getBone("leg_left");
            frontLeftLeg.setRotX(Mth.m_14089_((float)(((WealdWalker)entity).f_267362_.m_267756_() * 0.6662f)) * 1.4f * ((WealdWalker)entity).f_267362_.m_267731_());
            frontRightLeg.setRotX(Mth.m_14089_((float)(((WealdWalker)entity).f_267362_.m_267756_() * 0.6662f + (float)Math.PI)) * 1.4f * ((WealdWalker)entity).f_267362_.m_267731_());
        }
    }

    public ResourceLocation getModelResource(WealdWalker walker) {
        return walker.m_6162_() ? new ResourceLocation("ars_nouveau", "geo/" + this.type + "_waddler.geo.json") : new ResourceLocation("ars_nouveau", "geo/" + this.type + "_walker.geo.json");
    }

    public ResourceLocation getTextureResource(WealdWalker walker) {
        return walker.m_6162_() ? new ResourceLocation("ars_nouveau", "textures/entity/" + this.type + "_waddler.png") : new ResourceLocation("ars_nouveau", "textures/entity/" + this.type + "_walker.png");
    }

    public ResourceLocation getAnimationResource(WealdWalker walker) {
        return walker.m_6162_() ? new ResourceLocation("ars_nouveau", "animations/weald_waddler_animations.json") : new ResourceLocation("ars_nouveau", "animations/weald_walker_animations.json");
    }
}

