/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.NotEnoughManaPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SpellResolver {
    public AbstractCastMethod castType;
    public Spell spell;
    public SpellContext spellContext;
    public boolean silent;
    private final ISpellValidator spellValidator;
    @Nullable
    public HitResult hitResult = null;

    public SpellResolver(SpellContext spellContext) {
        this.spell = spellContext.getSpell();
        this.castType = spellContext.getSpell().getCastMethod();
        this.spellContext = spellContext;
        this.spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();
    }

    public SpellResolver withSilent(boolean isSilent) {
        this.silent = isSilent;
        return this;
    }

    public boolean canCast(LivingEntity entity) {
        List<SpellValidationError> validationErrors = this.spellValidator.validate(this.spell.recipe);
        if (validationErrors.isEmpty()) {
            return this.enoughMana(entity);
        }
        if (!this.silent && !entity.m_20193_().f_46443_) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)validationErrors.get(0).makeTextComponentExisting());
        }
        return false;
    }

    boolean enoughMana(LivingEntity entity) {
        Player player;
        boolean canCast;
        int totalCost = this.getResolveCost();
        IManaCap manaCap = (IManaCap)CapabilityRegistry.getMana(entity).orElse(null);
        if (manaCap == null) {
            return false;
        }
        boolean bl = canCast = (double)totalCost <= manaCap.getCurrentMana() || entity instanceof Player && (player = (Player)entity).m_7500_();
        if (!(canCast || entity.m_20193_().f_46443_ || this.silent)) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.m_237115_((String)"ars_nouveau.spell.no_mana"));
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Networking.sendToPlayerClient(new NotEnoughManaPacket(totalCost), serverPlayer);
            }
        }
        return canCast;
    }

    public boolean postEvent() {
        return SpellUtil.postEvent(new SpellCastEvent(this.spell, this.spellContext));
    }

    private SpellStats getCastStats() {
        LivingEntity caster = this.spellContext.getUnwrappedCaster();
        return new SpellStats.Builder().setAugments(this.spell.getAugments(0, caster)).addItemsFromEntity(caster).build(this.castType, this.hitResult, caster.f_19853_, caster, this.spellContext);
    }

    public boolean onCast(ItemStack stack, Level level) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent()) {
            this.hitResult = null;
            CastResolveType resolveType = this.castType.onCast(stack, this.spellContext.getUnwrappedCaster(), level, this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public boolean onCastOnBlock(BlockHitResult blockRayTraceResult) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent()) {
            this.hitResult = blockRayTraceResult;
            CastResolveType resolveType = this.castType.onCastOnBlock(blockRayTraceResult, this.spellContext.getUnwrappedCaster(), this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public boolean onCastOnBlock(UseOnContext context) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent()) {
            this.hitResult = context.f_43705_;
            CastResolveType resolveType = this.castType.onCastOnBlock(context, this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public boolean onCastOnEntity(ItemStack stack, Entity target, InteractionHand hand) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent()) {
            this.hitResult = new EntityHitResult(target);
            CastResolveType resolveType = this.castType.onCastOnEntity(stack, this.spellContext.getUnwrappedCaster(), target, hand, this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public void onResolveEffect(Level world, HitResult result) {
        this.hitResult = result;
        this.resolveAllEffects(world);
    }

    protected void resolveAllEffects(Level world) {
        AbstractSpellPart part;
        ArrayList perkInstances;
        this.spellContext.resetCastCounter();
        LivingEntity shooter = this.spellContext.getUnwrappedCaster();
        SpellResolveEvent.Pre spellResolveEvent = new SpellResolveEvent.Pre(world, shooter, this.hitResult, this.spell, this.spellContext, this);
        MinecraftForge.EVENT_BUS.post((Event)spellResolveEvent);
        if (spellResolveEvent.isCanceled()) {
            return;
        }
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            v0 = PerkUtil.getPerksFromPlayer(player);
        } else {
            v0 = perkInstances = new ArrayList();
        }
        while (this.spellContext.hasNextPart() && (part = this.spellContext.nextPart()) != null) {
            IEffectResolvePerk effectPerk;
            IPerk iPerk;
            AbstractEffect effect;
            EffectResolveEvent.Pre preEvent;
            if (part instanceof AbstractAugment) continue;
            SpellStats.Builder builder = new SpellStats.Builder();
            List<AbstractAugment> augments = this.spell.getAugments(this.spellContext.getCurrentIndex() - 1, shooter);
            SpellStats stats = builder.setAugments(augments).addItemsFromEntity(shooter).build(part, this.hitResult, world, shooter, this.spellContext);
            if (!(part instanceof AbstractEffect) || MinecraftForge.EVENT_BUS.post((Event)(preEvent = new EffectResolveEvent.Pre(world, shooter, this.hitResult, this.spell, this.spellContext, effect = (AbstractEffect)part, stats, this)))) continue;
            for (PerkInstance perkInstance : perkInstances) {
                iPerk = perkInstance.getPerk();
                if (!(iPerk instanceof IEffectResolvePerk)) continue;
                effectPerk = (IEffectResolvePerk)((Object)iPerk);
                effectPerk.onPreResolve(this.hitResult, world, shooter, stats, this.spellContext, this, effect, perkInstance);
            }
            effect.onResolve(this.hitResult, world, shooter, stats, this.spellContext, this);
            for (PerkInstance perkInstance : perkInstances) {
                iPerk = perkInstance.getPerk();
                if (!(iPerk instanceof IEffectResolvePerk)) continue;
                effectPerk = (IEffectResolvePerk)((Object)iPerk);
                effectPerk.onPostResolve(this.hitResult, world, shooter, stats, this.spellContext, this, effect, perkInstance);
            }
            MinecraftForge.EVENT_BUS.post((Event)new EffectResolveEvent.Post(world, shooter, this.hitResult, this.spell, this.spellContext, effect, stats, this));
        }
        MinecraftForge.EVENT_BUS.post((Event)new SpellResolveEvent.Post(world, shooter, this.hitResult, this.spell, this.spellContext, this));
    }

    public void expendMana() {
        int totalCost = this.getResolveCost();
        CapabilityRegistry.getMana(this.spellContext.getUnwrappedCaster()).ifPresent(mana -> mana.removeMana(totalCost));
    }

    public int getResolveCost() {
        int cost = this.spellContext.getSpell().getCost() - ManaUtil.getPlayerDiscounts(this.spellContext.getUnwrappedCaster(), this.spell, this.spellContext.getCasterTool());
        SpellCostCalcEvent event = new SpellCostCalcEvent(this.spellContext, cost);
        MinecraftForge.EVENT_BUS.post((Event)event);
        cost = Math.max(0, event.currentCost);
        return cost;
    }

    public SpellResolver getNewResolver(SpellContext context) {
        return new SpellResolver(context);
    }

    public boolean hasFocus(ItemStack stack) {
        return CuriosUtil.hasItem(this.spellContext.getUnwrappedCaster(), stack);
    }
}

