/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau;

import com.hollingsworth.arsnouveau.api.registry.CasterTomeRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.DispenserRitualBehavior;
import com.hollingsworth.arsnouveau.client.container.CraftingTerminalScreen;
import com.hollingsworth.arsnouveau.client.registry.ClientHandler;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.ClientEventHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.FMLEventHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.Pathfinding;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.world.Terrablender;
import com.hollingsworth.arsnouveau.setup.ModSetup;
import com.hollingsworth.arsnouveau.setup.config.ANModConfig;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.proxy.ClientProxy;
import com.hollingsworth.arsnouveau.setup.proxy.IProxy;
import com.hollingsworth.arsnouveau.setup.proxy.ServerProxy;
import com.hollingsworth.arsnouveau.setup.registry.APIRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataSerializers;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.reward.Rewards;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ars_nouveau")
@Mod.EventBusSubscriber(modid="ars_nouveau")
public class ArsNouveau {
    public static final String MODID = "ars_nouveau";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static boolean caelusLoaded = false;
    public static boolean terrablenderLoaded = false;
    public static boolean optifineLoaded = false;
    public static boolean sodiumLoaded = false;
    public static boolean patchouliLoaded = false;

    public ArsNouveau() {
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(FMLEventHandler.class);
        caelusLoaded = ModList.get().isLoaded("caelus");
        terrablenderLoaded = ModList.get().isLoaded("terrablender");
        sodiumLoaded = ModList.get().isLoaded("rubidium");
        patchouliLoaded = ModList.get().isLoaded("patchouli");
        APIRegistry.setup();
        ANModConfig serverConfig = new ANModConfig(ModConfig.Type.SERVER, (IConfigSpec<?>)ServerConfig.SERVER_CONFIG, ModLoadingContext.get().getActiveContainer(), "ars_nouveau-server");
        ModLoadingContext.get().getActiveContainer().addConfig((ModConfig)serverConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(ClientEventHandler.class));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ModSetup::registerEvents);
        ModSetup.registers(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::postModLoadEvent);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ANCriteriaTriggers.init();
        try {
            Thread thread = new Thread(Rewards::init);
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        APIRegistry.postInit();
        Networking.registerMessages();
        event.enqueueWork(ModPotions::addRecipes);
        event.enqueueWork(ModEntities::registerPlacements);
        event.enqueueWork(DataSerializers::init);
        if (terrablenderLoaded && (Integer)Config.ARCHWOOD_FOREST_WEIGHT.get() > 0) {
            event.enqueueWork(Terrablender::registerBiomes);
        }
        MinecraftForge.EVENT_BUS.addListener(e -> CasterTomeRegistry.reloadTomeData(e.getServer().m_129894_(), (Level)e.getServer().m_129880_(Level.f_46428_)));
    }

    public void postModLoadEvent(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.BLAZING_SAPLING.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.CASCADING_SAPLING.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.FLOURISHING_SAPLING.m_5456_(), 0.5f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.VEXING_SAPLING.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.SOURCEBERRY_BUSH.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)((ItemLike)ItemsRegistry.MAGE_BLOOM.get()), 0.65f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.MAGE_BLOOM_CROP.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.BOMBEGRANTE_POD.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.MENDOSTEEN_POD.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.FROSTAYA_POD.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.BASTION_POD.m_5456_(), 0.65f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.FLOURISHING_LEAVES.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.VEXING_LEAVES.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.CASCADING_LEAVE.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.putIfAbsent((Object)BlockRegistry.BLAZING_LEAVES.m_5456_(), 0.3f);
            FlowerPotBlock flowerPot = (FlowerPotBlock)Blocks.f_50276_;
            for (Map.Entry<Supplier<ResourceLocation>, FlowerPotBlock> pot : BlockRegistry.flowerPots.entrySet()) {
                flowerPot.addPlant(pot.getKey().get(), pot::getValue);
            }
            for (RitualTablet tablet : RitualRegistry.getRitualItemMap().values()) {
                DispenserBlock.m_52672_((ItemLike)tablet, (DispenseItemBehavior)new DispenserRitualBehavior());
            }
        });
    }

    public void clientSetup(FMLClientSetupEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHandler::init);
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.STORAGE.get()), CraftingTerminalScreen::new));
        try {
            Class.forName("net.optifine.Config");
            optifineLoaded = true;
        }
        catch (Exception e) {
            optifineLoaded = false;
        }
    }

    public void sendImc(InterModEnqueueEvent evt) {
        ModSetup.sendIntercoms();
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppingEvent event) {
        Pathfinding.shutdown();
    }
}

