/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CasingCollisionUtils {
    private static final Map<TrackMaterial.TrackType, Map<TrackShape, Set<BlockPos>>> OFFSETS = new HashMap<TrackMaterial.TrackType, Map<TrackShape, Set<BlockPos>>>();

    @Contract(value="_ -> new")
    private static SuperBuilder b(@NotNull TrackMaterial.TrackType trackType) {
        return new SuperBuilder(trackType);
    }

    private static void registerStandard(TrackMaterial.TrackType trackType) {
        CasingCollisionUtils.b(trackType).s(TrackShape.XO).o(0, 1).o(0, -1).build().s(TrackShape.ZO).o(1, 0).o(-1, 0).build().s(TrackShape.PD).o(1, 0).o(1, -1).o(0, 1).o(-1, 1).build().s(TrackShape.ND).o(-1, 0).o(-1, -1).o(0, 1).o(1, 1).build().s(TrackShape.TE).o(0, 1).o(0, -1).build().s(TrackShape.TW).o(0, 1).o(0, -1).build().s(TrackShape.TN).o(1, 0).o(-1, 0).build().s(TrackShape.TS).o(1, 0).o(-1, 0).build().s(TrackShape.CR_O).o(-1, 1).o(0, 1).o(1, 1).o(-1, 0).o(1, 0).o(-1, -1).o(0, -1).o(1, -1).build().s(TrackShape.AE).o(0, 1).o(0, -1).build().s(TrackShape.AW).o(0, 1).o(0, -1).build().s(TrackShape.AN).o(1, 0).o(-1, 0).build().s(TrackShape.AS).o(1, 0).o(-1, 0).build();
    }

    private static void registerWide(TrackMaterial.TrackType trackType) {
        Builder cr_o = CasingCollisionUtils.b(trackType).s(TrackShape.XO).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.ZO).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.PD).o(1, 0).o(1, -1).o(2, -1).o(0, 1).o(-1, 1).o(-1, 2).build().s(TrackShape.ND).o(-1, 0).o(-1, -1).o(-2, -1).o(0, 1).o(1, 1).o(1, 2).build().s(TrackShape.TE).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.TW).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.TN).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.TS).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.AE).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.AW).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.AN).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.AS).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.CR_O);
        for (int xOff = -2; xOff <= 2; ++xOff) {
            for (int zOff = -2; zOff <= 2; ++zOff) {
                if (xOff == 0 && zOff == 0) continue;
                cr_o.o(xOff, zOff);
            }
        }
        cr_o.build();
    }

    public static void register() {
        OFFSETS.clear();
        CasingCollisionUtils.registerStandard(TrackMaterial.TrackType.STANDARD);
        CasingCollisionUtils.registerStandard(CRTrackMaterials.CRTrackType.NARROW_GAUGE);
        CasingCollisionUtils.registerWide(CRTrackMaterials.CRTrackType.WIDE_GAUGE);
    }

    public static boolean shouldMakeCollision(TrackBlockEntity be, BlockState state) {
        TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
        if (((IHasTrackCasing)be).isAlternate() || ((IHasTrackCasing)be).getTrackCasing() == null) {
            return false;
        }
        TrackMaterial.TrackType trackType = ((TrackBlock)state.m_60734_()).getMaterial().trackType;
        if (!OFFSETS.containsKey(trackType)) {
            return false;
        }
        Map<TrackShape, Set<BlockPos>> shapeMap = OFFSETS.get(trackType);
        return shapeMap.containsKey(shape);
    }

    public static void manageTracks(TrackBlockEntity be, boolean remove) {
        TrackShape shape = (TrackShape)be.m_58900_().m_61143_((Property)TrackBlock.SHAPE);
        TrackMaterial.TrackType trackType = ((TrackBlock)be.m_58900_().m_60734_()).getMaterial().trackType;
        if (!OFFSETS.containsKey(trackType)) {
            return;
        }
        Map<TrackShape, Set<BlockPos>> shapeMap = OFFSETS.get(trackType);
        if (!shapeMap.containsKey(shape)) {
            return;
        }
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        for (BlockPos offset : shapeMap.get(shape)) {
            BlockPos pos = be.m_58899_().m_121955_((Vec3i)offset);
            BlockState stateAtPos = level.m_8055_(pos);
            boolean present = CRBlocks.CASING_COLLISION.has(stateAtPos);
            if (remove) {
                if (!present) continue;
                level.m_7471_(pos, false);
                continue;
            }
            FluidState fluidState = stateAtPos.m_60819_();
            if (!fluidState.m_76178_() && !fluidState.m_164512_((Fluid)Fluids.f_76193_)) continue;
            if (!present && stateAtPos.m_247087_()) {
                level.m_7731_(pos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)CRBlocks.CASING_COLLISION.getDefaultState(), (BlockPos)pos), 3);
            }
            CasingCollisionBlock.keepAlive((LevelAccessor)level, pos);
        }
    }

    private static class SuperBuilder {
        private final TrackMaterial.TrackType trackType;

        private SuperBuilder(TrackMaterial.TrackType trackType) {
            this.trackType = trackType;
        }

        public Builder s(TrackShape shape) {
            return new Builder(this.trackType, shape).withSuperBuilder(this);
        }
    }

    private static class Builder {
        private final Set<BlockPos> offsets = new HashSet<BlockPos>();
        private final TrackMaterial.TrackType trackType;
        private final TrackShape shape;
        private SuperBuilder superBuilder;

        private Builder(TrackMaterial.TrackType trackType, TrackShape shape) {
            this.trackType = trackType;
            this.shape = shape;
        }

        public SuperBuilder build() {
            if (!OFFSETS.containsKey(this.trackType)) {
                OFFSETS.put(this.trackType, new HashMap());
            }
            OFFSETS.get(this.trackType).put(this.shape, this.offsets);
            if (this.superBuilder == null) {
                return new SuperBuilder(this.trackType);
            }
            return this.superBuilder;
        }

        public Builder o(int x, int y, int z) {
            this.offsets.add(new BlockPos(x, y, z));
            return this;
        }

        public Builder o(int x, int z) {
            return this.o(x, 0, z);
        }

        public Builder withSuperBuilder(SuperBuilder superBuilder) {
            this.superBuilder = superBuilder;
            return this;
        }
    }
}

