/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.journeymap;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.journeymap.DummyRailwayMarkerHandler;
import com.railwayteam.railways.compat.journeymap.IRailwayMarkerHandler;
import com.railwayteam.railways.compat.journeymap.TrainMarkerData;
import com.railwayteam.railways.compat.journeymap.UsernameUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.TextProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class RailwayMarkerHandler
implements IRailwayMarkerHandler {
    private static final MapImage TRAIN_IMAGE = new MapImage(Railways.asResource("textures/gui/journeymap_train.png"), 60, 60).setDisplayWidth(27.0).setDisplayHeight(27.0).centerAnchors();
    private IClientAPI jmAPI;
    private HashMap<UUID, MarkerOverlay> markers;
    private HashMap<UUID, TrainMarkerData> trainData;
    private Set<UUID> needingUpdates;
    private ResourceKey<Level> currentDimension;
    private ResourceKey<Level> lastDimension;
    private boolean reload = false;
    private boolean enabled = true;

    private RailwayMarkerHandler(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        this.markers = new HashMap();
        this.trainData = new HashMap();
        this.needingUpdates = new HashSet<UUID>();
        this.lastDimension = null;
    }

    public static void init(IClientAPI jmAPI) {
        DummyRailwayMarkerHandler.instance = new RailwayMarkerHandler(jmAPI);
    }

    @Override
    public void enable() {
        this.enabled = true;
        this.reload = true;
        this.runUpdates();
    }

    @Override
    public void disable() {
        this.enabled = false;
        this.markers.forEach((u, overlay) -> this.jmAPI.remove((Displayable)overlay));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void removeTrain(UUID uuid) {
        if (this.markers.containsKey(uuid)) {
            this.jmAPI.remove((Displayable)this.markers.get(uuid));
            this.markers.remove(uuid);
        }
        this.trainData.remove(uuid);
    }

    @Override
    public void removeObsolete() {
        for (UUID uuid : this.markers.keySet().stream().toList()) {
            if (this.trainData.containsKey(uuid)) continue;
            this.removeTrain(uuid);
        }
    }

    private void addOrUpdateTrain(UUID uuid) {
        MarkerOverlay marker;
        TrainMarkerData data = this.trainData.get(uuid);
        ResourceKey<Level> dimension = data.dimension();
        BlockPos blockPos = data.pos();
        if (this.currentDimension != dimension && this.currentDimension != null) {
            if (this.currentDimension != this.lastDimension && this.markers.containsKey(uuid)) {
                this.jmAPI.remove((Displayable)this.markers.get(uuid));
            }
            return;
        }
        if (this.markers.containsKey(uuid)) {
            marker = this.markers.get(uuid);
            marker.setDimension(dimension);
            marker.setPoint(blockPos);
        } else {
            marker = new MarkerOverlay("railways", "train_marker_" + uuid.toString(), blockPos, TRAIN_IMAGE);
            marker.setDimension(dimension);
            this.markers.put(uuid, marker);
            try {
                this.jmAPI.show((Displayable)marker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        marker.setTextProperties(new TextProperties().setOffsetY(25).setOffsetX(1).setColor(16759619));
        marker.setLabel(data.name());
        Object info = "";
        info = (String)info + data.name();
        info = (String)info + "\n > Carriage count: " + data.carriageCount();
        info = (String)info + "\n > Owner: " + UsernameUtils.INSTANCE.getName(data.owner());
        marker.setTitle((String)info);
        marker.flagForRerender();
        if (this.currentDimension != this.lastDimension || this.reload) {
            try {
                this.jmAPI.show((Displayable)marker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void runUpdates() {
        if (!this.enabled) {
            return;
        }
        this.currentDimension = Minecraft.m_91087_().f_91073_ == null ? null : Minecraft.m_91087_().f_91073_.m_46472_();
        boolean forceUpdate = this.reload || this.currentDimension != this.lastDimension;
        for (UUID uuid : forceUpdate ? this.trainData.keySet() : this.needingUpdates) {
            if (!this.trainData.containsKey(uuid)) continue;
            this.addOrUpdateTrain(uuid);
        }
        this.needingUpdates.clear();
        this.lastDimension = Minecraft.m_91087_().f_91073_ == null ? null : Minecraft.m_91087_().f_91073_.m_46472_();
        this.reload = false;
    }

    @Override
    public void registerData(UUID uuid, TrainMarkerData data) {
        this.trainData.put(uuid, data);
        this.needingUpdates.add(uuid);
    }

    @Override
    public void reloadMarkers() {
        this.reload = true;
        this.trainData.clear();
        this.removeObsolete();
    }

    @Override
    public void onJoinWorld() {
        this.reload = true;
        this.trainData.clear();
        this.needingUpdates.clear();
        this.removeObsolete();
    }
}

