/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidStackWidget
extends AbstractWidget {
    private final Screen displayOn;
    private final Supplier<FluidTank> getFluid;
    private final String toolTipTitle;

    public FluidStackWidget(Screen displayOn, Supplier<FluidTank> getFluid, int pX, int pY, int pWidth, int pHeight, String toolTipTitle) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        this.displayOn = displayOn;
        this.getFluid = getFluid;
        this.toolTipTitle = toolTipTitle;
    }

    public void m_87963_(@NotNull GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTicks) {
        AbstractTexture texture;
        FluidStack fluidStack;
        IClientFluidTypeExtensions props;
        ResourceLocation still;
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        FluidTank fluidTank = this.getFluid.get();
        if (!fluidTank.isEmpty() && (still = (props = IClientFluidTypeExtensions.of((Fluid)(fluidStack = fluidTank.getFluid()).getFluid())).getStillTexture(fluidStack)) != null && (texture = minecraft.m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas) {
            TextureAtlas atlas = (TextureAtlas)texture;
            TextureAtlasSprite sprite = atlas.m_118316_(still);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            int color = props.getTintColor();
            RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13655_((int)color) / 255.0f));
            RenderSystem.enableBlend();
            int stored = fluidTank.getFluidAmount();
            float capacity = fluidTank.getCapacity();
            float filledVolume = (float)stored / capacity;
            int renderableHeight = (int)(filledVolume * (float)this.f_93619_);
            int atlasWidth = (int)((float)sprite.m_174744_() / (sprite.m_118410_() - sprite.m_118409_()));
            int atlasHeight = (int)((float)sprite.m_174744_() / (sprite.m_118412_() - sprite.m_118411_()));
            pPoseStack.m_280168_().m_85836_();
            pPoseStack.m_280168_().m_252880_(0.0f, (float)(this.f_93619_ - 16), 0.0f);
            int i = 0;
            while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                int notDrawingHeight = 16 - drawingHeight;
                pPoseStack.m_280398_(TextureAtlas.f_118259_, this.m_252754_(), this.m_252907_() + notDrawingHeight, 0, sprite.m_118409_() * (float)atlasWidth, sprite.m_118411_() * (float)atlasHeight + (float)notDrawingHeight, this.f_93618_, drawingHeight, atlasWidth, atlasHeight);
                pPoseStack.m_280168_().m_252880_(0.0f, -16.0f, 0.0f);
                ++i;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pPoseStack.m_280168_().m_85849_();
        }
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }
}

