/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BackpackDynamicModel
implements IUnbakedGeometry<BackpackDynamicModel> {
    private final Map<ModelPart, UnbakedModel> modelParts;

    public BackpackDynamicModel(Map<ModelPart, UnbakedModel> modelParts) {
        this.modelParts = modelParts;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelParts.forEach((part, model) -> {
            BakedModel bakedModel = model.m_7611_(baker, spriteGetter, modelTransform, modelLocation);
            if (bakedModel != null) {
                builder.put((Object)part, (Object)bakedModel);
            }
        });
        return new BackpackBakedModel((Map<ModelPart, BakedModel>)builder.build(), modelTransform);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.modelParts.values().forEach(model -> model.m_5500_(modelGetter));
    }

    private static final class BackpackBakedModel
    implements IDynamicBakedModel {
        public static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final ItemTransforms ITEM_TRANSFORMS = BackpackBakedModel.createItemTransforms();
        private static final ResourceLocation BACKPACK_MODULES_TEXTURE = new ResourceLocation("sophisticatedbackpacks:block/backpack_modules");
        private final BackpackItemOverrideList overrideList = new BackpackItemOverrideList(this);
        private final Map<ModelPart, BakedModel> models;
        private final ModelState modelTransform;
        private boolean tankLeft;
        @Nullable
        private IRenderedTankUpgrade.TankRenderInfo leftTankRenderInfo = null;
        private boolean tankRight;
        @Nullable
        private IRenderedTankUpgrade.TankRenderInfo rightTankRenderInfo = null;
        private boolean battery;
        @Nullable
        private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
        }

        private static ItemTransforms createItemTransforms() {
            return new ItemTransforms(new ItemTransform(new Vector3f(85.0f, -90.0f, 0.0f), new Vector3f(0.0f, -0.125f, -0.28125f), new Vector3f(0.75f, 0.75f, 0.75f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(85.0f, -90.0f, 0.0f), new Vector3f(0.0f, -0.125f, -0.28125f), new Vector3f(0.75f, 0.75f, 0.75f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.890625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.078125f, 0.0f), new Vector3f(0.9f, 0.9f, 0.9f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -0.140625f), new Vector3f(0.75f, 0.75f, 0.75f), DEFAULT_ROTATION), ImmutableMap.of());
        }

        public BackpackBakedModel(Map<ModelPart, BakedModel> models, ModelState modelTransform) {
            this.models = models;
            this.modelTransform = modelTransform;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(this.models.get((Object)ModelPart.BASE).getQuads(state, side, rand, extraData, renderType));
            if (state == null) {
                this.addLeftSide(state, side, rand, extraData, ret, this.tankLeft, renderType);
                this.addRightSide(state, side, rand, extraData, ret, this.tankRight, renderType);
                this.addFront(state, side, rand, extraData, ret, this.battery, renderType);
            } else {
                this.addLeftSide(state, side, rand, extraData, ret, (Boolean)state.m_61143_((Property)BackpackBlock.LEFT_TANK), renderType);
                this.addRightSide(state, side, rand, extraData, ret, (Boolean)state.m_61143_((Property)BackpackBlock.RIGHT_TANK), renderType);
                this.addFront(state, side, rand, extraData, ret, (Boolean)state.m_61143_((Property)BackpackBlock.BATTERY), renderType);
            }
            return ret;
        }

        private void addFront(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, List<BakedQuad> ret, boolean battery, @Nullable RenderType renderType) {
            if (battery) {
                if (this.batteryRenderInfo != null) {
                    this.addCharge(ret, this.batteryRenderInfo.getChargeRatio());
                }
                ret.addAll(this.models.get((Object)ModelPart.BATTERY).getQuads(state, side, rand, extraData, renderType));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.FRONT_POUCH).getQuads(state, side, rand, extraData, renderType));
            }
        }

        private void addCharge(List<BakedQuad> ret, float chargeRatio) {
            if (Mth.m_14033_((float)chargeRatio, (float)0.0f)) {
                return;
            }
            int pixels = (int)(chargeRatio * 4.0f);
            float minX = (float)(10 - pixels) / 16.0f;
            float minY = 0.125f;
            float minZ = 0.121875f;
            float maxX = minX + (float)pixels / 16.0f;
            float maxY = minY + 0.0625f;
            float[] cols = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(BACKPACK_MODULES_TEXTURE);
            ret.add(this.createQuad(List.of(this.getVector(maxX, maxY, minZ), this.getVector(maxX, minY, minZ), this.getVector(minX, minY, minZ), this.getVector(minX, maxY, minZ)), cols, sprite, Direction.NORTH, 14.0f, 14.0f + (float)pixels / 2.0f, 6.0f, 6.5f));
        }

        private void addRightSide(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, List<BakedQuad> ret, boolean tankRight, @Nullable RenderType renderType) {
            if (tankRight) {
                if (this.rightTankRenderInfo != null) {
                    this.rightTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(ret, (FluidStack)fluid, this.rightTankRenderInfo.getFillRatio(), 0.0375));
                }
                ret.addAll(this.models.get((Object)ModelPart.RIGHT_TANK).getQuads(state, side, rand, extraData, renderType));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.RIGHT_POUCH).getQuads(state, side, rand, extraData, renderType));
            }
        }

        private void addLeftSide(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, List<BakedQuad> ret, boolean tankLeft, @Nullable RenderType renderType) {
            if (tankLeft) {
                if (this.leftTankRenderInfo != null) {
                    this.leftTankRenderInfo.getFluid().ifPresent(fluid -> this.addFluid(ret, (FluidStack)fluid, this.leftTankRenderInfo.getFillRatio(), 0.803125));
                }
                ret.addAll(this.models.get((Object)ModelPart.LEFT_TANK).getQuads(state, side, rand, extraData, renderType));
            } else {
                ret.addAll(this.models.get((Object)ModelPart.LEFT_POUCH).getQuads(state, side, rand, extraData, renderType));
            }
        }

        private void addFluid(List<BakedQuad> ret, FluidStack fluidStack, float ratio, double xMin) {
            if (Mth.m_14033_((float)ratio, (float)0.0f)) {
                return;
            }
            double yMin = 0.09375;
            double yMax = yMin + (double)(ratio * 6.0f) / 16.0;
            AABB bounds = new AABB(xMin, yMin, 0.421875, xMin + 0.15625, yMax, 0.578125);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation texture = renderProperties.getStillTexture(fluidStack);
            int color = renderProperties.getTintColor(fluidStack);
            float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
            float bx1 = 0.0f;
            float bx2 = 5.0f;
            float by1 = 0.0f;
            float by2 = ratio * 10.0f;
            float bz1 = 0.0f;
            float bz2 = 5.0f;
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_)), cols, still, Direction.UP, bx1, bx2, bz1, bz2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_)), cols, still, Direction.NORTH, bx1, bx2, by1, by2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_)), cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_)), cols, still, Direction.WEST, bz1, bz2, by1, by2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), this.getVector(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), this.getVector(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_)), cols, still, Direction.EAST, bz1, bz2, by1, by2));
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelTransform.m_6189_().m_252783_());
            return ret;
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return true;
        }

        public TextureAtlasSprite m_6160_() {
            return this.models.get((Object)ModelPart.BASE).m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.overrideList;
        }

        public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            if (transformType == ItemDisplayContext.NONE) {
                return this;
            }
            ITEM_TRANSFORMS.m_269404_(transformType).m_111763_(applyLeftHandTransform, poseStack);
            return this;
        }

        public ItemTransforms m_7442_() {
            return ITEM_TRANSFORMS;
        }

        private BakedQuad createQuad(List<Vector3f> vecs, float[] colors, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
            BakedQuad[] bakedQuad = new BakedQuad[1];
            QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer(q -> {
                bakedQuad[0] = q;
            });
            quadBaker.setSprite(sprite);
            Vec3i dirVec = face.m_122436_();
            quadBaker.setDirection(face);
            quadBaker.setTintIndex(-1);
            u1 = sprite.m_118409_() + u1 / 4.0f * sprite.m_118417_();
            u2 = sprite.m_118409_() + u2 / 4.0f * sprite.m_118417_();
            v1 = sprite.m_118411_() + v1 / 4.0f * sprite.m_118417_();
            v2 = sprite.m_118411_() + v2 / 4.0f * sprite.m_118417_();
            quadBaker.m_5483_((double)vecs.get(0).x(), (double)vecs.get(0).y(), (double)vecs.get(0).z()).m_85950_(colors[1], colors[2], colors[3], colors[0]).m_7421_(u1, v1).m_5601_((float)dirVec.m_123341_(), (float)dirVec.m_123342_(), (float)dirVec.m_123343_()).m_5752_();
            quadBaker.m_5483_((double)vecs.get(1).x(), (double)vecs.get(1).y(), (double)vecs.get(1).z()).m_85950_(colors[1], colors[2], colors[3], colors[0]).m_7421_(u1, v2).m_5601_((float)dirVec.m_123341_(), (float)dirVec.m_123342_(), (float)dirVec.m_123343_()).m_5752_();
            quadBaker.m_5483_((double)vecs.get(2).x(), (double)vecs.get(2).y(), (double)vecs.get(2).z()).m_85950_(colors[1], colors[2], colors[3], colors[0]).m_7421_(u2, v2).m_5601_((float)dirVec.m_123341_(), (float)dirVec.m_123342_(), (float)dirVec.m_123343_()).m_5752_();
            quadBaker.m_5483_((double)vecs.get(3).x(), (double)vecs.get(3).y(), (double)vecs.get(3).z()).m_85950_(colors[1], colors[2], colors[3], colors[0]).m_7421_(u2, v1).m_5601_((float)dirVec.m_123341_(), (float)dirVec.m_123342_(), (float)dirVec.m_123343_()).m_5752_();
            return bakedQuad[0];
        }

        private void rotate(Vector3f posIn, Matrix4f transform) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0f));
            posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
        }
    }

    private static enum ModelPart {
        BASE,
        BATTERY,
        FRONT_POUCH,
        LEFT_POUCH,
        LEFT_TANK,
        RIGHT_POUCH,
        RIGHT_TANK;

    }

    public static final class Loader
    implements IGeometryLoader<BackpackDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public BackpackDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ResourceLocation clipsTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder texturesBuilder = ImmutableMap.builder();
            if (modelContents.has("clipsTexture") && (clipsTexture = ResourceLocation.m_135820_((String)modelContents.get("clipsTexture").getAsString())) != null) {
                texturesBuilder.put((Object)"clips", (Object)Either.left((Object)new Material(InventoryMenu.f_39692_, clipsTexture)));
            }
            ImmutableMap textures = texturesBuilder.build();
            for (ModelPart part : ModelPart.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelPart, UnbakedModel>)builder, part, (ImmutableMap<String, Either<Material, String>>)textures);
            }
            return new BackpackDynamicModel((Map<ModelPart, UnbakedModel>)builder.build());
        }

        private void addPartModel(ImmutableMap.Builder<ModelPart, UnbakedModel> builder, ModelPart modelPart, ImmutableMap<String, Either<Material, String>> textures) {
            builder.put((Object)modelPart, (Object)new BlockModel(SophisticatedBackpacks.getRL("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH)), Collections.emptyList(), textures, Boolean.valueOf(true), null, ItemTransforms.f_111786_, Collections.emptyList()));
        }
    }

    private static class BackpackItemOverrideList
    extends ItemOverrides {
        private final BackpackBakedModel backpackModel;

        public BackpackItemOverrideList(BackpackBakedModel backpackModel) {
            this.backpackModel = backpackModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int seed) {
            this.backpackModel.tankRight = false;
            this.backpackModel.tankLeft = false;
            this.backpackModel.battery = false;
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
                RenderInfo renderInfo = backpackWrapper.getRenderInfo();
                Map tankRenderInfos = renderInfo.getTankRenderInfos();
                tankRenderInfos.forEach((pos, info) -> {
                    if (pos == TankPosition.LEFT) {
                        this.backpackModel.tankLeft = true;
                        this.backpackModel.leftTankRenderInfo = info;
                    } else {
                        this.backpackModel.tankRight = true;
                        this.backpackModel.rightTankRenderInfo = info;
                    }
                });
                renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                    this.backpackModel.battery = true;
                    this.backpackModel.batteryRenderInfo = batteryRenderInfo;
                });
            });
            return this.backpackModel;
        }
    }
}

