/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.thirst;

import dev.ghen.thirst.Thirst;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.content.thirst.DrinkByHandClient;
import dev.ghen.thirst.content.thirst.PlayerThirst;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModCapabilities;
import dev.ghen.thirst.foundation.config.CommonConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerThirstManager {
    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            final PlayerThirst playerThirstCap = new PlayerThirst();
            final LazyOptional capOptional = LazyOptional.of(() -> playerThirstCap);
            final Capability<IThirst> capability = ModCapabilities.PLAYER_THIRST;
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return playerThirstCap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    playerThirstCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(Thirst.asResource("thirst"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void drinkByHand(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)CommonConfig.CAN_DRINK_BY_HAND.get()).booleanValue() && event.getEntity().m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DrinkByHandClient::drinkByHand);
        }
    }

    @SubscribeEvent
    public static void drinkByHand(PlayerInteractEvent.RightClickEmpty event) {
        if (((Boolean)CommonConfig.CAN_DRINK_BY_HAND.get()).booleanValue() && event.getEntity().m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DrinkByHandClient::drinkByHand);
        }
    }

    @SubscribeEvent
    public static void drink(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof Player && ThirstHelper.itemRestoresThirst(event.getItem())) {
            event.getEntity().getCapability(ModCapabilities.PLAYER_THIRST).ifPresent(cap -> {
                ItemStack item = event.getItem();
                if (WaterPurity.givePurityEffects((Player)event.getEntity(), item)) {
                    cap.drink((Player)event.getEntity(), ThirstHelper.getThirst(item), ThirstHelper.getQuenched(item));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(ModCapabilities.PLAYER_THIRST).ifPresent(cap -> cap.tick((Player)serverPlayer));
        }
    }

    @SubscribeEvent
    public static void endFix(PlayerEvent.Clone event) {
        if (!event.isWasDeath() && !event.getEntity().m_9236_().f_46443_) {
            Player oldPlayer = event.getOriginal();
            oldPlayer.reviveCaps();
            event.getEntity().getCapability(ModCapabilities.PLAYER_THIRST).ifPresent(cap -> oldPlayer.getCapability(ModCapabilities.PLAYER_THIRST).ifPresent(cap::copy));
            oldPlayer.invalidateCaps();
        }
    }
}

