/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.api;

import com.momosoftworks.coldsweat.api.util.Temperature;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.config.ItemSettingsConfig;
import dev.ghen.thirst.foundation.config.KeyWordConfig;
import dev.ghen.thirst.foundation.util.ConfigHelper;
import dev.ghen.thirst.foundation.util.LoadedValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class ThirstHelper {
    private static boolean useColdSweatCaps = false;
    private static final float MODIFIER_HARSHNESS = 0.5f;
    public static Map<Item, Number[]> VALID_DRINKS = LoadedValue.of(() -> ConfigHelper.getItemsWithValues((List)ItemSettingsConfig.DRINKS.get())).get();
    public static Map<Item, Number[]> VALID_FOODS = LoadedValue.of(() -> ConfigHelper.getItemsWithValues((List)ItemSettingsConfig.FOODS.get())).get();
    public static String keywordBlackList = (String)KeyWordConfig.KEYWORD_BLACKLIST.get();
    public static String keywordDrink = (String)KeyWordConfig.KEYWORD_DRINK.get();
    public static String keywordSoup = (String)KeyWordConfig.KEYWORD_SOUP.get();
    public static String keywordFruit = (String)KeyWordConfig.KEYWORD_FRUIT.get();

    public static boolean itemRestoresThirst(ItemStack itemStack) {
        return ThirstHelper.isDrink(itemStack) || ThirstHelper.isFood(itemStack) || ThirstHelper.checkKeywords(itemStack);
    }

    public static boolean isDrink(ItemStack itemStack) {
        return !((List)ItemSettingsConfig.ITEMS_BLACKLIST.get()).contains(itemStack.m_41720_().toString()) && VALID_DRINKS.containsKey(itemStack.m_41720_());
    }

    public static boolean isFood(ItemStack itemStack) {
        return !((List)ItemSettingsConfig.ITEMS_BLACKLIST.get()).contains(itemStack.m_41720_().toString()) && VALID_FOODS.containsKey(itemStack.m_41720_());
    }

    public static void addFood(Item item, int thirst, int quenched) {
        VALID_FOODS.put(item, new Number[]{thirst, quenched});
    }

    public static void addDrink(Item item, int thirst, int quenched) {
        VALID_DRINKS.put(item, new Number[]{thirst, quenched});
    }

    public static int getThirst(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (VALID_DRINKS.containsKey(item)) {
            if (!((Boolean)CommonConfig.ENABLE_DRINKS_NUTRITION.get()).booleanValue() && item.m_41473_() != null) {
                Objects.requireNonNull(item.m_41473_()).f_38723_ = 0;
            }
            return VALID_DRINKS.get(item)[0].intValue();
        }
        return VALID_FOODS.get(item)[0].intValue();
    }

    public static int getQuenched(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (VALID_DRINKS.containsKey(item)) {
            return VALID_DRINKS.get(item)[1].intValue();
        }
        return VALID_FOODS.get(item)[1].intValue();
    }

    public static int getPurity(ItemStack item) {
        if (!WaterPurity.hasPurity(item)) {
            return -1;
        }
        assert (item.m_41783_() != null);
        return item.m_41783_().m_128451_("Purity");
    }

    public static void shouldUseColdSweatCaps(boolean should) {
        useColdSweatCaps = should;
    }

    public static float getExhaustionFireProtModifier(Player player) {
        float perLevelMultiplier = 0.0625f;
        int totalLevels = EnchantmentHelper.m_44856_((Iterable)player.m_6168_(), (DamageSource)player.m_269291_().m_269549_()) / 2;
        return 1.0f - (float)totalLevels * 0.0625f * 0.75f;
    }

    public static float getExhaustionBiomeModifier(Player player) {
        BlockPos pos = player.m_20097_();
        Level level = player.m_9236_();
        if (level.m_6042_().f_63857_()) {
            return 3.0f;
        }
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        float humidity = biome.getModifiedClimateSettings().f_47683_() + 0.6f;
        if ((double)humidity <= 0.6) {
            humidity = (float)((double)humidity + 0.5);
        }
        float temp = biome.m_47554_() + 0.2f;
        if (useColdSweatCaps) {
            temp = (float)(Temperature.get((LivingEntity)player, (Temperature.Type)Temperature.Type.BODY) / 100.0);
        } else if (temp <= 0.0f) {
            temp = (float)Math.exp(temp);
        } else if (temp > 1.0f) {
            temp /= 2.0f;
        }
        float thirstModifier = ((Number)CommonConfig.THIRST_DEPLETION_MODIFIER.get()).floatValue() * (temp / humidity);
        if (thirstModifier < 1.0f) {
            float modifierOffset = 1.0f - thirstModifier;
            thirstModifier = 1.0f - (modifierOffset *= 0.5f);
        }
        return thirstModifier;
    }

    private static boolean checkKeywords(ItemStack itemStack) {
        if (!((Boolean)KeyWordConfig.ENABLE_KEYWORD_CONFIG.get()).booleanValue()) {
            return false;
        }
        if (!itemStack.m_41614_()) {
            return false;
        }
        String pattern = keywordBlackList;
        Matcher matcher = Pattern.compile(pattern, 2).matcher(itemStack.m_41778_());
        if (matcher.find()) {
            return false;
        }
        pattern = keywordDrink;
        matcher = Pattern.compile(pattern, 2).matcher(itemStack.m_41778_());
        boolean hasWater = matcher.find();
        if (hasWater) {
            VALID_DRINKS.put(itemStack.m_41720_(), new Number[]{KeyWordConfig.getDrinkHydration(), KeyWordConfig.getDrinkQuenchness()});
            return true;
        }
        pattern = keywordSoup;
        matcher = Pattern.compile(pattern, 2).matcher(itemStack.m_41778_());
        hasWater = matcher.find();
        if (hasWater) {
            VALID_FOODS.put(itemStack.m_41720_(), new Number[]{KeyWordConfig.getSoupHydration(), KeyWordConfig.getSoupQuenchness()});
            return true;
        }
        pattern = keywordFruit;
        matcher = Pattern.compile(pattern, 2).matcher(itemStack.m_41778_());
        hasWater = matcher.find();
        if (hasWater) {
            VALID_FOODS.put(itemStack.m_41720_(), new Number[]{KeyWordConfig.getFruitHydration(), KeyWordConfig.getFruitQuenchness()});
        }
        return hasWater;
    }
}

