/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCache;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCacheEditor;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCacheEntry;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.BatchRefUpdate;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.CommitBuilder;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.FileMode;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectInserter;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectLoader;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectReader;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectStream;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.PersonIdent;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Ref;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.RefUpdate;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevCommit;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevWalk;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.PushCertificate;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.PushCertificateParser;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.ReceiveCommand;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.PathFilter;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PushCertificateStore
implements AutoCloseable {
    static final String REF_NAME = "refs/meta/push-certs";
    private final Repository db;
    private final List<PendingCert> pending;
    ObjectReader reader;
    RevCommit commit;

    public PushCertificateStore(Repository db) {
        this.db = db;
        this.pending = new ArrayList<PendingCert>();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.commit = null;
        }
    }

    public PushCertificate get(String refName) throws IOException {
        if (this.reader == null) {
            this.load();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (TreeWalk tw = this.newTreeWalk(refName);){
            return PushCertificateStore.read(tw);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Iterable<PushCertificate> getAll(String refName) {
        return () -> new Iterator<PushCertificate>(refName){
            private final String path;
            private PushCertificate next;
            private RevWalk rw;
            {
                this.path = PushCertificateStore.pathName(string);
                try {
                    if (PushCertificateStore.this.reader == null) {
                        PushCertificateStore.this.load();
                    }
                    if (PushCertificateStore.this.commit != null) {
                        this.rw = new RevWalk(PushCertificateStore.this.reader);
                        this.rw.setTreeFilter(AndTreeFilter.create(PathFilterGroup.create(Collections.singleton(PathFilter.create(this.path))), TreeFilter.ANY_DIFF));
                        this.rw.setRewriteParents(false);
                        this.rw.markStart(this.rw.parseCommit(PushCertificateStore.this.commit));
                    } else {
                        this.rw = null;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    block19: {
                        if (this.next == null) {
                            if (this.rw == null) {
                                return false;
                            }
                            try {
                                RevCommit c = this.rw.next();
                                if (c != null) {
                                    Throwable throwable = null;
                                    Object var3_5 = null;
                                    try (TreeWalk tw = TreeWalk.forPath(this.rw.getObjectReader(), this.path, c.getTree());){
                                        this.next = PushCertificateStore.read(tw);
                                        break block19;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                this.next = null;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    boolean bl = this.next != null;
                    return bl;
                }
                finally {
                    if (this.next == null && this.rw != null) {
                        this.rw.close();
                        this.rw = null;
                    }
                }
            }

            @Override
            public PushCertificate next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PushCertificate n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void load() throws IOException {
        this.close();
        this.reader = this.db.newObjectReader();
        Ref ref = this.db.getRefDatabase().exactRef(REF_NAME);
        if (ref == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk rw = new RevWalk(this.reader);){
            this.commit = rw.parseCommit(ref.getObjectId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    static PushCertificate read(TreeWalk tw) throws IOException {
        if (tw == null || (tw.getRawMode(0) & 0x8000) != 32768) {
            return null;
        }
        ObjectLoader loader = tw.getObjectReader().open(tw.getObjectId(0), 3);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PushCertificate pushCertificate;
            BufferedReader r;
            ObjectStream in;
            block17: {
                block16: {
                    in = loader.openStream();
                    r = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
                    pushCertificate = PushCertificateParser.fromReader(r);
                    if (r == null) break block16;
                    ((Reader)r).close();
                }
                if (in == null) break block17;
                in.close();
            }
            return pushCertificate;
            {
                catch (Throwable throwable2) {
                    try {
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void put(PushCertificate cert, PersonIdent ident) {
        this.put(cert, ident, null);
    }

    public void put(PushCertificate cert, PersonIdent ident, Collection<ReceiveCommand> matching) {
        this.pending.add(new PendingCert(cert, ident, matching));
    }

    public RefUpdate.Result save() throws IOException {
        ObjectId newId = this.write();
        if (newId == null) {
            return RefUpdate.Result.NO_CHANGE;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            ObjectInserter inserter = this.db.newObjectInserter();
            try {
                RefUpdate.Result result = this.updateRef(newId);
                switch (result) {
                    case NO_CHANGE: 
                    case NEW: 
                    case FAST_FORWARD: {
                        this.pending.clear();
                        break;
                    }
                }
                RefUpdate.Result result2 = result;
                if (inserter != null) {
                    inserter.close();
                }
                return result2;
            }
            catch (Throwable throwable2) {
                try {
                    if (inserter != null) {
                        inserter.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            this.close();
        }
    }

    public boolean save(BatchRefUpdate batch) throws IOException {
        ObjectId newId = this.write();
        if (newId == null || newId.equals(this.commit)) {
            return false;
        }
        batch.addCommand(new ReceiveCommand(this.commit != null ? this.commit : ObjectId.zeroId(), newId, REF_NAME));
        return true;
    }

    public void clear() {
        this.pending.clear();
    }

    private ObjectId write() throws IOException {
        if (this.pending.isEmpty()) {
            return null;
        }
        if (this.reader == null) {
            this.load();
        }
        PushCertificateStore.sortPending(this.pending);
        ObjectId curr = this.commit;
        DirCache dc = this.newDirCache();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectInserter inserter = this.db.newObjectInserter();){
            for (PendingCert pc : this.pending) {
                curr = this.saveCert(inserter, dc, pc, curr);
            }
            inserter.flush();
            return curr;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void sortPending(List<PendingCert> pending) {
        Collections.sort(pending, (a, b) -> Long.signum(a.ident.getWhen().getTime() - b.ident.getWhen().getTime()));
    }

    private DirCache newDirCache() throws IOException {
        if (this.commit != null) {
            return DirCache.read(this.reader, this.commit.getTree());
        }
        return DirCache.newInCore();
    }

    private ObjectId saveCert(ObjectInserter inserter, DirCache dc, PendingCert pc, ObjectId curr) throws IOException {
        HashMap<String, ReceiveCommand> byRef;
        if (pc.matching != null) {
            byRef = new HashMap<String, ReceiveCommand>();
            for (ReceiveCommand cmd : pc.matching) {
                if (byRef.put(cmd.getRefName(), cmd) == null) continue;
                throw new IllegalStateException();
            }
        } else {
            byRef = null;
        }
        DirCacheEditor editor = dc.editor();
        String certText = String.valueOf(pc.cert.toText()) + pc.cert.getSignature();
        final ObjectId certId = inserter.insert(3, certText.getBytes(StandardCharsets.UTF_8));
        boolean any = false;
        for (ReceiveCommand cmd : pc.cert.getCommands()) {
            if (byRef != null && !PushCertificateStore.commandsEqual(cmd, (ReceiveCommand)byRef.get(cmd.getRefName()))) continue;
            any = true;
            editor.add(new DirCacheEditor.PathEdit(PushCertificateStore.pathName(cmd.getRefName())){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId(certId);
                }
            });
        }
        if (!any) {
            return curr;
        }
        editor.finish();
        CommitBuilder cb = new CommitBuilder();
        cb.setAuthor(pc.ident);
        cb.setCommitter(pc.ident);
        cb.setTreeId(dc.writeTree(inserter));
        if (curr != null) {
            cb.setParentId(curr);
        } else {
            cb.setParentIds(Collections.emptyList());
        }
        cb.setMessage(PushCertificateStore.buildMessage(pc.cert));
        return inserter.insert(1, cb.build());
    }

    private static boolean commandsEqual(ReceiveCommand c1, ReceiveCommand c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.getRefName().equals(c2.getRefName()) && c1.getOldId().equals(c2.getOldId()) && c1.getNewId().equals(c2.getNewId());
    }

    private RefUpdate.Result updateRef(ObjectId newId) throws IOException {
        RefUpdate ru = this.db.updateRef(REF_NAME);
        ru.setExpectedOldObjectId(this.commit != null ? this.commit : ObjectId.zeroId());
        ru.setNewObjectId(newId);
        ru.setRefLogIdent(this.pending.get((int)(this.pending.size() - 1)).ident);
        ru.setRefLogMessage(JGitText.get().storePushCertReflog, false);
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(this.reader);){
            return ru.update(rw);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private TreeWalk newTreeWalk(String refName) throws IOException {
        if (this.commit == null) {
            return null;
        }
        return TreeWalk.forPath(this.reader, PushCertificateStore.pathName(refName), this.commit.getTree());
    }

    static String pathName(String refName) {
        return String.valueOf(refName) + "@{cert}";
    }

    private static String buildMessage(PushCertificate cert) {
        StringBuilder sb = new StringBuilder();
        if (cert.getCommands().size() == 1) {
            sb.append(MessageFormat.format(JGitText.get().storePushCertOneRef, cert.getCommands().get(0).getRefName()));
        } else {
            sb.append(MessageFormat.format(JGitText.get().storePushCertMultipleRefs, cert.getCommands().size()));
        }
        return sb.append('\n').toString();
    }

    private static class PendingCert {
        PushCertificate cert;
        PersonIdent ident;
        Collection<ReceiveCommand> matching;

        PendingCert(PushCertificate cert, PersonIdent ident, Collection<ReceiveCommand> matching) {
            this.cert = cert;
            this.ident = ident;
            this.matching = matching;
        }
    }
}

