/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.TransportException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.BasePackFetchConnection;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.PackTransport;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.UploadPack;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.resolver.UploadPackFactory;

class InternalFetchConnection<C>
extends BasePackFetchConnection {
    private Thread worker;

    public InternalFetchConnection(PackTransport transport, final UploadPackFactory<C> uploadPackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream(){
                {
                    this.buffer = new byte[2952];
                }
            };
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Upload-Pack"){

            @Override
            public void run() {
                try {
                    try {
                        UploadPack rp = uploadPackFactory.create(req, remote);
                        rp.upload(out_r, in_w, null);
                    }
                    catch (ServiceNotAuthorizedException | ServiceNotEnabledException rp) {
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        remote.close();
                    }
                    catch (IOException | RuntimeException err) {
                        err.printStackTrace();
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        remote.close();
                    }
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException iOException) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    @Override
    public void close() {
        super.close();
        try {
            try {
                if (this.worker != null) {
                    this.worker.join();
                }
            }
            catch (InterruptedException interruptedException) {
                this.worker = null;
            }
        }
        finally {
            this.worker = null;
        }
    }
}

