/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.lib;

import java.text.MessageFormat;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.InvalidConfigurationException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.StoredConfig;

public final class AbbrevConfig {
    private static final String VALUE_NO = "no";
    private static final String VALUE_AUTO = "auto";
    public static final int MIN_ABBREV = 4;
    public static final AbbrevConfig NO = new AbbrevConfig(40);
    private int abbrev;

    public static int capAbbrev(int len) {
        return Math.min(Math.max(4, len), 40);
    }

    public static AbbrevConfig parseFromConfig(Repository repo) throws InvalidConfigurationException {
        StoredConfig config = repo.getConfig();
        String value = config.getString("core", null, "abbrev");
        if (value == null || value.equalsIgnoreCase(VALUE_AUTO)) {
            return AbbrevConfig.auto(repo);
        }
        if (value.equalsIgnoreCase(VALUE_NO)) {
            return NO;
        }
        try {
            int len = config.getIntInRange("core", "abbrev", 4, 40, Integer.MIN_VALUE);
            if (len == Integer.MIN_VALUE) {
                len = 7;
            }
            return new AbbrevConfig(len);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().invalidCoreAbbrev, value), e);
        }
    }

    private static AbbrevConfig auto(Repository repo) {
        long count = repo.getObjectDatabase().getApproximateObjectCount();
        if (count == -1L) {
            return new AbbrevConfig(7);
        }
        int len = 63 - Long.numberOfLeadingZeros(count) + 1;
        len = (len + 1) / 2;
        return new AbbrevConfig(Math.max(len, 7));
    }

    private AbbrevConfig(int abbrev) {
        this.abbrev = AbbrevConfig.capAbbrev(abbrev);
    }

    public int get() {
        return this.abbrev;
    }

    public String toString() {
        return Integer.toString(this.abbrev);
    }
}

