/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.hooks;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.AbortedByHookException;
import net.pcal.fastback.shaded.org.eclipse.jgit.hooks.GitHook;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.RemoteRefUpdate;

public class PrePushHook
extends GitHook<String> {
    public static final String NAME = "pre-push";
    private String remoteName;
    private String remoteLocation;
    private String refs;
    private boolean dryRun;

    protected PrePushHook(Repository repo, PrintStream outputStream) {
        super(repo, outputStream);
    }

    protected PrePushHook(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        super(repo, outputStream, errorStream);
    }

    @Override
    protected String getStdinArgs() {
        return this.refs;
    }

    @Override
    public String call() throws IOException, AbortedByHookException {
        if (this.canRun()) {
            this.doRun();
        }
        return "";
    }

    private boolean canRun() {
        return true;
    }

    @Override
    public String getHookName() {
        return NAME;
    }

    @Override
    protected String[] getParameters() {
        if (this.remoteName == null) {
            this.remoteName = this.remoteLocation;
        }
        return new String[]{this.remoteName, this.remoteLocation};
    }

    public void setRemoteName(String name) {
        this.remoteName = name;
    }

    protected String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteLocation(String location) {
        this.remoteLocation = location;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    protected boolean isDryRun() {
        return this.dryRun;
    }

    public void setRefs(Collection<RemoteRefUpdate> toRefs) {
        StringBuilder b = new StringBuilder();
        for (RemoteRefUpdate u : toRefs) {
            b.append(u.getSrcRef());
            b.append(" ");
            b.append(u.getNewObjectId().getName());
            b.append(" ");
            b.append(u.getRemoteName());
            b.append(" ");
            ObjectId ooid = u.getExpectedOldObjectId();
            b.append(ooid == null ? ObjectId.zeroId().getName() : ooid.getName());
            b.append("\n");
        }
        this.refs = b.toString();
    }
}

